/*
 * Decompiled with CFR 0.152.
 */
package com.skytechbytes.playerstatuebuilder.builder;

import com.skytechbytes.playerstatuebuilder.builder.ColorMaps;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.bukkit.Material;

public class Reader {
    public static Color pixel(int pixel) {
        int alpha = pixel >> 24 & 0xFF;
        int red = pixel >> 16 & 0xFF;
        int green = pixel >> 8 & 0xFF;
        int blue = pixel & 0xFF;
        return new Color(red, green, blue, alpha);
    }

    public BufferedImage read() throws IOException {
        BufferedImage bi = ImageIO.read(new File("str2.png"));
        return bi;
    }

    public Material[][] part(BufferedImage bi) {
        return this.part(bi, 0, 0, bi.getWidth(), bi.getHeight());
    }

    public Material[][] part(BufferedImage bi, int lx, int ly, int sx, int sy) {
        try {
            bi = bi.getSubimage(lx, ly, sx, sy);
        }
        catch (Exception e) {
            return null;
        }
        Material[][] mats = new Material[bi.getHeight()][bi.getWidth()];
        for (int y = 0; y < bi.getHeight(); ++y) {
            for (int x = 0; x < bi.getWidth(); ++x) {
                Color val = Reader.pixel(bi.getRGB(x, y));
                mats[y][x] = ColorMaps.getMatchingMaterial(val.getRed(), val.getGreen(), val.getBlue(), val.getAlpha());
            }
        }
        return mats;
    }
}

