/*
 * Decompiled with CFR 0.152.
 */
package com.skytechbytes.playerstatuebuilder.builder;

import com.skytechbytes.playerstatuebuilder.Log;
import com.skytechbytes.playerstatuebuilder.builder.MaterialHolder;
import java.util.HashMap;
import java.util.Stack;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class Schematic {
    public static Stack<Schematic> history = new Stack();
    private final HashMap<Integer, HashMap<Integer, HashMap<Integer, MaterialHolder>>> matrix = new HashMap();
    private final World w;
    private int count = 0;
    int maxX = Integer.MIN_VALUE;
    int maxY = Integer.MIN_VALUE;
    int maxZ = Integer.MIN_VALUE;
    int minX = Integer.MAX_VALUE;
    int minY = Integer.MAX_VALUE;
    int minZ = Integer.MAX_VALUE;

    public Schematic(World w) {
        this.w = w;
    }

    public void setBlockAt(int x, int y, int z, Material m) {
        if (x > this.maxX) {
            this.maxX = x;
        }
        if (y > this.maxY) {
            this.maxY = y;
        }
        if (z > this.maxZ) {
            this.maxZ = z;
        }
        if (x < this.minX) {
            this.minX = x;
        }
        if (y < this.minY) {
            this.minY = y;
        }
        if (z < this.minZ) {
            this.minZ = z;
        }
        if (!this.matrix.containsKey(z)) {
            this.matrix.put(z, new HashMap());
        }
        if (!this.matrix.get(z).containsKey(y)) {
            this.matrix.get(z).put(y, new HashMap());
        }
        if (!this.matrix.get(z).get(y).containsKey(x)) {
            this.matrix.get(z).get(y).put(x, new MaterialHolder(Material.AIR));
        }
        Material previous = this.matrix.get(z).get(y).get(x).getM();
        MaterialHolder replacement = new MaterialHolder(m);
        this.matrix.get(z).get(y).put(x, replacement);
        if (previous == Material.AIR && replacement.getM() != Material.AIR) {
            ++this.count;
        }
    }

    public boolean createSchematic(boolean eraseMode, boolean replaceAirOnly) {
        for (int keyZ : this.matrix.keySet()) {
            for (int keyY : this.matrix.get(keyZ).keySet()) {
                for (int keyX : this.matrix.get(keyZ).get(keyY).keySet()) {
                    MaterialHolder mat = this.matrix.get(keyZ).get(keyY).get(keyX);
                    if (mat.getM().equals((Object)Material.AIR)) continue;
                    Block b = this.w.getBlockAt(new Location(this.w, (double)keyX, (double)keyY, (double)keyZ));
                    if (replaceAirOnly && !b.getType().equals((Object)Material.AIR)) continue;
                    if (eraseMode && mat.isSuccess() && b.getBlockData().getMaterial().equals((Object)this.matrix.get(keyZ).get(keyY).get(keyX).getM())) {
                        b.setType(Material.AIR);
                        continue;
                    }
                    if (eraseMode) continue;
                    b.setType(this.matrix.get(keyZ).get(keyY).get(keyX).getM());
                    mat.setSuccess(true);
                }
            }
        }
        if (!eraseMode) {
            Log.log("Statue Created");
            history.add(this);
        }
        return true;
    }

    public HashMap<Integer, HashMap<Integer, HashMap<Integer, MaterialHolder>>> getMatrix() {
        return this.matrix;
    }

    public int getCount() {
        return this.count;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public World getWorld() {
        return this.w;
    }
}

