/*
 * Decompiled with CFR 0.152.
 */
package com.skytechbytes.playerstatuebuilder.builder;

import com.skytechbytes.playerstatuebuilder.LegacyConverter;
import com.skytechbytes.playerstatuebuilder.Log;
import com.skytechbytes.playerstatuebuilder.PlayerStatueBuilderException;
import com.skytechbytes.playerstatuebuilder.StatueArgs;
import com.skytechbytes.playerstatuebuilder.builder.AssetManager;
import com.skytechbytes.playerstatuebuilder.builder.ColorMaps;
import com.skytechbytes.playerstatuebuilder.builder.FaceBuilder;
import com.skytechbytes.playerstatuebuilder.builder.ImageUtil;
import com.skytechbytes.playerstatuebuilder.builder.Reader;
import com.skytechbytes.playerstatuebuilder.builder.Schematic;
import java.awt.Color;
import java.awt.image.BufferedImage;
import org.bukkit.Location;
import org.bukkit.scheduler.BukkitRunnable;

public class StatueMaker
extends BukkitRunnable {
    private final Schematic s;
    private final Location origin;
    private BufferedImage bi;
    private final String mode;
    private final StatueArgs params;
    private final String direction;

    public StatueMaker(Location origin, String direction, String mode, BufferedImage bi, StatueArgs params) {
        this.s = new Schematic(origin.getWorld());
        this.bi = bi;
        this.mode = mode;
        this.direction = direction;
        this.params = params;
        this.origin = origin;
    }

    private void initialize() {
        FaceBuilder.minor_orientation = 0;
        String d = this.direction;
        if (d.equalsIgnoreCase("North")) {
            FaceBuilder.minor_orientation = 1;
        } else if (d.equalsIgnoreCase("East")) {
            FaceBuilder.minor_orientation = 2;
        } else if (d.equalsIgnoreCase("West")) {
            FaceBuilder.minor_orientation = 3;
        } else if (d.equalsIgnoreCase("South")) {
            FaceBuilder.minor_orientation = 0;
        }
    }

    protected void generateStatueSchematic() throws Exception {
        ColorMaps.getActiveColorMaps().clear();
        if (this.params.hasFlag("wool")) {
            ColorMaps.getActiveColorMaps().add(0);
        }
        if (this.params.hasFlag("planks")) {
            ColorMaps.getActiveColorMaps().add(1);
        }
        if (this.params.hasFlag("terracotta")) {
            ColorMaps.getActiveColorMaps().add(2);
        }
        if (this.params.hasFlag("concrete")) {
            ColorMaps.getActiveColorMaps().add(3);
        }
        if (this.params.hasFlag("glass")) {
            ColorMaps.getActiveColorMaps().add(4);
        }
        if (this.params.hasFlag("gray")) {
            ColorMaps.getActiveColorMaps().add(5);
        }
        if (ColorMaps.getActiveColorMaps().size() == 0) {
            ColorMaps.getActiveColorMaps().add(0);
            ColorMaps.getActiveColorMaps().add(1);
            ColorMaps.getActiveColorMaps().add(2);
            ColorMaps.getActiveColorMaps().add(3);
        }
        FaceBuilder.master_orientation = this.params.hasFlag("xy") ? 0 : (this.params.hasFlag("xz") ? 2 : (this.params.hasFlag("yz") ? 1 : 0));
        if (this.mode.equals("default")) {
            this.makeStatueSchematic(this.origin, this.bi);
        } else if (this.mode.equals("slim")) {
            this.makeSlimStatueSchematic(this.origin, this.bi);
        } else if (this.mode.equals("legacy")) {
            this.makeLegacyStatueSchematic(this.origin, this.bi);
        } else {
            this.makeStatueSchematic(this.origin, this.bi);
        }
    }

    protected void createStatue() {
        Log.log("Creating Structure...");
        this.s.createSchematic(false, false);
    }

    public void run() {
        try {
            this.generateStatueSchematic();
            this.createStatue();
        }
        catch (PlayerStatueBuilderException psbe) {
            Log.log(psbe.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private BufferedImage preProcessing(Location l, BufferedImage ss) throws Exception {
        BufferedImage customizedImage = ImageUtil.deepCopy(ss);
        try {
            customizedImage = ImageUtil.applyFilters(customizedImage, this.params.getContrast(), this.params.getBrightness(), this.params.getSaturation(), this.params.getHue(), this.params.getPosterize());
        }
        catch (IllegalArgumentException e) {
            throw new PlayerStatueBuilderException(e.getMessage());
        }
        for (String key : AssetManager.armor.keySet()) {
            if (!this.params.hasFlag(key)) continue;
            customizedImage = ImageUtil.overlayImage(customizedImage, AssetManager.armor.get(key));
        }
        return customizedImage;
    }

    private void right_leg(FaceBuilder fb, Reader r, Location l, BufferedImage ss) throws Exception {
        fb.buildFace(l, r.part(ss, 8, 16, 4, 4), 1, 0, 1, -3, false, true);
        fb.buildFace(l, r.part(ss, 0, 20, 4, 12), 2, 0, 0, -3);
        fb.buildFace(l, r.part(ss, 12, 20, 4, 12), 0, 0, 0, -3, true, false);
        fb.buildFace(l, r.part(ss, 4, 20, 4, 12), 0, 0, 0, 0);
        fb.buildFace(l, r.part(ss, 8, 32, 4, 4), 1, 0, 0, -3, false, true);
        fb.buildFace(l, r.part(ss, 0, 36, 4, 12), 2, -1, 0, -3);
        fb.buildFace(l, r.part(ss, 12, 36, 4, 12), 0, 0, 0, -4, true, false);
        fb.buildFace(l, r.part(ss, 4, 36, 4, 12), 0, 0, 0, 1);
    }

    private void left_leg(FaceBuilder fb, Reader r, Location l, BufferedImage ss) throws Exception {
        fb.buildFace(l, r.part(ss, 24, 48, 4, 4), 1, 4, 1, -3, false, true);
        fb.buildFace(l, r.part(ss, 24, 52, 4, 12), 2, 7, 0, -3, true, false);
        fb.buildFace(l, r.part(ss, 28, 52, 4, 12), 0, 4, 0, -3, true, false);
        fb.buildFace(l, r.part(ss, 20, 52, 4, 12), 0, 4, 0, 0);
        fb.buildFace(l, r.part(ss, 8, 48, 4, 4), 1, 4, 0, -3, false, true);
        fb.buildFace(l, r.part(ss, 8, 52, 4, 12), 2, 8, 0, -3, true, false);
        fb.buildFace(l, r.part(ss, 12, 52, 4, 12), 0, 4, 0, -4, true, false);
        fb.buildFace(l, r.part(ss, 4, 52, 4, 12), 0, 4, 0, 1);
    }

    private void body(FaceBuilder fb, Reader r, Location l, BufferedImage ss) throws Exception {
        fb.buildFace(l, r.part(ss, 20, 20, 8, 12), 0, 0, 12, 0);
        fb.buildFace(l, r.part(ss, 32, 20, 8, 12), 0, 0, 12, -3, true, false);
        fb.buildFace(l, r.part(ss, 20, 36, 8, 12), 0, 0, 12, 1);
        fb.buildFace(l, r.part(ss, 32, 36, 8, 12), 0, 0, 12, -4, true, false);
    }

    private void right_arm(FaceBuilder fb, Reader r, Location l, BufferedImage ss) throws Exception {
        fb.buildFace(l, r.part(ss, 48, 16, 4, 4), 1, -4, 13, -3, false, true);
        fb.buildFace(l, r.part(ss, 40, 20, 4, 12), 2, -4, 12, -3);
        fb.buildFace(l, r.part(ss, 44, 16, 4, 4), 1, -4, 24, -3);
        fb.buildFace(l, r.part(ss, 52, 20, 4, 12), 0, -4, 12, -3, true, false);
        fb.buildFace(l, r.part(ss, 44, 20, 4, 12), 0, -4, 12, 0);
        fb.buildFace(l, r.part(ss, 48, 32, 4, 4), 1, -4, 12, -3, false, true);
        fb.buildFace(l, r.part(ss, 40, 36, 4, 12), 2, -5, 12, -3);
        fb.buildFace(l, r.part(ss, 44, 32, 4, 4), 1, -4, 25, -3);
        fb.buildFace(l, r.part(ss, 52, 36, 4, 12), 0, -4, 12, -4, true, false);
        fb.buildFace(l, r.part(ss, 44, 36, 4, 12), 0, -4, 12, 1);
    }

    private void left_arm(FaceBuilder fb, Reader r, Location l, BufferedImage ss) throws Exception {
        fb.buildFace(l, r.part(ss, 40, 48, 4, 4), 1, 8, 13, -3, false, true);
        fb.buildFace(l, r.part(ss, 40, 52, 4, 12), 2, 11, 12, -3, true, false);
        fb.buildFace(l, r.part(ss, 36, 48, 4, 4), 1, 8, 24, -3);
        fb.buildFace(l, r.part(ss, 44, 52, 4, 12), 0, 8, 12, -3, true, false);
        fb.buildFace(l, r.part(ss, 36, 52, 4, 12), 0, 8, 12, 0);
        fb.buildFace(l, r.part(ss, 56, 48, 4, 4), 1, 8, 12, -3, false, true);
        fb.buildFace(l, r.part(ss, 56, 52, 4, 12), 2, 12, 12, -3, true, false);
        fb.buildFace(l, r.part(ss, 52, 48, 4, 4), 1, 8, 25, -3);
        fb.buildFace(l, r.part(ss, 60, 52, 4, 12), 0, 8, 12, -4, true, false);
        fb.buildFace(l, r.part(ss, 52, 52, 4, 12), 0, 8, 12, 1);
    }

    private void head(FaceBuilder fb, Reader r, Location l, BufferedImage ss) throws Exception {
        fb.buildFace(l, r.part(ss, 16, 0, 8, 8), 1, 0, 25, -5, false, true);
        fb.buildFace(l, r.part(ss, 0, 8, 8, 8), 2, 0, 24, -5);
        fb.buildFace(l, r.part(ss, 16, 8, 8, 8), 2, 7, 24, -5, true, false);
        fb.buildFace(l, r.part(ss, 8, 0, 8, 8), 1, 0, 32, -5);
        fb.buildFace(l, r.part(ss, 24, 8, 8, 8), 0, 0, 24, -5, true, false);
        fb.buildFace(l, r.part(ss, 8, 8, 8, 8), 0, 0, 24, 2);
        fb.buildFace(l, r.part(ss, 32, 8, 8, 8), 2, -1, 24, -5);
        fb.buildFace(l, r.part(ss, 48, 8, 8, 8), 2, 8, 24, -5, true, false);
        fb.buildFace(l, r.part(ss, 40, 0, 8, 8), 1, 0, 33, -5);
        fb.buildFace(l, r.part(ss, 56, 8, 8, 8), 0, 0, 24, -6, true, false);
        fb.buildFace(l, r.part(ss, 40, 8, 8, 8), 0, 0, 24, 3);
    }

    private void right_arm_slim(FaceBuilder fb, Reader r, Location l, BufferedImage ss) throws Exception {
        fb.buildFace(l, r.part(ss, 47, 16, 3, 4), 1, -3, 13, -3, false, true);
        fb.buildFace(l, r.part(ss, 40, 20, 4, 12), 2, -3, 12, -3);
        fb.buildFace(l, r.part(ss, 44, 16, 3, 4), 1, -3, 24, -3);
        fb.buildFace(l, r.part(ss, 51, 20, 3, 12), 0, -3, 12, -3, true, false);
        fb.buildFace(l, r.part(ss, 44, 20, 3, 12), 0, -3, 12, 0);
        fb.buildFace(l, r.part(ss, 47, 32, 3, 4), 1, -3, 12, -3, false, true);
        fb.buildFace(l, r.part(ss, 40, 36, 4, 12), 2, -4, 12, -3);
        fb.buildFace(l, r.part(ss, 44, 32, 3, 4), 1, -3, 25, -3);
        fb.buildFace(l, r.part(ss, 51, 36, 3, 12), 0, -3, 12, -4, true, false);
        fb.buildFace(l, r.part(ss, 44, 36, 3, 12), 0, -3, 12, 1);
    }

    private void left_arm_slim(FaceBuilder fb, Reader r, Location l, BufferedImage ss) throws Exception {
        fb.buildFace(l, r.part(ss, 39, 48, 3, 4), 1, 8, 13, -3, false, true);
        fb.buildFace(l, r.part(ss, 39, 52, 4, 12), 2, 10, 12, -3, true, false);
        fb.buildFace(l, r.part(ss, 36, 48, 3, 4), 1, 8, 24, -3);
        fb.buildFace(l, r.part(ss, 43, 52, 3, 12), 0, 8, 12, -3, true, false);
        fb.buildFace(l, r.part(ss, 36, 52, 3, 12), 0, 8, 12, 0);
        fb.buildFace(l, r.part(ss, 55, 48, 3, 4), 1, 8, 12, -3, false, true);
        fb.buildFace(l, r.part(ss, 55, 52, 4, 12), 2, 11, 12, -3, true, false);
        fb.buildFace(l, r.part(ss, 52, 48, 3, 4), 1, 8, 25, -3);
        fb.buildFace(l, r.part(ss, 59, 52, 3, 12), 0, 8, 12, -4, true, false);
        fb.buildFace(l, r.part(ss, 52, 52, 3, 12), 0, 8, 12, 1);
    }

    private boolean isSlimSkin(BufferedImage xx) {
        if (xx.getWidth() < 64 || xx.getHeight() < 64) {
            return false;
        }
        if (new Color(xx.getRGB(54, 20), true).getAlpha() < 255) {
            return true;
        }
        return new Color(xx.getRGB(46, 52), true).getAlpha() < 255;
    }

    private void makeStatueSchematic(Location l, BufferedImage xx) throws Exception {
        this.initialize();
        if (xx.getHeight() < 64) {
            this.makeStatueSchematic(l, LegacyConverter.convertLegacy(xx, false));
            return;
        }
        if (this.isSlimSkin(xx)) {
            this.makeSlimStatueSchematic(l, xx);
            return;
        }
        BufferedImage ss = this.preProcessing(l, xx);
        FaceBuilder fb = new FaceBuilder(this.s);
        Reader r = new Reader();
        boolean builtSomething = false;
        if (this.params.hasFlag("right_leg")) {
            this.right_leg(fb, r, l, ss);
            builtSomething = true;
        }
        if (this.params.hasFlag("left_leg")) {
            this.left_leg(fb, r, l, ss);
            builtSomething = true;
        }
        if (this.params.hasFlag("body")) {
            this.body(fb, r, l, ss);
            builtSomething = true;
        }
        if (this.params.hasFlag("right_arm")) {
            this.right_arm(fb, r, l, ss);
            builtSomething = true;
        }
        if (this.params.hasFlag("left_arm")) {
            this.left_arm(fb, r, l, ss);
            builtSomething = true;
        }
        if (this.params.hasFlag("head")) {
            this.head(fb, r, l, ss);
            builtSomething = true;
        }
        if (!builtSomething) {
            this.right_leg(fb, r, l, ss);
            this.left_leg(fb, r, l, ss);
            this.body(fb, r, l, ss);
            this.right_arm(fb, r, l, ss);
            this.left_arm(fb, r, l, ss);
            this.head(fb, r, l, ss);
        }
    }

    private void makeSlimStatueSchematic(Location l, BufferedImage xx) throws Exception {
        this.initialize();
        if (xx.getHeight() < 64) {
            this.makeSlimStatueSchematic(l, LegacyConverter.convertLegacy(xx, true));
            return;
        }
        BufferedImage ss = this.preProcessing(l, xx);
        FaceBuilder fb = new FaceBuilder(this.s);
        Reader r = new Reader();
        boolean builtSomething = false;
        if (this.params.hasFlag("right_leg")) {
            this.right_leg(fb, r, l, ss);
            builtSomething = true;
        }
        if (this.params.hasFlag("left_leg")) {
            this.left_leg(fb, r, l, ss);
            builtSomething = true;
        }
        if (this.params.hasFlag("body")) {
            this.body(fb, r, l, ss);
            builtSomething = true;
        }
        if (this.params.hasFlag("right_arm")) {
            this.right_arm_slim(fb, r, l, ss);
            builtSomething = true;
        }
        if (this.params.hasFlag("left_arm")) {
            this.left_arm_slim(fb, r, l, ss);
            builtSomething = true;
        }
        if (this.params.hasFlag("head")) {
            this.head(fb, r, l, ss);
            builtSomething = true;
        }
        if (!builtSomething) {
            this.right_leg(fb, r, l, ss);
            this.left_leg(fb, r, l, ss);
            this.body(fb, r, l, ss);
            this.right_arm_slim(fb, r, l, ss);
            this.left_arm_slim(fb, r, l, ss);
            this.head(fb, r, l, ss);
        }
    }

    private void makeLegacyStatueSchematic(Location l, BufferedImage ss) throws Exception {
        this.makeStatueSchematic(l, LegacyConverter.convertLegacy(ss, false));
    }

    protected StatueArgs getParams() {
        return this.params;
    }

    protected Schematic getSchematic() {
        return this.s;
    }

    public void setImage(BufferedImage bi) {
        this.bi = bi;
    }

    public BufferedImage getImage() {
        return this.bi;
    }
}

