/*
 * Decompiled with CFR 0.152.
 */
package com.skytechbytes.playerstatuebuilder.support;

import com.plotsquared.bukkit.BukkitPlatform;
import com.plotsquared.bukkit.util.BukkitUtil;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.Plot;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.skytechbytes.playerstatuebuilder.Log;
import com.skytechbytes.playerstatuebuilder.PlayerStatueBuilder;
import com.skytechbytes.playerstatuebuilder.PlayerStatueBuilderException;
import org.bukkit.entity.Player;

public class PlotSquaredWrapper {
    private final BukkitPlatform plotSquared = (BukkitPlatform)PlayerStatueBuilder.instance.getServer().getPluginManager().getPlugin("PlotSquared");

    public PlotSquaredWrapper() throws Exception {
        if (this.plotSquared == null) {
            throw new PlayerStatueBuilderException("");
        }
        Log.log("PlotSquared detected!");
    }

    public boolean canBuild(org.bukkit.Location lesserCorner, org.bukkit.Location greaterCorner, Player creatingPlayer) {
        if (this.plotSquared == null) {
            return true;
        }
        Log.log("Checking permissions");
        try {
            Location plotSquaredlesserCorner = BukkitUtil.adapt((org.bukkit.Location)lesserCorner);
            Location plotSquaredGreaterCorner = BukkitUtil.adapt((org.bukkit.Location)greaterCorner);
            Plot plot = Plot.getPlot((Location)plotSquaredlesserCorner);
            if (plot == null) {
                return false;
            }
            if (!plot.isOwner(creatingPlayer.getUniqueId()) && !plot.isAdded(creatingPlayer.getUniqueId())) {
                return false;
            }
            boolean statueContainedInOneRegion = false;
            for (CuboidRegion region : plot.getRegions()) {
                BlockVector3 regionLesserCorner = region.getMinimumPoint();
                BlockVector3 regionGreaterCorner = region.getMaximumPoint();
                assert (regionLesserCorner.getBlockX() <= regionGreaterCorner.getBlockX());
                assert (regionLesserCorner.getBlockY() <= regionGreaterCorner.getBlockY());
                assert (regionLesserCorner.getBlockZ() <= regionGreaterCorner.getBlockZ());
                assert (lesserCorner.getBlockX() <= greaterCorner.getBlockX());
                assert (lesserCorner.getBlockY() <= greaterCorner.getBlockY());
                assert (lesserCorner.getBlockZ() <= greaterCorner.getBlockZ());
                if (lesserCorner.getBlockX() <= regionLesserCorner.getBlockX() || lesserCorner.getBlockY() <= regionLesserCorner.getBlockY() || lesserCorner.getBlockZ() <= regionLesserCorner.getBlockZ() || greaterCorner.getBlockX() >= regionGreaterCorner.getBlockX() || greaterCorner.getBlockY() >= regionGreaterCorner.getBlockY() || greaterCorner.getBlockZ() >= regionGreaterCorner.getBlockZ()) continue;
                statueContainedInOneRegion = true;
            }
            return statueContainedInOneRegion;
        }
        catch (Throwable sandal) {
            sandal.printStackTrace();
            return false;
        }
    }
}

