/*
 * Decompiled with CFR 0.152.
 */
package com.skytechbytes.playerstatuebuilder.support;

import com.skytechbytes.playerstatuebuilder.Log;
import com.skytechbytes.playerstatuebuilder.PlayerStatueBuilder;
import com.skytechbytes.playerstatuebuilder.PlayerStatueBuilderException;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultWrapper {
    private Economy econ = null;
    private final Permission perms = null;
    private final Chat chat = null;
    private final PlayerStatueBuilder p = PlayerStatueBuilder.instance;

    public VaultWrapper() throws Exception {
        if (!this.setupEconomy()) {
            Log.log("Vault with economy provider not detected. You MUST have the Vault Plugin if you want PlayerStatueBuilderX to interact with the economy.");
            throw new PlayerStatueBuilderException("");
        }
        Log.log("Vault detected!");
    }

    private boolean setupEconomy() {
        if (this.p.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.p.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            Log.log("Vault detected, but no vault economy provider detected!");
            return false;
        }
        this.econ = (Economy)rsp.getProvider();
        return this.econ != null;
    }

    public Economy getEconomy() {
        return this.econ;
    }

    public Permission getPermissions() {
        return this.perms;
    }

    public Chat getChat() {
        return this.chat;
    }
}

