/*
 * Decompiled with CFR 0.152.
 */
package com.rylinaux.lib.folialib.impl;

import com.rylinaux.lib.folialib.FoliaLib;
import com.rylinaux.lib.folialib.enums.EntityTaskResult;
import com.rylinaux.lib.folialib.impl.ServerImplementation;
import com.rylinaux.lib.folialib.util.TimeConverter;
import com.rylinaux.lib.folialib.wrapper.WrappedTask;
import com.rylinaux.lib.folialib.wrapper.task.WrappedBukkitTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.jetbrains.annotations.NotNull;

public class SpigotImplementation
implements ServerImplementation {
    private final JavaPlugin plugin;
    @NotNull
    private final BukkitScheduler scheduler;

    public SpigotImplementation(FoliaLib foliaLib) {
        this.plugin = foliaLib.getPlugin();
        this.scheduler = this.plugin.getServer().getScheduler();
    }

    @Override
    public CompletableFuture<Void> runNextTick(Runnable runnable) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.scheduler.runTask((Plugin)this.plugin, () -> {
            runnable.run();
            future.complete(null);
        });
        return future;
    }

    @Override
    public CompletableFuture<Void> runAsync(Runnable runnable) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.scheduler.runTaskAsynchronously((Plugin)this.plugin, () -> {
            runnable.run();
            future.complete(null);
        });
        return future;
    }

    @Override
    public WrappedTask runLater(Runnable runnable, long delay, TimeUnit unit) {
        return new WrappedBukkitTask(this.scheduler.runTaskLater((Plugin)this.plugin, runnable, TimeConverter.toTicks(delay, unit)));
    }

    @Override
    public WrappedTask runLaterAsync(Runnable runnable, long delay, TimeUnit unit) {
        return new WrappedBukkitTask(this.scheduler.runTaskLaterAsynchronously((Plugin)this.plugin, runnable, TimeConverter.toTicks(delay, unit)));
    }

    @Override
    public WrappedTask runTimer(Runnable runnable, long delay, long period, TimeUnit unit) {
        return new WrappedBukkitTask(this.scheduler.runTaskTimer((Plugin)this.plugin, runnable, TimeConverter.toTicks(delay, unit), TimeConverter.toTicks(period, unit)));
    }

    @Override
    public WrappedTask runTimerAsync(Runnable runnable, long delay, long period, TimeUnit unit) {
        return new WrappedBukkitTask(this.scheduler.runTaskTimerAsynchronously((Plugin)this.plugin, runnable, TimeConverter.toTicks(delay, unit), TimeConverter.toTicks(period, unit)));
    }

    @Override
    public CompletableFuture<Void> runAtLocation(Location location, Runnable runnable) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.scheduler.runTask((Plugin)this.plugin, () -> {
            runnable.run();
            future.complete(null);
        });
        return future;
    }

    @Override
    public WrappedTask runAtLocationLater(Location location, Runnable runnable, long delay, TimeUnit unit) {
        return new WrappedBukkitTask(this.scheduler.runTaskLater((Plugin)this.plugin, runnable, TimeConverter.toTicks(delay, unit)));
    }

    @Override
    public WrappedTask runAtLocationTimer(Location location, Runnable runnable, long delay, long period, TimeUnit unit) {
        return new WrappedBukkitTask(this.scheduler.runTaskTimer((Plugin)this.plugin, runnable, TimeConverter.toTicks(delay, unit), TimeConverter.toTicks(period, unit)));
    }

    @Override
    public CompletableFuture<EntityTaskResult> runAtEntity(Entity entity, Runnable runnable) {
        CompletableFuture<EntityTaskResult> future = new CompletableFuture<EntityTaskResult>();
        this.scheduler.runTask((Plugin)this.plugin, () -> {
            runnable.run();
            future.complete(EntityTaskResult.SUCCESS);
        });
        return future;
    }

    @Override
    public CompletableFuture<EntityTaskResult> runAtEntityWithFallback(Entity entity, Runnable runnable, Runnable fallback) {
        CompletableFuture<EntityTaskResult> future = new CompletableFuture<EntityTaskResult>();
        this.scheduler.runTask((Plugin)this.plugin, () -> {
            if (entity.isValid()) {
                runnable.run();
                future.complete(EntityTaskResult.SUCCESS);
            } else {
                fallback.run();
                future.complete(EntityTaskResult.ENTITY_RETIRED);
            }
        });
        return future;
    }

    @Override
    public WrappedTask runAtEntityLater(Entity entity, Runnable runnable, long delay, TimeUnit unit) {
        return new WrappedBukkitTask(this.scheduler.runTaskLater((Plugin)this.plugin, runnable, TimeConverter.toTicks(delay, unit)));
    }

    @Override
    public WrappedTask runAtEntityTimer(Entity entity, Runnable runnable, long delay, long period, TimeUnit unit) {
        return new WrappedBukkitTask(this.scheduler.runTaskTimer((Plugin)this.plugin, runnable, TimeConverter.toTicks(delay, unit), TimeConverter.toTicks(period, unit)));
    }
}

