/*
 * Decompiled with CFR 0.152.
 */
package com.rylinaux.plugman.command;

import com.rylinaux.plugman.PlugMan;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;

public abstract class AbstractCommand {
    private final CommandSender sender;
    private final String name;
    private final String description;
    private final String permission;
    private final String usage;
    private final String[] subPermissions;

    public AbstractCommand(CommandSender sender, String name, String description, String permission, String[] subPermissions, String usage) {
        this.sender = sender;
        this.name = name;
        this.description = description;
        this.permission = permission;
        this.subPermissions = subPermissions;
        this.usage = usage;
    }

    public CommandSender getSender() {
        return this.sender;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPermission() {
        return this.permission;
    }

    public String[] getSubPermissions() {
        return this.subPermissions;
    }

    public String getUsage() {
        return this.usage;
    }

    public boolean hasPermission() {
        return this.sender.hasPermission(this.permission) || this.sender instanceof ConsoleCommandSender || this.sender instanceof RemoteConsoleCommandSender;
    }

    public boolean hasPermission(String sub) {
        String permission = this.permission + "." + sub;
        if (this.sender.hasPermission(permission) || this.sender instanceof ConsoleCommandSender) {
            return true;
        }
        return this.sender instanceof RemoteConsoleCommandSender;
    }

    public void sendUsage() {
        this.sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format(false, "error.usage.command", this.name));
        this.sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format(false, "error.usage.description", this.description));
        this.sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format(false, "error.usage.usage", this.usage));
    }

    public abstract void execute(CommandSender var1, Command var2, String var3, String[] var4);
}

