/*
 * Decompiled with CFR 0.152.
 */
package com.rylinaux.plugman.command;

import com.rylinaux.plugman.PlugMan;
import com.rylinaux.plugman.command.AbstractCommand;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class DumpCommand
extends AbstractCommand {
    public static final String NAME = "Dump";
    public static final String DESCRIPTION = "Dump plugins and versions to file.";
    public static final String PERMISSION = "plugman.dump";
    public static final String USAGE = "/plugman dump";
    public static final String[] SUB_PERMISSIONS = new String[]{""};

    public DumpCommand(CommandSender sender) {
        super(sender, NAME, DESCRIPTION, PERMISSION, SUB_PERMISSIONS, USAGE);
    }

    @Override
    public void execute(CommandSender sender, Command command, String label, String[] args) {
        if (!this.hasPermission()) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.no-permission", new Object[0]));
            return;
        }
        File dumpFile = new File(PlugMan.getInstance().getDataFolder(), "versions.txt");
        List<String> plugins = PlugMan.getInstance().getPluginUtil().getPluginNames(true);
        plugins.sort(String.CASE_INSENSITIVE_ORDER);
        try (PrintWriter writer = new PrintWriter(dumpFile);){
            plugins.forEach(writer::println);
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("dump.dumped", dumpFile.getName()));
        }
        catch (IOException e) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("dump.error", new Object[0]));
            e.printStackTrace();
        }
    }
}

