/*
 * Decompiled with CFR 0.152.
 */
package com.rylinaux.plugman.command;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.rylinaux.plugman.PlugMan;
import com.rylinaux.plugman.command.AbstractCommand;
import com.rylinaux.plugman.util.FlagUtil;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class ListCommand
extends AbstractCommand {
    public static final String NAME = "List";
    public static final String DESCRIPTION = "List all plugins.";
    public static final String PERMISSION = "plugman.list";
    public static final String USAGE = "/plugman list [-v]";
    public static final String[] SUB_PERMISSIONS = new String[]{""};

    public ListCommand(CommandSender sender) {
        super(sender, NAME, DESCRIPTION, PERMISSION, SUB_PERMISSIONS, USAGE);
    }

    @Override
    public void execute(CommandSender sender, Command command, String label, String[] args) {
        if (!this.hasPermission()) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.no-permission", new Object[0]));
            return;
        }
        boolean includeVersions = FlagUtil.hasFlag(args, 'v');
        ArrayList pluginList = Lists.newArrayList();
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            pluginList.add(PlugMan.getInstance().getPluginUtil().getFormattedName(plugin, includeVersions));
        }
        pluginList.sort(String.CASE_INSENSITIVE_ORDER);
        String plugins = Joiner.on((String)", ").join((Iterable)pluginList);
        sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("list.list", pluginList.size(), plugins));
    }
}

