/*
 * Decompiled with CFR 0.152.
 */
package com.rylinaux.plugman.command;

import com.rylinaux.plugman.PlugMan;
import com.rylinaux.plugman.command.AbstractCommand;
import com.rylinaux.plugman.util.StringUtil;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class LoadCommand
extends AbstractCommand {
    public static final String NAME = "Load";
    public static final String DESCRIPTION = "Load a plugin.";
    public static final String PERMISSION = "plugman.load";
    public static final String USAGE = "/plugman load <plugin>";
    public static final String[] SUB_PERMISSIONS = new String[]{""};

    public LoadCommand(CommandSender sender) {
        super(sender, NAME, DESCRIPTION, PERMISSION, SUB_PERMISSIONS, USAGE);
    }

    @Override
    public void execute(CommandSender sender, Command command, String label, String[] args) {
        if (!this.hasPermission()) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.no-permission", new Object[0]));
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.specify-plugin", new Object[0]));
            this.sendUsage();
            return;
        }
        for (int i = 1; i < args.length; ++i) {
            args[i] = args[i].replaceAll("[/\\\\]", "");
        }
        Plugin potential = PlugMan.getInstance().getPluginUtil().getPluginByName(args, 1);
        if (potential != null) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("load.already-loaded", potential.getName()));
            return;
        }
        String name = StringUtil.consolidateStrings(args, 1);
        if (PlugMan.getInstance().getPluginUtil().isIgnored(name)) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.ignored", new Object[0]));
            return;
        }
        sender.sendMessage(PlugMan.getInstance().getPluginUtil().load(name));
    }
}

