/*
 * Decompiled with CFR 0.152.
 */
package com.rylinaux.plugman.command;

import com.google.common.base.Joiner;
import com.rylinaux.plugman.PlugMan;
import com.rylinaux.plugman.command.AbstractCommand;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class LookupCommand
extends AbstractCommand {
    public static final String NAME = "Lookup";
    public static final String DESCRIPTION = "Find which plugin a command is registered to.";
    public static final String PERMISSION = "plugman.lookup";
    public static final String USAGE = "/plugman lookup <command>";
    public static final String[] SUB_PERMISSIONS = new String[]{""};

    public LookupCommand(CommandSender sender) {
        super(sender, NAME, DESCRIPTION, PERMISSION, SUB_PERMISSIONS, USAGE);
    }

    @Override
    public void execute(CommandSender sender, Command command, String label, String[] args) {
        if (!this.hasPermission()) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.no-permission", new Object[0]));
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.specify-command", new Object[0]));
            this.sendUsage();
            return;
        }
        String commandName = args[1];
        List<String> plugins = PlugMan.getInstance().getPluginUtil().findByCommand(commandName);
        if (plugins.isEmpty()) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("lookup.not-found", commandName));
            return;
        }
        sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("lookup.found", commandName, Joiner.on((String)", ").join(plugins)));
    }
}

