/*
 * Decompiled with CFR 0.152.
 */
package com.rylinaux.plugman.command;

import com.rylinaux.plugman.PlugMan;
import com.rylinaux.plugman.command.AbstractCommand;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class RestartCommand
extends AbstractCommand {
    public static final String NAME = "Restart";
    public static final String DESCRIPTION = "Restart a plugin.";
    public static final String PERMISSION = "plugman.restart";
    public static final String USAGE = "/plugman restart <plugin|all>";
    public static final String[] SUB_PERMISSIONS = new String[]{"all"};

    public RestartCommand(CommandSender sender) {
        super(sender, NAME, DESCRIPTION, PERMISSION, SUB_PERMISSIONS, USAGE);
    }

    @Override
    public void execute(CommandSender sender, Command command, String label, String[] args) {
        if (!this.hasPermission()) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.no-permission", new Object[0]));
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.specify-plugin", new Object[0]));
            this.sendUsage();
            return;
        }
        if (args[1].equalsIgnoreCase("all") || args[1].equalsIgnoreCase("*")) {
            if (!this.hasPermission("all")) {
                sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.no-permission", new Object[0]));
                return;
            }
            PlugMan.getInstance().getPluginUtil().disableAll();
            PlugMan.getInstance().getPluginUtil().enableAll();
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("restart.all", new Object[0]));
            return;
        }
        Plugin target = PlugMan.getInstance().getPluginUtil().getPluginByName(args, 1);
        if (target == null) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.invalid-plugin", new Object[0]));
            this.sendUsage();
            return;
        }
        if (PlugMan.getInstance().getPluginUtil().isIgnored(target)) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.ignored", new Object[0]));
            return;
        }
        if (PlugMan.getInstance().getPluginUtil().isPaperPlugin(target)) {
            sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("error.paper-plugin", new Object[0]));
            return;
        }
        PlugMan.getInstance().getPluginUtil().disable(target);
        PlugMan.getInstance().getPluginUtil().enable(target);
        sender.sendMessage(PlugMan.getInstance().getMessageFormatter().format("restart.restarted", target.getName()));
    }
}

