/*
 * Decompiled with CFR 0.152.
 */
package com.rylinaux.plugman.util;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.rylinaux.plugman.PlugMan;
import com.rylinaux.plugman.pojo.UpdateResult;
import com.rylinaux.plugman.util.UpdateUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class CurseForgeUtil {
    public static final String API_BASE_URL = "https://servermods.forgesvc.net/servermods/";

    public static Map<String, UpdateResult> checkUpToDate() {
        TreeMap<String, UpdateResult> results = new TreeMap<String, UpdateResult>();
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            results.put(plugin.getName(), CurseForgeUtil.checkUpToDate(plugin.getName()));
        }
        return results;
    }

    public static UpdateResult checkUpToDate(String pluginName) {
        return CurseForgeUtil.checkUpToDate(pluginName, null);
    }

    public static UpdateResult checkUpToDate(String pluginName, Long pluginId) {
        boolean idSpecified;
        boolean bl = idSpecified = pluginId != null;
        if (!idSpecified) {
            pluginId = CurseForgeUtil.getPluginId(pluginName);
        }
        if (pluginId < 0L) {
            Plugin plugin = Bukkit.getPluginManager().getPlugin(pluginName);
            if (plugin == null) {
                if (idSpecified) {
                    return new UpdateResult(UpdateResult.ResultType.INVALID_PLUGIN, pluginName);
                }
                return new UpdateResult(UpdateResult.ResultType.NOT_INSTALLED);
            }
            return new UpdateResult(UpdateResult.ResultType.INVALID_PLUGIN, plugin.getDescription().getVersion());
        }
        JSONArray versions = CurseForgeUtil.getPluginVersions(pluginId);
        if (versions == null || versions.size() == 0) {
            Plugin plugin = Bukkit.getPluginManager().getPlugin(pluginName);
            if (plugin == null) {
                if (idSpecified) {
                    return new UpdateResult(UpdateResult.ResultType.INVALID_PLUGIN, pluginName);
                }
                return new UpdateResult(UpdateResult.ResultType.NOT_INSTALLED);
            }
            return new UpdateResult(UpdateResult.ResultType.INVALID_PLUGIN, plugin.getDescription().getVersion());
        }
        JSONObject latest = (JSONObject)versions.get(versions.size() - 1);
        String currentVersion = PlugMan.getInstance().getPluginUtil().getPluginVersion(pluginName);
        if (!(Bukkit.getPluginManager().getPlugin(pluginName) instanceof JavaPlugin)) {
            if (idSpecified) {
                return new UpdateResult(UpdateResult.ResultType.INVALID_PLUGIN, currentVersion);
            }
            return new UpdateResult(UpdateResult.ResultType.INVALID_PLUGIN, currentVersion, "null");
        }
        JavaPlugin plugin = (JavaPlugin)Bukkit.getPluginManager().getPlugin(pluginName);
        if (plugin == null) {
            if (idSpecified) {
                return new UpdateResult(UpdateResult.ResultType.NOT_INSTALLED, currentVersion);
            }
            return new UpdateResult(UpdateResult.ResultType.NOT_INSTALLED, currentVersion, "null");
        }
        String latestVersion = (String)latest.get((Object)"md5");
        try {
            Method getFileMethod = JavaPlugin.class.getDeclaredMethod("getFile", new Class[0]);
            getFileMethod.setAccessible(true);
            File file = (File)getFileMethod.invoke((Object)plugin, new Object[0]);
            HashCode currentPluginHashCode = Files.asByteSource((File)file).hash(Hashing.md5());
            currentPluginHashCode.toString();
        }
        catch (IOException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return new UpdateResult(UpdateResult.ResultType.INVALID_PLUGIN, currentVersion, latestVersion);
        }
        if (latestVersion == null) {
            return new UpdateResult(UpdateResult.ResultType.INVALID_PLUGIN, currentVersion, latestVersion);
        }
        latestVersion = (String)latest.get((Object)"name");
        if (currentVersion == null) {
            return new UpdateResult(UpdateResult.ResultType.NOT_INSTALLED, currentVersion, latestVersion);
        }
        if (latestVersion == null) {
            return new UpdateResult(UpdateResult.ResultType.INVALID_PLUGIN, currentVersion, latestVersion);
        }
        Boolean isActual = UpdateUtil.isActualVersion(currentVersion, latestVersion);
        if (isActual != null && isActual.booleanValue()) {
            return new UpdateResult(UpdateResult.ResultType.UP_TO_DATE, currentVersion, latestVersion);
        }
        return new UpdateResult(UpdateResult.ResultType.OUT_OF_DATE, currentVersion, latestVersion);
    }

    public static long getPluginId(String name) {
        CloseableHttpClient client = HttpClients.createMinimal();
        HttpGet get = new HttpGet("https://servermods.forgesvc.net/servermods/projects?search=" + name.toLowerCase());
        get.setHeader("User-Agent", "PlugMan");
        try {
            HttpResponse response = client.execute(get);
            String body = IOUtils.toString(response.getEntity().getContent());
            Object object = JSONValue.parse((String)body);
            if (object instanceof JSONArray) {
                JSONArray array = (JSONArray)JSONValue.parse((String)body);
                for (Object o : array) {
                    JSONObject json = (JSONObject)o;
                    String pluginName = (String)json.get((Object)"slug");
                    if (!name.equalsIgnoreCase(pluginName)) continue;
                    return (Long)json.get((Object)"id");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return -1L;
    }

    public static JSONArray getPluginVersions(long id) {
        CloseableHttpClient client = HttpClients.createMinimal();
        HttpGet get = new HttpGet("https://servermods.forgesvc.net/servermods/files?projectIds=" + id);
        get.setHeader("User-Agent", "PlugMan");
        try {
            HttpResponse response = client.execute(get);
            String body = IOUtils.toString(response.getEntity().getContent());
            return (JSONArray)JSONValue.parse((String)body);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

