/*
 * Decompiled with CFR 0.152.
 */
package com.rylinaux.plugman.util;

import com.rylinaux.plugman.PlugMan;
import com.rylinaux.plugman.pojo.UpdateResult;
import com.rylinaux.plugman.util.UpdateUtil;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class SpiGetUtil {
    public static final String API_BASE_URL = "https://api.spiget.org/v2/";

    public static Map<String, UpdateResult> checkUpToDate() {
        TreeMap<String, UpdateResult> results = new TreeMap<String, UpdateResult>();
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            results.put(plugin.getName(), SpiGetUtil.checkUpToDate(plugin.getName()));
        }
        return results;
    }

    public static UpdateResult checkUpToDate(String pluginName) {
        return SpiGetUtil.checkUpToDate(pluginName, null);
    }

    public static UpdateResult checkUpToDate(String pluginName, Long pluginId) {
        boolean idSpecified;
        boolean bl = idSpecified = pluginId != null;
        if (!idSpecified) {
            pluginId = SpiGetUtil.getPluginId(pluginName);
        }
        if (pluginId < 0L) {
            Plugin plugin = Bukkit.getPluginManager().getPlugin(pluginName);
            if (plugin == null) {
                if (idSpecified) {
                    return new UpdateResult(UpdateResult.ResultType.INVALID_PLUGIN, pluginName);
                }
                return new UpdateResult(UpdateResult.ResultType.NOT_INSTALLED);
            }
            return new UpdateResult(UpdateResult.ResultType.INVALID_PLUGIN, plugin.getDescription().getVersion());
        }
        JSONArray versions = SpiGetUtil.getPluginVersions(pluginId);
        if (versions == null || versions.size() == 0) {
            Plugin plugin = Bukkit.getPluginManager().getPlugin(pluginName);
            if (plugin == null) {
                if (idSpecified) {
                    return new UpdateResult(UpdateResult.ResultType.INVALID_PLUGIN, pluginName);
                }
                return new UpdateResult(UpdateResult.ResultType.NOT_INSTALLED);
            }
            return new UpdateResult(UpdateResult.ResultType.INVALID_PLUGIN, plugin.getDescription().getVersion());
        }
        JSONObject latest = (JSONObject)versions.get(0);
        String currentVersion = PlugMan.getInstance().getPluginUtil().getPluginVersion(pluginName);
        String latestVersion = (String)latest.get((Object)"name");
        if (currentVersion == null) {
            return new UpdateResult(UpdateResult.ResultType.NOT_INSTALLED, currentVersion, latestVersion);
        }
        if (latestVersion == null) {
            return new UpdateResult(UpdateResult.ResultType.INVALID_PLUGIN, currentVersion, latestVersion);
        }
        Boolean isActual = UpdateUtil.isActualVersion(currentVersion, latestVersion);
        if (isActual != null && isActual.booleanValue()) {
            return new UpdateResult(UpdateResult.ResultType.UP_TO_DATE, currentVersion, latestVersion);
        }
        return new UpdateResult(UpdateResult.ResultType.OUT_OF_DATE, currentVersion, latestVersion);
    }

    public static long getPluginId(String name) {
        CloseableHttpClient client = HttpClients.createMinimal();
        HttpGet get = new HttpGet("https://api.spiget.org/v2/search/resources/" + name + "?field=name&fields=id%2Cname");
        get.setHeader("User-Agent", "PlugMan");
        try {
            HttpResponse response = client.execute(get);
            String body = IOUtils.toString(response.getEntity().getContent());
            Object object = JSONValue.parse((String)body);
            if (object instanceof JSONArray) {
                JSONArray array = (JSONArray)JSONValue.parse((String)body);
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject json = (JSONObject)array.get(i);
                    String pluginName = (String)json.get((Object)"name");
                    if (!name.equalsIgnoreCase(pluginName)) continue;
                    return (Long)json.get((Object)"id");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return -1L;
    }

    public static JSONArray getPluginVersions(long id) {
        CloseableHttpClient client = HttpClients.createMinimal();
        HttpGet get = new HttpGet("https://api.spiget.org/v2//resources/" + id + "/versions?sort=-releaseDate");
        get.setHeader("User-Agent", "PlugMan");
        try {
            HttpResponse response = client.execute(get);
            String body = IOUtils.toString(response.getEntity().getContent());
            return (JSONArray)JSONValue.parse((String)body);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

