/*
 * Decompiled with CFR 0.152.
 */
package me.entity303.plugmanbungee.commands.cmd;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import me.entity303.plugmanbungee.util.BungeePluginUtil;
import me.entity303.plugmanbungee.util.PluginResult;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.plugin.PluginManager;

public class UnloadCommand {
    public void execute(CommandSender sender, String[] args) {
        if (args.length <= 0) {
            this.sendMessage(sender, "\u00a7cSyntax: \u00a74/PlugManBungee unload <Plugin>");
            return;
        }
        String pluginName = args[0];
        PluginManager pluginManager = ProxyServer.getInstance().getPluginManager();
        if (pluginManager.getPlugin(pluginName) == null) {
            this.sendMessage(sender, "\u00a7cThere is no plugin named \u00a74" + pluginName + "\u00a7c!");
            return;
        }
        PluginResult pluginResult = BungeePluginUtil.unloadPlugin(pluginManager.getPlugin(pluginName));
        this.sendMessage(sender, pluginResult.getMessage());
    }

    private void sendMessage(CommandSender sender, String message) {
        sender.sendMessage((BaseComponent)new TextComponent("\u00a78[\u00a72PlugManBungee\u00a78] \u00a77" + message));
    }

    public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            List completions = ProxyServer.getInstance().getPluginManager().getPlugins().stream().map(plugin -> plugin.getDescription().getName()).collect(Collectors.toList());
            ArrayList<String> realCompletions = new ArrayList<String>();
            for (String com : completions) {
                if (!com.toLowerCase(Locale.ROOT).startsWith(args[0].toLowerCase(Locale.ROOT))) continue;
                realCompletions.add(com);
            }
            return realCompletions.size() > 0 ? realCompletions : completions;
        }
        return new ArrayList<String>();
    }
}

