/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.async;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.async.AsyncListenerHandler;
import com.comphenix.protocol.async.AsyncMarker;
import com.comphenix.protocol.async.PacketEventHolder;
import com.comphenix.protocol.async.PacketSendingQueue;
import com.comphenix.protocol.async.PlayerSendingHandler;
import com.comphenix.protocol.async.Synchronization;
import com.comphenix.protocol.concurrent.PacketTypeMultiMap;
import com.comphenix.protocol.error.Report;
import com.comphenix.protocol.error.ReportType;
import com.comphenix.protocol.events.ListeningWhitelist;
import com.comphenix.protocol.events.PacketEvent;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MinMaxPriorityQueue;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.Semaphore;

class PacketProcessingQueue {
    public static final ReportType REPORT_GUAVA_CORRUPT_MISSING = new ReportType("Guava is either missing or corrupt. Reverting to PriorityQueue.");
    public static final int INITIAL_CAPACITY = 64;
    public static final int DEFAULT_MAXIMUM_CONCURRENCY = 32;
    public static final int DEFAULT_QUEUE_LIMIT = 61440;
    private final int maximumConcurrency;
    private Semaphore concurrentProcessing;
    private Queue<PacketEventHolder> processingQueue;
    private PlayerSendingHandler sendingHandler;
    private final PacketTypeMultiMap<AsyncListenerHandler> map = new PacketTypeMultiMap();

    public void addListener(AsyncListenerHandler listener, ListeningWhitelist whitelist) {
        this.map.put(whitelist, listener);
    }

    public List<PacketType> removeListener(AsyncListenerHandler listener, ListeningWhitelist whitelist) {
        return this.map.remove(whitelist, listener);
    }

    public PacketProcessingQueue(PlayerSendingHandler sendingHandler) {
        this(sendingHandler, 64, 61440, 32);
    }

    public PacketProcessingQueue(PlayerSendingHandler sendingHandler, int initialSize, int maximumSize, int maximumConcurrency) {
        try {
            this.processingQueue = Synchronization.queue(MinMaxPriorityQueue.expectedSize((int)initialSize).maximumSize(maximumSize).create(), null);
        }
        catch (IncompatibleClassChangeError e) {
            ProtocolLibrary.getErrorReporter().reportWarning((Object)this, Report.newBuilder(REPORT_GUAVA_CORRUPT_MISSING).error(e));
            this.processingQueue = Synchronization.queue(new PriorityQueue(), null);
        }
        this.maximumConcurrency = maximumConcurrency;
        this.concurrentProcessing = new Semaphore(maximumConcurrency);
        this.sendingHandler = sendingHandler;
    }

    public boolean enqueue(PacketEvent packet, boolean onMainThread) {
        try {
            this.processingQueue.add(new PacketEventHolder(packet));
            this.signalBeginProcessing(onMainThread);
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public int size() {
        return this.processingQueue.size();
    }

    public void signalBeginProcessing(boolean onMainThread) {
        while (this.concurrentProcessing.tryAcquire()) {
            PacketEventHolder holder = this.processingQueue.poll();
            if (holder != null) {
                PacketSendingQueue sendingQueue;
                Iterator<AsyncListenerHandler> iterator;
                PacketEvent packet = holder.getEvent();
                AsyncMarker marker = packet.getAsyncMarker();
                Iterable<AsyncListenerHandler> list = this.map.get(packet.getPacketType());
                marker.incrementProcessingDelay();
                if (list != null && (iterator = list.iterator()).hasNext()) {
                    marker.setListenerTraversal(iterator);
                    iterator.next().enqueuePacket(packet);
                    continue;
                }
                if (marker.decrementProcessingDelay() == 0 && (sendingQueue = this.sendingHandler.getSendingQueue(packet, false)) != null) {
                    sendingQueue.signalPacketUpdate(packet, onMainThread);
                }
                this.signalProcessingDone();
                continue;
            }
            this.signalProcessingDone();
            return;
        }
    }

    public void signalProcessingDone() {
        this.concurrentProcessing.release();
    }

    public int getMaximumConcurrency() {
        return this.maximumConcurrency;
    }

    public boolean contains(PacketType packetType) {
        return this.map.contains(packetType);
    }

    public Iterable<AsyncListenerHandler> get(PacketType packetType) {
        return this.map.get(packetType);
    }

    public ImmutableSet<PacketType> keySet() {
        return this.map.getPacketTypes();
    }

    public Iterable<AsyncListenerHandler> values() {
        return this.map.values();
    }

    public void cleanupAll() {
        for (AsyncListenerHandler handler : this.map.values()) {
            handler.cancel();
        }
        this.map.clear();
        this.processingQueue.clear();
    }
}

