/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.fuzzy;

import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.MethodInfo;
import com.comphenix.protocol.reflect.fuzzy.AbstractFuzzyMatcher;
import com.comphenix.protocol.reflect.fuzzy.FuzzyFieldContract;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class FuzzyClassContract
implements AbstractFuzzyMatcher<Class<?>> {
    private final ImmutableList<AbstractFuzzyMatcher<Field>> fieldContracts;
    private final ImmutableList<AbstractFuzzyMatcher<MethodInfo>> methodContracts;
    private final ImmutableList<AbstractFuzzyMatcher<MethodInfo>> constructorContracts;
    private final ImmutableList<AbstractFuzzyMatcher<Class<?>>> baseclassContracts;
    private final ImmutableList<AbstractFuzzyMatcher<Class<?>>> interfaceContracts;

    private FuzzyClassContract(Builder builder) {
        this.fieldContracts = ImmutableList.copyOf(builder.fieldContracts);
        this.methodContracts = ImmutableList.copyOf(builder.methodContracts);
        this.constructorContracts = ImmutableList.copyOf(builder.constructorContracts);
        this.baseclassContracts = ImmutableList.copyOf(builder.baseclassContracts);
        this.interfaceContracts = ImmutableList.copyOf(builder.interfaceContracts);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public ImmutableList<AbstractFuzzyMatcher<Field>> getFieldContracts() {
        return this.fieldContracts;
    }

    public ImmutableList<AbstractFuzzyMatcher<MethodInfo>> getMethodContracts() {
        return this.methodContracts;
    }

    public ImmutableList<AbstractFuzzyMatcher<MethodInfo>> getConstructorContracts() {
        return this.constructorContracts;
    }

    public ImmutableList<AbstractFuzzyMatcher<Class<?>>> getBaseclassContracts() {
        return this.baseclassContracts;
    }

    public ImmutableList<AbstractFuzzyMatcher<Class<?>>> getInterfaceContracts() {
        return this.interfaceContracts;
    }

    @Override
    public boolean isMatch(Class<?> value, Object parent) {
        FuzzyReflection reflection = FuzzyReflection.fromClass(value, true);
        return this.processValue((Object)value.getSuperclass(), parent, (List)this.baseclassContracts) && this.processContracts((Collection)Arrays.asList(value.getInterfaces()), parent, (List)this.interfaceContracts) && this.processContracts((Collection)reflection.getFields(), value, (List)this.fieldContracts) && this.processContracts((Collection)MethodInfo.fromMethods(reflection.getMethods()), value, (List)this.methodContracts) && this.processContracts((Collection)MethodInfo.fromConstructors(value.getDeclaredConstructors()), value, (List)this.constructorContracts);
    }

    private <T> boolean processContracts(Collection<T> values, Object parent, List<AbstractFuzzyMatcher<T>> matchers) {
        if (values.isEmpty() || matchers.isEmpty()) {
            return true;
        }
        int acceptingMatchers = 0;
        for (T value : values) {
            if (!this.processValue(value, parent, matchers) || ++acceptingMatchers != matchers.size()) continue;
            return true;
        }
        return false;
    }

    private <T> boolean processValue(T value, Object parent, List<AbstractFuzzyMatcher<T>> matchers) {
        for (AbstractFuzzyMatcher<T> matcher : matchers) {
            if (matcher.isMatch(value, parent)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("FuzzyClassContract={\n");
        if (!this.fieldContracts.isEmpty()) {
            builder.append("  fields=").append(this.fieldContracts).append("\n");
        }
        if (!this.methodContracts.isEmpty()) {
            builder.append("  methods=").append(this.methodContracts).append("\n");
        }
        if (!this.constructorContracts.isEmpty()) {
            builder.append("  constructors=").append(this.constructorContracts).append("\n");
        }
        if (!this.baseclassContracts.isEmpty()) {
            builder.append("  baseClasses=").append(this.baseclassContracts).append("\n");
        }
        if (!this.interfaceContracts.isEmpty()) {
            builder.append("  interfaceClasses=").append(this.interfaceContracts).append("\n");
        }
        return builder.append("}").toString();
    }

    public static final class Builder {
        private final List<AbstractFuzzyMatcher<Field>> fieldContracts = new ArrayList<AbstractFuzzyMatcher<Field>>();
        private final List<AbstractFuzzyMatcher<MethodInfo>> methodContracts = new ArrayList<AbstractFuzzyMatcher<MethodInfo>>();
        private final List<AbstractFuzzyMatcher<MethodInfo>> constructorContracts = new ArrayList<AbstractFuzzyMatcher<MethodInfo>>();
        private final List<AbstractFuzzyMatcher<Class<?>>> baseclassContracts = new ArrayList();
        private final List<AbstractFuzzyMatcher<Class<?>>> interfaceContracts = new ArrayList();

        public Builder field(AbstractFuzzyMatcher<Field> matcher) {
            this.fieldContracts.add(matcher);
            return this;
        }

        public Builder field(FuzzyFieldContract.Builder builder) {
            return this.field(builder.build());
        }

        public Builder method(AbstractFuzzyMatcher<MethodInfo> matcher) {
            this.methodContracts.add(matcher);
            return this;
        }

        public Builder method(FuzzyMethodContract.Builder builder) {
            return this.method(builder.build());
        }

        public Builder constructor(AbstractFuzzyMatcher<MethodInfo> matcher) {
            this.constructorContracts.add(matcher);
            return this;
        }

        public Builder constructor(FuzzyMethodContract.Builder builder) {
            return this.constructor(builder.build());
        }

        public Builder baseclass(AbstractFuzzyMatcher<Class<?>> matcher) {
            this.baseclassContracts.add(matcher);
            return this;
        }

        public Builder baseclass(Builder builder) {
            return this.baseclass(builder.build());
        }

        public Builder interfaces(AbstractFuzzyMatcher<Class<?>> matcher) {
            this.interfaceContracts.add(matcher);
            return this;
        }

        public Builder interfaces(Builder builder) {
            return this.interfaces(builder.build());
        }

        public FuzzyClassContract build() {
            return new FuzzyClassContract(this);
        }
    }
}

