/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.fuzzy;

import com.comphenix.protocol.reflect.MethodInfo;
import com.comphenix.protocol.reflect.fuzzy.AbstractFuzzyMatcher;
import com.comphenix.protocol.reflect.fuzzy.AbstractFuzzyMember;
import com.comphenix.protocol.reflect.fuzzy.ClassTypeMatcher;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMatchers;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class FuzzyMethodContract
extends AbstractFuzzyMember<MethodInfo> {
    private AbstractFuzzyMatcher<Class<?>> returnMatcher = ClassTypeMatcher.MATCH_ALL;
    private List<ParameterClassMatcher> paramMatchers;
    private List<ParameterClassMatcher> exceptionMatchers;
    private Integer paramCount;

    private FuzzyMethodContract() {
        this.paramMatchers = new ArrayList<ParameterClassMatcher>();
        this.exceptionMatchers = new ArrayList<ParameterClassMatcher>();
    }

    private FuzzyMethodContract(FuzzyMethodContract other) {
        super(other);
        this.returnMatcher = other.returnMatcher;
        this.paramMatchers = other.paramMatchers;
        this.exceptionMatchers = other.exceptionMatchers;
        this.paramCount = other.paramCount;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static FuzzyMethodContract immutableCopy(FuzzyMethodContract other) {
        FuzzyMethodContract copy = new FuzzyMethodContract(other);
        copy.paramMatchers = ImmutableList.copyOf(copy.paramMatchers);
        copy.exceptionMatchers = ImmutableList.copyOf(copy.exceptionMatchers);
        return copy;
    }

    public AbstractFuzzyMatcher<Class<?>> getReturnMatcher() {
        return this.returnMatcher;
    }

    public ImmutableList<ParameterClassMatcher> getParamMatchers() {
        if (this.paramMatchers instanceof ImmutableList) {
            return (ImmutableList)this.paramMatchers;
        }
        throw new IllegalStateException("Lists haven't been sealed yet.");
    }

    public List<ParameterClassMatcher> getExceptionMatchers() {
        if (this.exceptionMatchers instanceof ImmutableList) {
            return this.exceptionMatchers;
        }
        throw new IllegalStateException("Lists haven't been sealed yet.");
    }

    public Integer getParamCount() {
        return this.paramCount;
    }

    @Override
    public boolean isMatch(MethodInfo value, Object parent) {
        if (super.isMatch(value, parent)) {
            if (!this.returnMatcher.isMatch(value.getReturnType(), value)) {
                return false;
            }
            Class<?>[] params = value.getParameterTypes();
            if (this.paramCount != null && this.paramCount != params.length) {
                return false;
            }
            return this.matchTypes(params, value, this.paramMatchers) && this.matchTypes(value.getExceptionTypes(), value, this.exceptionMatchers);
        }
        return false;
    }

    private boolean matchTypes(Class<?>[] types, MethodInfo parent, List<ParameterClassMatcher> matchers) {
        if (matchers.isEmpty()) {
            return true;
        }
        int acceptingMatchers = 0;
        for (int i = 0; i < types.length; ++i) {
            if (!this.processValue(types[i], parent, i, matchers) || ++acceptingMatchers != matchers.size()) continue;
            return true;
        }
        return false;
    }

    private boolean processValue(Class<?> value, MethodInfo parent, int index, List<ParameterClassMatcher> matchers) {
        for (ParameterClassMatcher matcher : matchers) {
            if (!matcher.isParameterMatch(value, parent, index)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Map<String, Object> getKeyValueView() {
        Map<String, Object> member = super.getKeyValueView();
        if (this.returnMatcher != ClassTypeMatcher.MATCH_ALL) {
            member.put("return", this.returnMatcher);
        }
        if (!this.paramMatchers.isEmpty()) {
            member.put("params", this.paramMatchers);
        }
        if (!this.exceptionMatchers.isEmpty()) {
            member.put("exceptions", this.exceptionMatchers);
        }
        if (this.paramCount != null) {
            member.put("paramCount", this.paramCount);
        }
        return member;
    }

    public static final class Builder
    extends AbstractFuzzyMember.Builder<FuzzyMethodContract> {
        public Builder requireModifier(int modifier) {
            super.requireModifier(modifier);
            return this;
        }

        public Builder requirePublic() {
            super.requirePublic();
            return this;
        }

        public Builder banModifier(int modifier) {
            super.banModifier(modifier);
            return this;
        }

        public Builder nameRegex(String regex) {
            super.nameRegex(regex);
            return this;
        }

        public Builder nameRegex(Pattern pattern) {
            super.nameRegex(pattern);
            return this;
        }

        public Builder nameExact(String name) {
            super.nameExact(name);
            return this;
        }

        public Builder declaringClassExactType(Class<?> declaringClass) {
            super.declaringClassExactType(declaringClass);
            return this;
        }

        public Builder declaringClassSuperOf(Class<?> declaringClass) {
            super.declaringClassSuperOf(declaringClass);
            return this;
        }

        public Builder declaringClassDerivedOf(Class<?> declaringClass) {
            super.declaringClassDerivedOf(declaringClass);
            return this;
        }

        public Builder declaringClassMatching(AbstractFuzzyMatcher<Class<?>> classMatcher) {
            super.declaringClassMatching(classMatcher);
            return this;
        }

        public Builder parameterExactType(Class<?> type) {
            ((FuzzyMethodContract)this.member).paramMatchers.add(new ParameterClassMatcher(FuzzyMatchers.matchExact(type)));
            return this;
        }

        public Builder parameterSuperOf(Class<?> type) {
            ((FuzzyMethodContract)this.member).paramMatchers.add(new ParameterClassMatcher(FuzzyMatchers.matchSuper(type)));
            return this;
        }

        public Builder parameterDerivedOf(Class<?> type) {
            ((FuzzyMethodContract)this.member).paramMatchers.add(new ParameterClassMatcher(FuzzyMatchers.matchDerived(type)));
            return this;
        }

        public Builder parameterMatches(AbstractFuzzyMatcher<Class<?>> classMatcher) {
            ((FuzzyMethodContract)this.member).paramMatchers.add(new ParameterClassMatcher(classMatcher));
            return this;
        }

        public Builder parameterExactType(Class<?> type, int index) {
            ((FuzzyMethodContract)this.member).paramMatchers.add(new ParameterClassMatcher(FuzzyMatchers.matchExact(type), index));
            return this;
        }

        public Builder parameterExactArray(Class<?> ... types) {
            this.parameterCount(types.length);
            for (int i = 0; i < types.length; ++i) {
                this.parameterExactType(types[i], i);
            }
            return this;
        }

        public Builder parameterSuperOf(Class<?> type, int index) {
            ((FuzzyMethodContract)this.member).paramMatchers.add(new ParameterClassMatcher(FuzzyMatchers.matchSuper(type), index));
            return this;
        }

        public Builder parameterDerivedOf(Class<?> type, int index) {
            ((FuzzyMethodContract)this.member).paramMatchers.add(new ParameterClassMatcher(FuzzyMatchers.matchDerived(type), index));
            return this;
        }

        public Builder parameterMatches(AbstractFuzzyMatcher<Class<?>> classMatcher, int index) {
            ((FuzzyMethodContract)this.member).paramMatchers.add(new ParameterClassMatcher(classMatcher, index));
            return this;
        }

        public Builder parameterCount(int expectedCount) {
            ((FuzzyMethodContract)this.member).paramCount = expectedCount;
            return this;
        }

        public Builder returnTypeVoid() {
            return this.returnTypeExact(Void.TYPE);
        }

        public Builder returnTypeExact(Class<?> type) {
            ((FuzzyMethodContract)this.member).returnMatcher = FuzzyMatchers.matchExact(type);
            return this;
        }

        public Builder returnDerivedOf(Class<?> type) {
            ((FuzzyMethodContract)this.member).returnMatcher = FuzzyMatchers.matchDerived(type);
            return this;
        }

        public Builder returnTypeMatches(AbstractFuzzyMatcher<Class<?>> classMatcher) {
            ((FuzzyMethodContract)this.member).returnMatcher = classMatcher;
            return this;
        }

        public Builder exceptionExactType(Class<?> type) {
            ((FuzzyMethodContract)this.member).exceptionMatchers.add(new ParameterClassMatcher(FuzzyMatchers.matchExact(type)));
            return this;
        }

        public Builder exceptionSuperOf(Class<?> type) {
            ((FuzzyMethodContract)this.member).exceptionMatchers.add(new ParameterClassMatcher(FuzzyMatchers.matchSuper(type)));
            return this;
        }

        public Builder exceptionMatches(AbstractFuzzyMatcher<Class<?>> classMatcher) {
            ((FuzzyMethodContract)this.member).exceptionMatchers.add(new ParameterClassMatcher(classMatcher));
            return this;
        }

        public Builder exceptionExactType(Class<?> type, int index) {
            ((FuzzyMethodContract)this.member).exceptionMatchers.add(new ParameterClassMatcher(FuzzyMatchers.matchExact(type), index));
            return this;
        }

        public Builder exceptionSuperOf(Class<?> type, int index) {
            ((FuzzyMethodContract)this.member).exceptionMatchers.add(new ParameterClassMatcher(FuzzyMatchers.matchSuper(type), index));
            return this;
        }

        public Builder exceptionMatches(AbstractFuzzyMatcher<Class<?>> classMatcher, int index) {
            ((FuzzyMethodContract)this.member).exceptionMatchers.add(new ParameterClassMatcher(classMatcher, index));
            return this;
        }

        @Override
        @Nonnull
        protected FuzzyMethodContract initialMember() {
            return new FuzzyMethodContract();
        }

        @Override
        public FuzzyMethodContract build() {
            ((FuzzyMethodContract)this.member).prepareBuild();
            return FuzzyMethodContract.immutableCopy((FuzzyMethodContract)this.member);
        }
    }

    private static final class ParameterClassMatcher
    implements AbstractFuzzyMatcher<Class<?>[]> {
        private final AbstractFuzzyMatcher<Class<?>> typeMatcher;
        private final Integer indexMatch;

        public ParameterClassMatcher(@Nonnull AbstractFuzzyMatcher<Class<?>> typeMatcher) {
            this(typeMatcher, null);
        }

        public ParameterClassMatcher(@Nonnull AbstractFuzzyMatcher<Class<?>> typeMatcher, Integer indexMatch) {
            this.typeMatcher = typeMatcher;
            this.indexMatch = indexMatch;
        }

        public boolean isParameterMatch(Class<?> param, MethodInfo parent, int index) {
            if (this.indexMatch == null || this.indexMatch == index) {
                return this.typeMatcher.isMatch(param, parent);
            }
            return false;
        }

        @Override
        public boolean isMatch(Class<?>[] value, Object parent) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return String.format("{ Parameter Type: %s, Index: %s }", this.typeMatcher, this.indexMatch);
        }
    }
}

