/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.BukkitConverters;
import com.comphenix.protocol.wrappers.Converters;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedGameProfile;
import com.comphenix.protocol.wrappers.WrappedProfilePublicKey;
import com.comphenix.protocol.wrappers.WrappedRemoteChatSessionData;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;

public class PlayerInfoData {
    private static Constructor<?> constructor;
    private final UUID profileId;
    private final int latency;
    private final int listOrder = 0;
    private final boolean listed;
    private final boolean showHat;
    private final EnumWrappers.NativeGameMode gameMode;
    private final WrappedGameProfile profile;
    private final WrappedChatComponent displayName;
    @Nullable
    private final WrappedRemoteChatSessionData remoteChatSessionData;
    @Nullable
    private final WrappedProfilePublicKey.WrappedProfileKeyData profileKeyData;

    public PlayerInfoData(WrappedGameProfile profile, int latency, EnumWrappers.NativeGameMode gameMode, WrappedChatComponent displayName) {
        this(profile, latency, gameMode, displayName, null);
    }

    public PlayerInfoData(WrappedGameProfile profile, int latency, EnumWrappers.NativeGameMode gameMode, WrappedChatComponent displayName, WrappedProfilePublicKey.WrappedProfileKeyData keyData) {
        this(profile.getUUID(), latency, true, gameMode, profile, displayName, keyData);
    }

    public PlayerInfoData(UUID profileId, int latency, boolean listed, EnumWrappers.NativeGameMode gameMode, WrappedGameProfile profile, WrappedChatComponent displayName) {
        this(profileId, latency, listed, gameMode, profile, displayName, (WrappedRemoteChatSessionData)null);
    }

    public PlayerInfoData(UUID profileId, int latency, boolean listed, EnumWrappers.NativeGameMode gameMode, WrappedGameProfile profile, WrappedChatComponent displayName, @Nullable WrappedRemoteChatSessionData remoteChatSession) {
        this(profileId, latency, listed, gameMode, profile, displayName, false, remoteChatSession);
    }

    @Deprecated
    public PlayerInfoData(UUID profileId, int latency, boolean listed, EnumWrappers.NativeGameMode gameMode, WrappedGameProfile profile, WrappedChatComponent displayName, @Nullable WrappedProfilePublicKey.WrappedProfileKeyData profileKeyData) {
        this.profileId = profileId;
        this.latency = latency;
        this.listed = listed;
        this.gameMode = gameMode;
        this.profile = profile;
        this.displayName = displayName;
        this.profileKeyData = profileKeyData;
        this.remoteChatSessionData = null;
        this.showHat = false;
    }

    public PlayerInfoData(UUID profileId, int latency, boolean listed, EnumWrappers.NativeGameMode gameMode, WrappedGameProfile profile, WrappedChatComponent displayName, boolean showHat, @Nullable WrappedRemoteChatSessionData remoteChatSession) {
        this.profileId = profileId;
        this.latency = latency;
        this.listed = listed;
        this.gameMode = gameMode;
        this.profile = profile;
        this.displayName = displayName;
        this.profileKeyData = null;
        this.remoteChatSessionData = remoteChatSession;
        this.showHat = showHat;
    }

    public UUID getProfileId() {
        if (this.profileId == null && this.profile != null) {
            return this.profile.getUUID();
        }
        return this.profileId;
    }

    public WrappedGameProfile getProfile() {
        return this.profile;
    }

    @Deprecated
    public int getPing() {
        return this.latency;
    }

    public int getLatency() {
        return this.latency;
    }

    public boolean isListed() {
        return this.listed;
    }

    public EnumWrappers.NativeGameMode getGameMode() {
        return this.gameMode;
    }

    public WrappedChatComponent getDisplayName() {
        return this.displayName;
    }

    public boolean isShowHat() {
        return this.showHat;
    }

    @Nullable
    public WrappedProfilePublicKey.WrappedProfileKeyData getProfileKeyData() {
        return this.profileKeyData != null ? this.profileKeyData : (this.remoteChatSessionData != null ? this.remoteChatSessionData.getProfilePublicKey() : null);
    }

    @Nullable
    public WrappedRemoteChatSessionData getRemoteChatSessionData() {
        return this.remoteChatSessionData;
    }

    public static EquivalentConverter<PlayerInfoData> getConverter() {
        return new EquivalentConverter<PlayerInfoData>(){
            private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];

            @Override
            public Object getGeneric(PlayerInfoData specific) {
                if (constructor == null) {
                    try {
                        ArrayList args = new ArrayList();
                        if (!MinecraftVersion.CAVES_CLIFFS_1.atOrAbove()) {
                            args.add(PacketType.Play.Server.PLAYER_INFO.getPacketClass());
                        }
                        if (MinecraftVersion.FEATURE_PREVIEW_UPDATE.atOrAbove()) {
                            args.add(UUID.class);
                        }
                        args.add(MinecraftReflection.getGameProfileClass());
                        if (MinecraftVersion.FEATURE_PREVIEW_UPDATE.atOrAbove()) {
                            args.add(Boolean.TYPE);
                        }
                        args.add(Integer.TYPE);
                        args.add(EnumWrappers.getGameModeClass());
                        args.add(MinecraftReflection.getIChatBaseComponentClass());
                        if (MinecraftVersion.v1_21_4.atOrAbove()) {
                            args.add(Boolean.TYPE);
                        }
                        if (MinecraftVersion.v1_21_2.atOrAbove()) {
                            args.add(Integer.TYPE);
                        }
                        if (MinecraftVersion.FEATURE_PREVIEW_UPDATE.atOrAbove()) {
                            args.add(MinecraftReflection.getRemoteChatSessionDataClass());
                        } else if (MinecraftVersion.WILD_UPDATE.atOrAbove()) {
                            args.add(MinecraftReflection.getProfilePublicKeyDataClass());
                        }
                        constructor = MinecraftReflection.getPlayerInfoDataClass().getConstructor(args.toArray(EMPTY_CLASS_ARRAY));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot find PlayerInfoData constructor.", e);
                    }
                }
                try {
                    Object remoteChatSessionData;
                    Object gameMode = Converters.ignoreNull(EnumWrappers.getGameModeConverter()).getGeneric(specific.gameMode);
                    Object displayName = specific.displayName != null ? specific.displayName.handle : null;
                    Object profile = specific.profile != null ? specific.profile.handle : null;
                    Object object = remoteChatSessionData = specific.remoteChatSessionData != null ? BukkitConverters.getWrappedRemoteChatSessionDataConverter().getGeneric(specific.remoteChatSessionData) : null;
                    Object[] args = MinecraftVersion.v1_21_4.atOrAbove() ? new Object[]{specific.profileId, profile, specific.listed, specific.latency, gameMode, displayName, specific.showHat, specific.listOrder, remoteChatSessionData} : (MinecraftVersion.v1_21_2.atOrAbove() ? new Object[]{specific.profileId, profile, specific.listed, specific.latency, gameMode, displayName, specific.listOrder, remoteChatSessionData} : (MinecraftVersion.FEATURE_PREVIEW_UPDATE.atOrAbove() ? new Object[]{specific.profileId, profile, specific.listed, specific.latency, gameMode, displayName, remoteChatSessionData} : (MinecraftVersion.WILD_UPDATE.atOrAbove() ? new Object[]{profile, specific.latency, gameMode, displayName, specific.profileKeyData == null ? null : specific.profileKeyData.handle} : (MinecraftVersion.CAVES_CLIFFS_1.atOrAbove() ? new Object[]{profile, specific.latency, gameMode, displayName} : new Object[]{null, profile, specific.latency, gameMode, displayName}))));
                    return constructor.newInstance(args);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to construct PlayerInfoData.", e);
                }
            }

            @Override
            public PlayerInfoData getSpecific(Object generic) {
                if (MinecraftReflection.isPlayerInfoData(generic)) {
                    StructureModifier modifier = new StructureModifier(generic.getClass(), null, false).withTarget(generic);
                    StructureModifier<WrappedGameProfile> gameProfiles = modifier.withType(MinecraftReflection.getGameProfileClass(), BukkitConverters.getWrappedGameProfileConverter());
                    WrappedGameProfile gameProfile = gameProfiles.read(0);
                    StructureModifier ints = modifier.withType(Integer.TYPE);
                    int latency = (Integer)ints.read(0);
                    StructureModifier<EnumWrappers.NativeGameMode> gameModes = modifier.withType(EnumWrappers.getGameModeClass(), Converters.ignoreNull(EnumWrappers.getGameModeConverter()));
                    EnumWrappers.NativeGameMode gameMode = gameModes.read(0);
                    StructureModifier<WrappedChatComponent> displayNames = modifier.withType(MinecraftReflection.getIChatBaseComponentClass(), BukkitConverters.getWrappedChatComponentConverter());
                    WrappedChatComponent displayName = displayNames.read(0);
                    if (MinecraftVersion.v1_21_4.atOrAbove()) {
                        return new PlayerInfoData((UUID)modifier.withType(UUID.class).read(0), latency, (Boolean)modifier.withType(Boolean.TYPE).read(0), gameMode, gameProfile, displayName, (Boolean)modifier.withType(Boolean.TYPE).read(1), modifier.withType(MinecraftReflection.getRemoteChatSessionDataClass(), BukkitConverters.getWrappedRemoteChatSessionDataConverter()).read(0));
                    }
                    if (MinecraftVersion.FEATURE_PREVIEW_UPDATE.atOrAbove()) {
                        return new PlayerInfoData((UUID)modifier.withType(UUID.class).read(0), latency, (boolean)((Boolean)modifier.withType(Boolean.TYPE).read(0)), gameMode, gameProfile, displayName, modifier.withType(MinecraftReflection.getRemoteChatSessionDataClass(), BukkitConverters.getWrappedRemoteChatSessionDataConverter()).read(0));
                    }
                    WrappedProfilePublicKey.WrappedProfileKeyData key = null;
                    if (MinecraftVersion.WILD_UPDATE.atOrAbove()) {
                        StructureModifier<WrappedProfilePublicKey.WrappedProfileKeyData> keyData = modifier.withType(MinecraftReflection.getProfilePublicKeyDataClass(), BukkitConverters.getWrappedPublicKeyDataConverter());
                        key = keyData.read(0);
                    }
                    return new PlayerInfoData(gameProfile, latency, gameMode, displayName, key);
                }
                return null;
            }

            @Override
            public Class<PlayerInfoData> getSpecificType() {
                return PlayerInfoData.class;
            }
        };
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof PlayerInfoData) {
            PlayerInfoData other = (PlayerInfoData)obj;
            return Objects.equals(this.profile, other.profile) && Objects.equals(this.profileId, other.profileId) && this.latency == other.latency && this.gameMode == other.gameMode && Objects.equals(this.displayName, other.displayName) && this.listed == other.listed && Objects.equals(this.remoteChatSessionData, other.remoteChatSessionData) && Objects.equals(this.profileKeyData, other.profileKeyData);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.latency, this.gameMode, this.profile, this.displayName, this.profileKeyData, this.remoteChatSessionData, this.listed});
    }

    public String toString() {
        if (MinecraftVersion.FEATURE_PREVIEW_UPDATE.atOrAbove()) {
            return String.format("PlayerInfoData[latency=%s, listed=%b, gameMode=%s, profile=%s, displayName=%s, remoteChatSession=%s]", new Object[]{this.latency, this.listed, this.gameMode, this.profile, this.displayName, this.remoteChatSessionData});
        }
        if (MinecraftVersion.WILD_UPDATE.atOrAbove()) {
            return String.format("PlayerInfoData[latency=%s, listed=%b, gameMode=%s, profile=%s, displayName=%s, profilePublicKey=%s]", new Object[]{this.latency, this.listed, this.gameMode, this.profile, this.displayName, this.profileKeyData});
        }
        return String.format("PlayerInfoData[latency=%s, gameMode=%s, profile=%s, displayName=%s]", new Object[]{this.latency, this.gameMode, this.profile, this.displayName});
    }
}

