/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.IDataWatcher;
import com.comphenix.protocol.wrappers.InMemoryDataWatcher;
import com.comphenix.protocol.wrappers.LegacyDataWatcher;
import com.comphenix.protocol.wrappers.Vector3F;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataValue;
import com.comphenix.protocol.wrappers.WrappedParticle;
import com.comphenix.protocol.wrappers.WrappedVillagerData;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class WrappedDataWatcher
implements IDataWatcher {
    private static final boolean IN_MEMORY = MinecraftVersion.v1_20_4.atOrAbove();
    @NotNull
    private final IDataWatcher impl;
    private static final ImmutableBiMap<Class<?>, Integer> CLASS_TO_ID = new ImmutableBiMap.Builder().put(Byte.class, (Object)0).put(Short.class, (Object)1).put(Integer.class, (Object)2).put(Float.class, (Object)3).put(String.class, (Object)4).put(MinecraftReflection.getItemStackClass(), (Object)5).put(MinecraftReflection.getBlockPositionClass(), (Object)6).put(Vector3F.getMinecraftClass(), (Object)7).build();

    private WrappedDataWatcher(IDataWatcher impl) {
        this.impl = impl;
    }

    public WrappedDataWatcher(Object handle) {
        this.impl = IN_MEMORY ? new InMemoryDataWatcher(handle) : new LegacyDataWatcher(handle);
    }

    public WrappedDataWatcher() {
        this.impl = IN_MEMORY ? new InMemoryDataWatcher() : new LegacyDataWatcher();
    }

    public WrappedDataWatcher(Entity entity) {
        this.impl = IN_MEMORY ? new InMemoryDataWatcher(entity) : new LegacyDataWatcher(entity);
    }

    public WrappedDataWatcher(List<WrappedWatchableObject> objects) {
        this.impl = IN_MEMORY ? new InMemoryDataWatcher(objects) : new LegacyDataWatcher(objects);
    }

    @Override
    public Map<Integer, WrappedWatchableObject> asMap() {
        return this.impl.asMap();
    }

    @Override
    @Deprecated
    public Set<Integer> getIndexes() {
        return this.impl.getIndexes();
    }

    @Override
    public List<WrappedWatchableObject> getWatchableObjects() {
        return this.impl.getWatchableObjects();
    }

    @Override
    public Iterator<WrappedWatchableObject> iterator() {
        return this.impl.iterator();
    }

    @Override
    public int size() {
        return this.impl.size();
    }

    @Override
    public WrappedWatchableObject getWatchableObject(int index) {
        return this.impl.getWatchableObject(index);
    }

    @Deprecated
    public WrappedWatchableObject removeObject(int index) {
        return this.remove(index);
    }

    @Override
    public WrappedWatchableObject remove(int index) {
        return this.impl.remove(index);
    }

    @Override
    public boolean hasIndex(int index) {
        return this.impl.hasIndex(index);
    }

    @Deprecated
    public Set<Integer> indexSet() {
        return this.getIndexes();
    }

    @Override
    public void clear() {
        this.impl.clear();
    }

    public Byte getByte(int index) {
        return (Byte)this.getObject(index);
    }

    public void setByte(int index, byte value, boolean update) {
        this.setObject(new WrappedDataWatcherObject(index, Registry.get(Byte.class)), (Object)value, update);
    }

    public Short getShort(int index) {
        return (Short)this.getObject(index);
    }

    public Integer getInteger(int index) {
        return (Integer)this.getObject(index);
    }

    public void setInteger(int index, Integer value, boolean update) {
        this.setObject(new WrappedDataWatcherObject(index, Registry.get(Integer.class)), (Object)value, update);
    }

    public Long getLong(int index) {
        return (Long)this.getObject(index);
    }

    public void setLong(int index, Long value, boolean update) {
        this.setObject(new WrappedDataWatcherObject(index, Registry.get(Long.class)), (Object)value, update);
    }

    public Float getFloat(int index) {
        return (Float)this.getObject(index);
    }

    public void setFloat(int index, Float value, boolean update) {
        this.setObject(new WrappedDataWatcherObject(index, Registry.get(Float.class)), (Object)value, update);
    }

    public String getString(int index) {
        return (String)this.getObject(index);
    }

    public void setString(int index, String value, boolean update) {
        this.setObject(new WrappedDataWatcherObject(index, Registry.get(String.class)), (Object)value, update);
    }

    public WrappedChatComponent getChatComponent(int index) {
        return (WrappedChatComponent)this.getObject(index);
    }

    public void setChatComponent(int index, WrappedChatComponent value, boolean update) {
        this.setObject(new WrappedDataWatcherObject(index, Registry.getChatComponentSerializer()), (Object)value, update);
    }

    public Optional<WrappedChatComponent> getOptionalChatComponent(int index) {
        return (Optional)this.getObject(index);
    }

    public void setOptionalChatComponent(int index, Optional<WrappedChatComponent> value, boolean update) {
        this.setObject(new WrappedDataWatcherObject(index, Registry.getChatComponentSerializer(true)), value, update);
    }

    public ItemStack getItemStack(int index) {
        return (ItemStack)this.getObject(index);
    }

    public void setItemStack(int index, ItemStack itemStack, boolean update) {
        this.setObject(new WrappedDataWatcherObject(index, Registry.getItemStackSerializer(false)), (Object)itemStack, update);
    }

    public Boolean getBoolean(int index) {
        return (Boolean)this.getObject(index);
    }

    public void setBoolean(int index, Boolean value, boolean update) {
        this.setObject(new WrappedDataWatcherObject(index, Registry.get(Boolean.class)), (Object)value, update);
    }

    public BlockPosition getPosition(int index) {
        return (BlockPosition)this.getObject(index);
    }

    public void setPosition(int index, BlockPosition position, boolean update) {
        this.setObject(new WrappedDataWatcherObject(index, Registry.getBlockPositionSerializer(false)), (Object)position, update);
    }

    public Optional<BlockPosition> getOptionalPosition(int index) {
        return (Optional)this.getObject(index);
    }

    public void setOptionalPosition(int index, Optional<BlockPosition> position, boolean update) {
        this.setObject(new WrappedDataWatcherObject(index, Registry.getBlockPositionSerializer(true)), position, update);
    }

    public EnumWrappers.Direction getDirection(int index) {
        return (EnumWrappers.Direction)((Object)this.getObject(index));
    }

    public void setDirection(int index, EnumWrappers.Direction direction, boolean update) {
        this.setObject(new WrappedDataWatcherObject(index, Registry.getDirectionSerializer()), (Object)direction, update);
    }

    public Optional<UUID> getOptionalUUID(int index) {
        return (Optional)this.getObject(index);
    }

    public void setOptionalUUID(int index, Optional<UUID> uuid, boolean update) {
        this.setObject(new WrappedDataWatcherObject(index, Registry.getUUIDSerializer(true)), uuid, update);
    }

    public WrappedBlockData getBlockState(int index) {
        return (WrappedBlockData)this.getObject(index);
    }

    public void setBlockState(int index, WrappedBlockData blockData, boolean update) {
        this.setObject(new WrappedDataWatcherObject(index, Registry.getBlockDataSerializer(false)), (Object)blockData, update);
    }

    public Optional<WrappedBlockData> getOptionalBlockState(int index) {
        return (Optional)this.getObject(index);
    }

    public void setOptionalBlockState(int index, Optional<WrappedBlockData> value, boolean update) {
        this.setObject(new WrappedDataWatcherObject(index, Registry.getBlockDataSerializer(true)), value, update);
    }

    public NbtCompound getNBTCompound(int index) {
        return (NbtCompound)this.getObject(index);
    }

    public void setNBTCompound(int index, NbtCompound nbt, boolean update) {
        this.setObject(new WrappedDataWatcherObject(index, Registry.getNBTCompoundSerializer()), (Object)nbt, update);
    }

    public WrappedParticle<?> getParticle(int index) {
        return (WrappedParticle)this.getObject(index);
    }

    public void setParticle(int index, WrappedParticle<?> particle, boolean update) {
        this.setObject(new WrappedDataWatcherObject(index, Registry.get(MinecraftReflection.getParticleParam(), false)), particle, update);
    }

    public WrappedVillagerData getVillagerData(int index) {
        return (WrappedVillagerData)this.getObject(index);
    }

    public void setVillagerData(int index, WrappedVillagerData data, boolean update) {
        this.setObject(new WrappedDataWatcherObject(index, Registry.get(WrappedVillagerData.getNmsClass(), false)), (Object)data, update);
    }

    public Optional<Integer> getOptionalInteger(int index) {
        return (Optional)this.getObject(index);
    }

    public void setOptionalInteger(int index, Optional<Integer> value, boolean update) {
        this.setObject(new WrappedDataWatcherObject(index, Registry.get(Integer.class, true)), value, update);
    }

    public EnumWrappers.EntityPose getPose(int index) {
        return (EnumWrappers.EntityPose)((Object)this.getObject(index));
    }

    public void setPose(int index, EnumWrappers.EntityPose pose, boolean update) {
        this.setObject(new WrappedDataWatcherObject(index, Registry.get(EnumWrappers.getEntityPoseClass(), false)), (Object)pose, update);
    }

    public Vector3F getVector3F(int index) {
        return (Vector3F)this.getObject(index);
    }

    public void setVector3F(int index, Vector3F vector, boolean update) {
        this.setObject(new WrappedDataWatcherObject(index, Registry.get(Vector3F.getMinecraftClass(), false)), (Object)vector, update);
    }

    @Override
    public Object getObject(int index) {
        return this.getObject(WrappedDataWatcherObject.fromIndex(index));
    }

    @Override
    public Object getObject(WrappedDataWatcherObject object) {
        return this.impl.getObject(object);
    }

    public void setObject(int index, Object value, boolean update) {
        if (MinecraftReflection.watcherObjectExists() && !this.hasIndex(index)) {
            throw new IllegalArgumentException("You cannot register objects without a watcher object!");
        }
        this.setObject(WrappedDataWatcherObject.fromIndex(index), value, update);
    }

    public void setObject(int index, Object value) {
        this.setObject(index, value, false);
    }

    public void setObject(int index, Serializer serializer, Object value, boolean update) {
        this.setObject(new WrappedDataWatcherObject(index, serializer), value, update);
    }

    public void setObject(int index, Serializer serializer, Object value) {
        this.setObject(new WrappedDataWatcherObject(index, serializer), value, false);
    }

    public void setObject(int index, WrappedWatchableObject value, boolean update) {
        this.setObject(index, value.getRawValue(), update);
    }

    public void setObject(int index, WrappedWatchableObject value) {
        this.setObject(index, value.getRawValue(), false);
    }

    @Override
    public void setObject(WrappedDataWatcherObject object, WrappedWatchableObject value, boolean update) {
        this.setObject(object, value.getRawValue(), update);
    }

    public void setObject(WrappedDataWatcherObject object, WrappedWatchableObject value) {
        this.setObject(object, value.getRawValue(), false);
    }

    @Override
    public void setObject(WrappedDataWatcherObject object, Object value, boolean update) {
        this.impl.setObject(object, value, update);
    }

    public void setObject(WrappedDataWatcherObject object, Object value) {
        this.setObject(object, value, false);
    }

    @Override
    public WrappedDataWatcher deepClone() {
        return new WrappedDataWatcher(this.impl.deepClone());
    }

    @Override
    public Object getHandle() {
        return this.impl.getHandle();
    }

    public static WrappedDataWatcher getEntityWatcher(Entity entity) {
        return new WrappedDataWatcher(entity);
    }

    @Override
    public Entity getEntity() {
        return this.impl.getEntity();
    }

    @Override
    public void setEntity(Entity entity) {
        this.impl.setEntity(entity);
    }

    public List<WrappedDataValue> toDataValueCollection() {
        List<WrappedWatchableObject> objects = this.impl.getWatchableObjects();
        ArrayList<WrappedDataValue> values = new ArrayList<WrappedDataValue>(objects.size());
        for (WrappedWatchableObject object : objects) {
            WrappedDataWatcherObject watcherObj = object.getWatcherObject();
            Object value = WrappedWatchableObject.getUnwrapped(object.getRawValue());
            values.add(new WrappedDataValue(watcherObj.getIndex(), watcherObj.getSerializer(), value));
        }
        return values;
    }

    public static Integer getTypeID(Class<?> clazz) {
        return (Integer)CLASS_TO_ID.get(clazz);
    }

    public static Class<?> getTypeClass(int typeID) {
        return (Class)CLASS_TO_ID.inverse().get((Object)typeID);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof WrappedDataWatcher) {
            WrappedDataWatcher other = (WrappedDataWatcher)obj;
            return this.impl.equals(other.impl);
        }
        return false;
    }

    public int hashCode() {
        return this.impl.hashCode();
    }

    public String toString() {
        return this.impl.toString();
    }

    public static class WrappedDataWatcherObject {
        private static final Class<?> HANDLE_TYPE = MinecraftReflection.getDataWatcherObjectClass();
        private static ConstructorAccessor constructor = null;
        private static MethodAccessor getSerializer = null;
        private StructureModifier<Object> modifier;
        private Object handle;

        protected WrappedDataWatcherObject() {
        }

        public WrappedDataWatcherObject(Object handle) {
            this.handle = handle;
            this.modifier = new StructureModifier(HANDLE_TYPE).withTarget(handle);
        }

        public WrappedDataWatcherObject(int index, Serializer serializer) {
            this(WrappedDataWatcherObject.newHandle(index, serializer));
        }

        static WrappedDataWatcherObject fromIndex(int index) {
            if (MinecraftReflection.watcherObjectExists()) {
                return new WrappedDataWatcherObject(WrappedDataWatcherObject.newHandle(index));
            }
            return new DummyWatcherObject(index);
        }

        private static Object newHandle(int index) {
            Validate.isTrue((index >= 0 ? 1 : 0) != 0, (String)"index cannot be negative!");
            if (constructor == null) {
                constructor = Accessors.getConstructorAccessor(HANDLE_TYPE.getConstructors()[0]);
            }
            return constructor.invoke(index, null);
        }

        private static Object newHandle(int index, Serializer serializer) {
            Validate.isTrue((index >= 0 ? 1 : 0) != 0, (String)"index cannot be negative!");
            Validate.notNull((Object)serializer, (String)"serializer cannot be null!");
            if (constructor == null) {
                constructor = Accessors.getConstructorAccessor(HANDLE_TYPE.getConstructors()[0]);
            }
            Object handle = serializer.getHandle();
            return constructor.invoke(index, handle);
        }

        public int getIndex() {
            return (Integer)this.modifier.read(0);
        }

        public Serializer getSerializer() {
            Object serializer;
            if (getSerializer == null) {
                getSerializer = Accessors.getMethodAccessor(FuzzyReflection.fromClass(HANDLE_TYPE, true).getMethodByReturnTypeAndParameters("getSerializer", MinecraftReflection.getDataWatcherSerializerClass(), new Class[0]));
            }
            if ((serializer = getSerializer.invoke(this.handle, new Object[0])) != null) {
                Serializer wrapper = Registry.fromHandle(serializer);
                if (wrapper != null) {
                    return wrapper;
                }
                return new Serializer(null, serializer, false);
            }
            return null;
        }

        public void checkSerializer() {
            Validate.notNull((Object)this.getSerializer(), (String)"You must specify a serializer to register an object!");
        }

        public Object getHandle() {
            return this.handle;
        }

        public Class<?> getHandleType() {
            return HANDLE_TYPE;
        }

        public String toString() {
            return "DataWatcherObject[index=" + this.getIndex() + ", serializer=" + String.valueOf(this.getSerializer()) + "]";
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof WrappedDataWatcherObject) {
                WrappedDataWatcherObject other = (WrappedDataWatcherObject)obj;
                return this.handle.equals(other.handle);
            }
            return false;
        }

        public int hashCode() {
            return this.handle.hashCode();
        }
    }

    public static class Registry {
        private static boolean INITIALIZED = false;
        private static Map<Class<?>, Serializer> RAW_REGISTRY = null;
        private static Map<Class<?>, Serializer> OPTIONAL_REGISTRY = null;

        public static Serializer get(Class<?> clazz) {
            Validate.notNull(clazz, (String)"Class cannot be null!");
            Registry.initialize();
            Serializer serializer = RAW_REGISTRY.getOrDefault(clazz, OPTIONAL_REGISTRY.getOrDefault(clazz, null));
            if (serializer == null) {
                throw new IllegalArgumentException("No serializer found for " + String.valueOf(clazz));
            }
            return serializer;
        }

        public static Serializer get(Class<?> clazz, boolean optional) {
            Serializer serializer;
            Validate.notNull(clazz, (String)"Class cannot be null!");
            Registry.initialize();
            Serializer serializer2 = serializer = optional ? OPTIONAL_REGISTRY.get(clazz) : RAW_REGISTRY.get(clazz);
            if (serializer == null) {
                throw new IllegalArgumentException("No serializer found for " + String.valueOf(optional ? "Optional<" + String.valueOf(clazz) + ">" : clazz));
            }
            return serializer;
        }

        public static Serializer fromHandle(Object handle) {
            Validate.notNull((Object)handle, (String)"handle cannot be null!");
            Registry.initialize();
            for (Serializer serializer : RAW_REGISTRY.values()) {
                if (!serializer.getHandle().equals(handle)) continue;
                return serializer;
            }
            for (Serializer serializer : OPTIONAL_REGISTRY.values()) {
                if (!serializer.getHandle().equals(handle)) continue;
                return serializer;
            }
            return null;
        }

        private static void initialize() {
            if (INITIALIZED) {
                return;
            }
            INITIALIZED = true;
            HashMap<Class, Serializer> rawRegistry = new HashMap<Class, Serializer>();
            HashMap<Class, Serializer> optionalRegistry = new HashMap<Class, Serializer>();
            List<Field> candidates = FuzzyReflection.fromClass(MinecraftReflection.getDataWatcherRegistryClass(), true).getFieldListByType(MinecraftReflection.getDataWatcherSerializerClass());
            for (Field candidate : candidates) {
                Object serializer;
                Class innerClass;
                Type generic = candidate.getGenericType();
                if (!(generic instanceof ParameterizedType)) continue;
                ParameterizedType type = (ParameterizedType)generic;
                Type[] args = type.getActualTypeArguments();
                Type arg = args[0];
                boolean optional = false;
                if (arg instanceof Class) {
                    innerClass = (Class)arg;
                } else if (arg instanceof ParameterizedType) {
                    innerClass = (Class)((ParameterizedType)arg).getActualTypeArguments()[0];
                    optional = true;
                } else {
                    throw new IllegalStateException("Failed to find inner class of field " + String.valueOf(candidate));
                }
                try {
                    serializer = candidate.get(null);
                }
                catch (ReflectiveOperationException e) {
                    throw new IllegalStateException("Failed to read field " + String.valueOf(candidate));
                }
                if (serializer == null) {
                    throw new RuntimeException("Failed to read serializer: " + candidate.getName());
                }
                if (optional) {
                    optionalRegistry.put(innerClass, new Serializer(innerClass, serializer, true));
                    continue;
                }
                rawRegistry.put(innerClass, new Serializer(innerClass, serializer, false));
            }
            RAW_REGISTRY = ImmutableMap.copyOf(rawRegistry);
            OPTIONAL_REGISTRY = ImmutableMap.copyOf(optionalRegistry);
        }

        public static Serializer getChatComponentSerializer() {
            return Registry.getChatComponentSerializer(false);
        }

        public static Serializer getChatComponentSerializer(boolean optional) {
            return Registry.get(MinecraftReflection.getIChatBaseComponentClass(), optional);
        }

        public static Serializer getItemStackSerializer(boolean optional) {
            return Registry.get(MinecraftReflection.getItemStackClass(), optional);
        }

        public static Serializer getBlockDataSerializer(boolean optional) {
            return Registry.get(MinecraftReflection.getIBlockDataClass(), optional);
        }

        public static Serializer getVectorSerializer() {
            return Registry.get(Vector3F.getMinecraftClass());
        }

        public static Serializer getBlockPositionSerializer(boolean optional) {
            return Registry.get(MinecraftReflection.getBlockPositionClass(), optional);
        }

        public static Serializer getDirectionSerializer() {
            return Registry.get(EnumWrappers.getDirectionClass());
        }

        public static Serializer getUUIDSerializer(boolean optional) {
            return Registry.get(UUID.class, optional);
        }

        public static Serializer getNBTCompoundSerializer() {
            return Registry.get(MinecraftReflection.getNBTCompoundClass(), false);
        }
    }

    public static class Serializer
    extends AbstractWrapper {
        private static final Class<?> HANDLE_TYPE = MinecraftReflection.getDataWatcherSerializerClass();
        private final Class<?> type;
        private final boolean optional;

        public Serializer(Class<?> type, Object handle, boolean optional) {
            super(HANDLE_TYPE);
            this.type = type;
            this.optional = optional;
            this.setHandle(handle);
        }

        public Class<?> getType() {
            return this.type;
        }

        public boolean isOptional() {
            return this.optional;
        }

        @Override
        public String toString() {
            return "Serializer[type=" + String.valueOf(this.type) + ", handle=" + String.valueOf(this.handle) + ", optional=" + this.optional + "]";
        }
    }

    private static class DummyWatcherObject
    extends WrappedDataWatcherObject {
        private final int index;

        public DummyWatcherObject(int index) {
            this.index = index;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Serializer getSerializer() {
            return null;
        }

        @Override
        public Object getHandle() {
            return this.getIndex();
        }

        @Override
        public Class<?> getHandleType() {
            return Integer.TYPE;
        }

        @Override
        public void checkSerializer() {
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj instanceof DummyWatcherObject) {
                DummyWatcherObject that = (DummyWatcherObject)obj;
                return this.index == that.index;
            }
            return false;
        }
    }
}

