/*
 * Decompiled with CFR 0.152.
 */
package io.servertap;

import io.servertap.WebServer;
import io.servertap.WebServerRoutes;
import io.servertap.api.v1.models.ConsoleLine;
import io.servertap.commands.ServerTapCommand;
import io.servertap.metrics.Metrics;
import io.servertap.plugin.api.ServerTapWebserverService;
import io.servertap.plugin.api.ServerTapWebserverServiceImpl;
import io.servertap.utils.ConsoleListener;
import io.servertap.utils.LagDetector;
import io.servertap.utils.pluginwrappers.ExternalPluginWrapperRepo;
import io.servertap.webhooks.WebhookEventListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.jetbrains.annotations.NotNull;

public class ServerTapMain
extends JavaPlugin {
    private static final Logger log = Bukkit.getLogger();
    private final org.apache.logging.log4j.core.Logger rootLogger = (org.apache.logging.log4j.core.Logger)LogManager.getRootLogger();
    private final List<ConsoleLine> consoleBuffer = new ArrayList<ConsoleLine>();
    private ExternalPluginWrapperRepo externalPluginWrapperRepo;
    private WebhookEventListener webhookEventListener;
    private int maxConsoleBufferSize = 1000;
    private ConsoleListener consoleListener;
    public static ServerTapMain instance;
    private final LagDetector lagDetector;
    private final Server server;
    private WebServer app;

    public ServerTapMain() {
        instance = this;
        this.server = this.getServer();
        this.lagDetector = new LagDetector();
    }

    public ServerTapMain(@NotNull JavaPluginLoader loader, @NotNull PluginDescriptionFile description2, @NotNull File dataFolder, @NotNull File file) {
        super(loader, description2, dataFolder, file);
        instance = this;
        this.server = this.getServer();
        this.lagDetector = new LagDetector();
    }

    public void onEnable() {
        new Metrics(this, 9492);
        this.externalPluginWrapperRepo = new ExternalPluginWrapperRepo(this, log);
        Bukkit.getScheduler().runTaskTimer((Plugin)this, (Runnable)this.lagDetector, 100L, 1L);
        this.saveDefaultConfig();
        FileConfiguration bukkitConfig = this.getConfig();
        this.maxConsoleBufferSize = bukkitConfig.getInt("websocketConsoleBuffer");
        this.consoleListener = new ConsoleListener(this);
        this.rootLogger.addFilter((Filter)this.consoleListener);
        this.setupWebServer(bukkitConfig);
        new ServerTapCommand(this);
        this.webhookEventListener = new WebhookEventListener(this, bukkitConfig, log, this.externalPluginWrapperRepo.getEconomyWrapper());
        this.server.getPluginManager().registerEvents((Listener)this.webhookEventListener, (Plugin)this);
        this.server.getServicesManager().register(ServerTapWebserverService.class, (Object)new ServerTapWebserverServiceImpl(this), (Plugin)this, ServicePriority.Normal);
    }

    private void setupWebServer(FileConfiguration bukkitConfig) {
        this.app = new WebServer(this, bukkitConfig, log);
        this.app.start(bukkitConfig.getInt("port", 4567));
        WebServerRoutes.addV1Routes(this, log, this.lagDetector, this.app, this.consoleListener, this.externalPluginWrapperRepo);
    }

    public void reload() {
        if (this.app != null) {
            this.app.stop();
        }
        log.info("[ServerTap] ServerTap reloading...");
        this.reloadConfig();
        FileConfiguration bukkitConfig = this.getConfig();
        this.maxConsoleBufferSize = bukkitConfig.getInt("websocketConsoleBuffer");
        this.externalPluginWrapperRepo = new ExternalPluginWrapperRepo(this, log);
        this.consoleListener.resetListeners();
        this.setupWebServer(bukkitConfig);
        this.webhookEventListener.loadWebhooksFromConfig(bukkitConfig);
        log.info("[ServerTap] ServerTap reloaded successfully!");
    }

    public void onDisable() {
        log.info(String.format("[%s] Disabled Version %s", this.getDescription().getName(), this.getDescription().getVersion()));
        if (this.app != null) {
            this.app.stop();
        }
    }

    public int getMaxConsoleBufferSize() {
        return this.maxConsoleBufferSize;
    }

    public List<ConsoleLine> getConsoleBuffer() {
        return this.consoleBuffer;
    }

    public WebServer getWebServer() {
        return this.app;
    }
}

