/*
 * Decompiled with CFR 0.152.
 */
package io.servertap.api.v1;

import de.tr7zw.nbtapi.NBTFile;
import io.javalin.http.BadRequestResponse;
import io.javalin.http.Context;
import io.javalin.http.HttpResponseException;
import io.javalin.http.InternalServerErrorResponse;
import io.javalin.http.NotFoundResponse;
import io.javalin.openapi.HttpMethod;
import io.javalin.openapi.OpenApi;
import io.javalin.openapi.OpenApiContent;
import io.javalin.openapi.OpenApiParam;
import io.javalin.openapi.OpenApiResponse;
import io.servertap.api.v1.ValidationUtils;
import io.servertap.api.v1.models.ItemStack;
import io.servertap.api.v1.models.OfflinePlayer;
import io.servertap.api.v1.models.Player;
import io.servertap.utils.pluginwrappers.EconomyWrapper;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class PlayerApi {
    private final EconomyWrapper economy;
    private final Logger log;

    public PlayerApi(Logger log, EconomyWrapper economy) {
        this.economy = economy;
        this.log = log;
    }

    @OpenApi(path="/v1/players", summary="Gets all currently online players", tags={"Player"}, headers={@OpenApiParam(name="key")}, responses={@OpenApiResponse(status="200", content={@OpenApiContent(from=Player.class)})})
    public void playersGet(Context ctx) {
        ArrayList players = new ArrayList();
        Bukkit.getOnlinePlayers().forEach(player -> players.add(this.getPlayer((org.bukkit.entity.Player)player)));
        ctx.json(players);
    }

    @OpenApi(path="/v1/players/{uuid}", methods={HttpMethod.GET}, summary="Gets a specific online player by their UUID", tags={"Player"}, headers={@OpenApiParam(name="key")}, pathParams={@OpenApiParam(name="uuid", description="UUID of the player")}, responses={@OpenApiResponse(status="200", content={@OpenApiContent(from=Player.class)})})
    public void playerGet(Context ctx) {
        String uuid = ctx.pathParam("uuid");
        if (uuid.isEmpty()) {
            throw new BadRequestResponse("Player UUID is required");
        }
        UUID playerUUID = ValidationUtils.safeUUID(uuid);
        if (playerUUID == null) {
            throw new BadRequestResponse("Invalid UUID");
        }
        org.bukkit.entity.Player player = Bukkit.getPlayer((UUID)playerUUID);
        if (player == null) {
            throw new NotFoundResponse("Player cannot be found");
        }
        ctx.json(this.getPlayer(player));
    }

    private Player getPlayer(org.bukkit.entity.Player player) {
        Player p = new Player();
        p.setUuid(player.getUniqueId().toString());
        p.setDisplayName(player.getDisplayName());
        p.setAddress(player.getAddress().getHostName());
        p.setPort(player.getAddress().getPort());
        p.setExhaustion(Float.valueOf(player.getExhaustion()));
        p.setExp(Float.valueOf(player.getExp()));
        p.setWhitelisted(player.isWhitelisted());
        p.setBanned(player.isBanned());
        p.setOp(player.isOp());
        if (this.economy.isAvailable()) {
            p.setBalance(this.economy.getPlayerBalance((org.bukkit.OfflinePlayer)player));
        }
        p.setHunger(player.getFoodLevel());
        p.setHealth(player.getHealth());
        p.setSaturation(Float.valueOf(player.getSaturation()));
        p.setDimension(player.getWorld().getEnvironment());
        Location playerLocation = player.getLocation();
        Double[] convertedLocation = new Double[]{playerLocation.getX(), playerLocation.getY(), playerLocation.getZ()};
        p.setLocation(convertedLocation);
        p.setGamemode(player.getGameMode());
        p.setLastPlayed(player.getLastPlayed());
        return p;
    }

    @OpenApi(path="/v1/players/all", summary="Gets all players that have ever joined the server ", tags={"Player"}, headers={@OpenApiParam(name="key")}, responses={@OpenApiResponse(status="200", content={@OpenApiContent(from=OfflinePlayer.class)})})
    public void offlinePlayersGet(Context ctx) {
        org.bukkit.OfflinePlayer[] offlinePlayers;
        ArrayList<OfflinePlayer> players = new ArrayList<OfflinePlayer>();
        for (org.bukkit.OfflinePlayer offlinePlayer : offlinePlayers = Bukkit.getOfflinePlayers()) {
            OfflinePlayer p = new OfflinePlayer();
            p.setDisplayName(offlinePlayer.getName());
            p.setUuid(offlinePlayer.getUniqueId().toString());
            p.setWhitelisted(offlinePlayer.isWhitelisted());
            p.setBanned(offlinePlayer.isBanned());
            p.setOp(offlinePlayer.isOp());
            if (this.economy.isAvailable()) {
                p.setBalance(this.economy.getPlayerBalance(offlinePlayer));
            }
            p.setLastPlayed(offlinePlayer.getLastPlayed());
            players.add(p);
        }
        ctx.json(players);
    }

    @OpenApi(path="/v1/players/{playerUuid}/{worldUuid}/inventory", methods={HttpMethod.GET}, summary="Gets a specific online player's Inventory in the specified world", tags={"Player"}, headers={@OpenApiParam(name="key")}, pathParams={@OpenApiParam(name="playerUuid", description="UUID of the player"), @OpenApiParam(name="worldUuid", description="UUID of the world")}, responses={@OpenApiResponse(status="200", content={@OpenApiContent(from=ItemStack.class)})})
    public void getPlayerInv(Context ctx) {
        String playerUUIDStr = ctx.pathParam("playerUuid");
        String worldUUIDStr = ctx.pathParam("worldUuid");
        if (playerUUIDStr.isEmpty() || worldUUIDStr.isEmpty()) {
            throw new BadRequestResponse("Missing uuid and/or world");
        }
        UUID playerUUID = ValidationUtils.safeUUID(playerUUIDStr);
        if (playerUUID == null) {
            throw new BadRequestResponse("Invalid UUID");
        }
        UUID worldUUID = ValidationUtils.safeUUID(worldUUIDStr);
        if (worldUUID == null) {
            throw new BadRequestResponse("Invalid UUID");
        }
        ArrayList<ItemStack> inv = new ArrayList<ItemStack>();
        org.bukkit.entity.Player player = Bukkit.getPlayer((UUID)playerUUID);
        if (player != null) {
            player.updateInventory();
            Integer location = -1;
            for (org.bukkit.inventory.ItemStack itemStack : player.getInventory().getContents()) {
                Integer n = location;
                location = location + 1;
                if (itemStack == null) continue;
                ItemStack itemObj = new ItemStack();
                itemObj.setId("minecraft:" + itemStack.getType().toString().toLowerCase());
                itemObj.setCount(itemStack.getAmount());
                itemObj.setSlot(location);
                inv.add(itemObj);
            }
            ctx.json(inv);
        } else {
            try {
                World bukWorld = Bukkit.getWorld((UUID)worldUUID);
                if (bukWorld == null) {
                    throw new NotFoundResponse("World cannot be found");
                }
                String dataPath = String.format("%s/%s/playerdata/%s.dat", new File("./").getAbsolutePath(), bukWorld.getName(), ctx.pathParam("playerUuid"));
                File playerfile = new File(Paths.get(dataPath, new String[0]).toString());
                if (!playerfile.exists()) {
                    throw new NotFoundResponse("Player cannot be found");
                }
                NBTFile playerFile = new NBTFile(playerfile);
                playerFile.getCompoundList("Inventory").forEach(item -> {
                    ItemStack itemObj = new ItemStack();
                    itemObj.setId(item.getString("id"));
                    itemObj.setCount(item.getInteger("Count"));
                    itemObj.setSlot(item.getInteger("Slot"));
                    inv.add(itemObj);
                });
                ctx.json(inv);
            }
            catch (HttpResponseException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.warning(e.getMessage());
                throw new InternalServerErrorResponse("A problem occured when attempting to parse the user file");
            }
        }
    }
}

