/*
 * Decompiled with CFR 0.152.
 */
package io.servertap.api.v1.websockets;

import io.javalin.websocket.WsConfig;
import io.javalin.websocket.WsContext;
import io.servertap.ServerTapMain;
import io.servertap.api.v1.models.ConsoleLine;
import io.servertap.utils.ConsoleListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.plugin.Plugin;

public class WebsocketHandler {
    private final Map<String, WsContext> subscribers = new ConcurrentHashMap<String, WsContext>();
    private final ServerTapMain main;
    private final Logger log;

    public WebsocketHandler(ServerTapMain main, Logger log, ConsoleListener consoleListener) {
        this.main = main;
        this.log = log;
        consoleListener.addListener(this::broadcast);
    }

    public void events(WsConfig ws) {
        ws.onConnect(ctx -> {
            this.subscribers.put(this.clientHash(ctx), ctx);
            for (ConsoleLine line : this.main.getConsoleBuffer()) {
                ctx.send(line);
            }
        });
        ws.onClose(ctx -> this.subscribers.remove(this.clientHash(ctx)));
        ws.onError(ctx -> this.subscribers.remove(this.clientHash(ctx)));
        ws.onMessage(ctx -> {
            String cmd = ctx.message().trim();
            if (!cmd.isEmpty()) {
                if (cmd.startsWith("/")) {
                    cmd = cmd.substring(1);
                }
                String command = cmd;
                if (this.main != null) {
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.main, () -> {
                        try {
                            ConsoleCommandSender sender = Bukkit.getServer().getConsoleSender();
                            Bukkit.dispatchCommand((CommandSender)sender, (String)command);
                        }
                        catch (Exception e) {
                            this.log.warning("Couldn't execute command over websocket");
                        }
                    });
                }
            }
        });
    }

    public void broadcast(Object message) {
        this.subscribers.values().stream().filter(ctx -> ctx.session.isOpen()).forEach(session -> session.send(message));
    }

    private String clientHash(WsContext ctx) {
        return String.format("sub-%s-%s", ctx.host(), ctx.getSessionId());
    }
}

