/*
 * Decompiled with CFR 0.152.
 */
package io.servertap.utils;

import io.servertap.ServerTapMain;
import io.servertap.api.v1.models.ConsoleLine;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.message.Message;

public class ConsoleListener
implements Filter {
    private final ServerTapMain plugin;
    private final List<Consumer<ConsoleLine>> listeners = new ArrayList<Consumer<ConsoleLine>>();

    public ConsoleListener(ServerTapMain main) {
        this.plugin = main;
    }

    public Filter.Result filter(LogEvent logEvent) {
        if (this.plugin.getMaxConsoleBufferSize() > 0 && this.plugin.getConsoleBuffer().size() >= this.plugin.getMaxConsoleBufferSize()) {
            this.plugin.getConsoleBuffer().remove(0);
        }
        ConsoleLine line = new ConsoleLine();
        line.setLevel(logEvent.getLevel().toString());
        line.setTimestampMillis(logEvent.getTimeMillis());
        line.setMessage(logEvent.getMessage().getFormattedMessage());
        line.setLoggerName(logEvent.getLoggerName());
        if (this.plugin.getMaxConsoleBufferSize() > 0) {
            this.plugin.getConsoleBuffer().add(line);
        }
        this.listeners.forEach(consoleLineConsumer -> consoleLineConsumer.accept(line));
        return Filter.Result.NEUTRAL;
    }

    public void addListener(Consumer<ConsoleLine> consoleLineConsumer) {
        this.listeners.add(consoleLineConsumer);
    }

    public void resetListeners() {
        this.listeners.clear();
    }

    public Filter.Result getOnMismatch() {
        return null;
    }

    public Filter.Result getOnMatch() {
        return null;
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String s, Object ... objects) {
        return null;
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String s, Object o) {
        return null;
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String s, Object o, Object o1) {
        return null;
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String s, Object o, Object o1, Object o2) {
        return null;
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String s, Object o, Object o1, Object o2, Object o3) {
        return null;
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String s, Object o, Object o1, Object o2, Object o3, Object o4) {
        return null;
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String s, Object o, Object o1, Object o2, Object o3, Object o4, Object o5) {
        return null;
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String s, Object o, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6) {
        return null;
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String s, Object o, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7) {
        return null;
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String s, Object o, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8) {
        return null;
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, String s, Object o, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9) {
        return null;
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Object o, Throwable throwable) {
        return null;
    }

    public Filter.Result filter(Logger logger, Level level, Marker marker, Message message, Throwable throwable) {
        return null;
    }

    public LifeCycle.State getState() {
        return null;
    }

    public void initialize() {
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean isStarted() {
        return false;
    }

    public boolean isStopped() {
        return false;
    }
}

