/*
 * Decompiled with CFR 0.152.
 */
package io.servertap.utils;

public class LagDetector
implements Runnable {
    private final long[] TICKS = new long[600];
    private int TICK_COUNT = 0;

    public String getTPSString() {
        try {
            String tps;
            double tpsDouble = this.getTPS();
            if (tpsDouble > 19.5) {
                tpsDouble = 20.0;
            }
            return (tps = Double.toString(tpsDouble)).length() > 4 ? tps.substring(0, 4) : tps;
        }
        catch (Exception e) {
            return "3.14";
        }
    }

    public double getTPS() {
        return this.getTPS(100);
    }

    public double getTPS(int ticks) {
        if (this.TICK_COUNT < ticks) {
            return 20.0;
        }
        int target = (this.TICK_COUNT - 1 - ticks) % this.TICKS.length;
        long elapsed = System.currentTimeMillis() - this.TICKS[target];
        return (double)ticks / ((double)elapsed / 1000.0);
    }

    @Override
    public void run() {
        this.TICKS[this.TICK_COUNT % this.TICKS.length] = System.currentTimeMillis();
        ++this.TICK_COUNT;
    }
}

