/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.hostnameverifier;

import java.net.IDN;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import nl.altindag.ssl.exception.GenericHostnameVerifierException;
import nl.altindag.ssl.hostnameverifier.HostnameCommon;

final class Hostnames {
    private Hostnames() {
    }

    static String toCanonicalHost(String host2) {
        String result2 = host2;
        if (host2.contains(":")) {
            if (host2.startsWith("[") && host2.endsWith("]")) {
                result2 = host2.substring(1, host2.length() - 1);
            }
            try {
                InetAddress inetAddress = InetAddress.getByName(result2);
                return inetAddress.getHostAddress();
            }
            catch (UnknownHostException e) {
                throw new GenericHostnameVerifierException(e);
            }
        }
        try {
            result2 = IDN.toASCII(host2).toLowerCase(Locale.US);
            if (result2.isEmpty()) {
                return null;
            }
            if (HostnameCommon.containsInvalidHostnameAsciiCodes(result2)) {
                return null;
            }
            if (HostnameCommon.containsInvalidLabelLengths(result2)) {
                return null;
            }
            return result2;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

