/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.api.storage;

import java.util.Optional;
import java.util.UUID;
import net.skinsrestorer.api.connections.model.MineSkinResponse;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.api.exception.MineSkinException;
import net.skinsrestorer.api.property.InputDataResult;
import net.skinsrestorer.api.property.MojangSkinDataResult;
import net.skinsrestorer.api.property.SkinIdentifier;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.api.property.SkinVariant;

public interface SkinStorage {
    public Optional<SkinProperty> updatePlayerSkinData(UUID var1) throws DataRequestException;

    public Optional<MojangSkinDataResult> getPlayerSkin(String var1, boolean var2) throws DataRequestException;

    public void setPlayerSkinData(UUID var1, String var2, SkinProperty var3, long var4);

    public void setURLSkinData(String var1, String var2, SkinProperty var3, SkinVariant var4);

    public void setURLSkinIndex(String var1, SkinVariant var2);

    default public void setURLSkinByResponse(String url, MineSkinResponse response) {
        if (response.getRequestedVariant() == null) {
            this.setURLSkinIndex(url, response.getGeneratedVariant());
        }
        this.setURLSkinData(url, response.getMineSkinId(), response.getProperty(), response.getGeneratedVariant());
    }

    public void setCustomSkinData(String var1, SkinProperty var2);

    default public Optional<InputDataResult> findSkinData(String input) {
        return this.findSkinData(input, null);
    }

    public Optional<InputDataResult> findSkinData(String var1, SkinVariant var2);

    default public Optional<InputDataResult> findOrCreateSkinData(String input) throws DataRequestException, MineSkinException {
        return this.findOrCreateSkinData(input, null);
    }

    public Optional<InputDataResult> findOrCreateSkinData(String var1, SkinVariant var2) throws DataRequestException, MineSkinException;

    public Optional<SkinProperty> getSkinDataByIdentifier(SkinIdentifier var1);

    public void removeSkinData(SkinIdentifier var1);
}

