/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.skinsrestorer.api.semver.SemanticVersion;
import net.skinsrestorer.bukkit.SRBukkitAdapter;
import net.skinsrestorer.bukkit.SkinApplierBukkit;
import net.skinsrestorer.bukkit.hooks.SRPlaceholderAPIExpansion;
import net.skinsrestorer.bukkit.listener.AdminInfoListener;
import net.skinsrestorer.bukkit.listener.InventoryListener;
import net.skinsrestorer.bukkit.listener.PlayerJoinListener;
import net.skinsrestorer.bukkit.listener.PlayerResourcePackStatusListener;
import net.skinsrestorer.bukkit.listener.ServerMessageListener;
import net.skinsrestorer.bukkit.paper.PaperPlayerJoinEvent;
import net.skinsrestorer.bukkit.refresher.MappingSpigotSkinRefresher;
import net.skinsrestorer.bukkit.refresher.PaperSkinRefresher;
import net.skinsrestorer.bukkit.refresher.SkinRefresher;
import net.skinsrestorer.bukkit.refresher.SpigotSkinRefresher;
import net.skinsrestorer.bukkit.utils.BukkitPropertyApplier;
import net.skinsrestorer.bukkit.utils.BukkitReflection;
import net.skinsrestorer.bukkit.utils.SkinApplyBukkitAdapter;
import net.skinsrestorer.bukkit.wrapper.WrapperBukkit;
import net.skinsrestorer.miniplaceholders.SRMiniPlaceholdersAPIExpansion;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_N_F_Files;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_Optional;
import net.skinsrestorer.shared.config.AdvancedConfig;
import net.skinsrestorer.shared.info.ClassInfo;
import net.skinsrestorer.shared.info.PluginInfo;
import net.skinsrestorer.shared.log.SRChatColor;
import net.skinsrestorer.shared.log.SRLogLevel;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.plugin.SRServerPlatformInit;
import net.skinsrestorer.shared.subjects.messages.ComponentHelper;
import net.skinsrestorer.shared.subjects.messages.SkinsRestorerLocale;
import net.skinsrestorer.shared.subjects.permissions.PermissionGroup;
import net.skinsrestorer.shared.subjects.permissions.PermissionRegistry;
import net.skinsrestorer.shared.utils.ReflectionUtil;
import net.skinsrestorer.viaversion.ViaPacketData;
import net.skinsrestorer.viaversion.ViaRefreshProvider;
import net.skinsrestorer.viaversion.ViaWorkaround;
import org.bukkit.Server;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.plugin.messaging.PluginMessageListener;

public class SRBukkitInit
implements SRServerPlatformInit {
    private final SRPlugin plugin;
    private final SRBukkitAdapter adapter;
    private final Injector injector;
    private final SRLogger logger;
    private final Server server;
    private final WrapperBukkit wrapper;
    private final SkinsRestorerLocale locale;
    private final SettingsManager settingsManager;

    @Override
    public void initSkinApplier() {
        this.injector.register(SkinApplyBukkitAdapter.class, this.injector.getSingleton(BukkitPropertyApplier.class));
        this.injector.register(SkinRefresher.class, this.detectRefresh());
        this.plugin.registerSkinApplier(this.injector.getSingleton(SkinApplierBukkit.class), Player.class, this.wrapper);
        this.logger.info(SRBukkitInit.jvmdowngrader$concat$initSkinApplier$1(String.valueOf((Object)SRChatColor.GREEN), String.valueOf((Object)SRChatColor.YELLOW), String.valueOf(BukkitReflection.SERVER_VERSION), String.valueOf((Object)SRChatColor.GREEN)));
        if (BukkitReflection.SERVER_VERSION.isOlderThan(new SemanticVersion(1, 8, 0))) {
            this.logger.warning(SRBukkitInit.jvmdowngrader$concat$initSkinApplier$1(String.valueOf((Object)SRChatColor.YELLOW)));
        }
    }

    private SkinRefresher detectRefresh() {
        if (SRPlugin.isUnitTest()) {
            return SkinRefresher.NO_OP;
        }
        if (this.isPaper()) {
            boolean viaBackwardsExists = this.adapter.getPluginInfo("ViaBackwards").isPresent();
            boolean protocolSupportExists = this.adapter.getPluginInfo("ProtocolSupport").isPresent();
            if (viaBackwardsExists || protocolSupportExists) {
                this.logger.debug(SRLogLevel.WARNING, "Unsupported plugin (ViaBackwards or ProtocolSupport) detected, forcing SpigotSkinRefresher");
                return this.selectSpigotRefresher();
            }
            try {
                this.logger.debug("Using PaperSkinRefresher");
                return this.injector.getSingleton(PaperSkinRefresher.class);
            }
            catch (Exception e) {
                this.logger.severe("PaperSkinRefresher failed! (Are you using hybrid software?) Only limited support can be provided. Falling back to SpigotSkinRefresher.", e);
            }
        }
        return this.selectSpigotRefresher();
    }

    private SkinRefresher selectSpigotRefresher() {
        if (this.adapter.getPluginInfo("ViaBackwards").isPresent() && ViaWorkaround.shouldApplyWorkaround()) {
            this.logger.debug("Activating ViaBackwards workaround.");
            this.injector.register(ViaRefreshProvider.class, d -> {
                try {
                    return ViaWorkaround.sendCustomPacketVia((ViaPacketData)d.get());
                }
                catch (Exception e) {
                    this.logger.severe("Error while refreshing skin via ViaBackwards", e);
                    return false;
                }
            });
        } else {
            this.injector.register(ViaRefreshProvider.class, ViaRefreshProvider.NO_OP);
        }
        if (BukkitReflection.SERVER_VERSION.isNewerThan(new SemanticVersion(1, 17, 1))) {
            this.logger.debug("Using MappingSpigotSkinRefresher");
            return this.injector.getSingleton(MappingSpigotSkinRefresher.class);
        }
        this.logger.debug("Using SpigotSkinRefresher");
        return this.injector.getSingleton(SpigotSkinRefresher.class);
    }

    private boolean isPaper() {
        if (ClassInfo.get().isPaper() && BukkitReflection.SERVER_VERSION.isNewerThan(new SemanticVersion(1, 11, 2))) {
            if (this.hasPaperMethods()) {
                return true;
            }
            this.logger.debug(SRLogLevel.WARNING, "Paper detected, but the methods are missing. Disabling Paper Refresher.");
            return false;
        }
        return false;
    }

    private boolean hasPaperMethods() {
        try {
            Objects.requireNonNull(BukkitReflection.getBukkitClass("entity.CraftPlayer").getDeclaredMethod("refreshPlayer", new Class[0]));
            return true;
        }
        catch (ReflectiveOperationException e) {
            return false;
        }
    }

    @Override
    public void initLoginProfileListener() {
        if (PaperPlayerJoinEvent.isAvailable() && this.settingsManager.getProperty(AdvancedConfig.ENABLE_PAPER_JOIN_LISTENER).booleanValue()) {
            this.logger.info("Using paper join listener!");
            this.server.getPluginManager().registerEvents((Listener)this.injector.newInstance(PaperPlayerJoinEvent.class), (Plugin)this.adapter.getPluginInstance());
        } else {
            this.server.getPluginManager().registerEvents((Listener)this.injector.newInstance(PlayerJoinListener.class), (Plugin)this.adapter.getPluginInstance());
            if (ReflectionUtil.classExists("org.bukkit.event.player.PlayerResourcePackStatusEvent")) {
                this.server.getPluginManager().registerEvents((Listener)this.injector.newInstance(PlayerResourcePackStatusListener.class), (Plugin)this.adapter.getPluginInstance());
            }
        }
    }

    @Override
    public void initAdminInfoListener() {
        this.server.getPluginManager().registerEvents((Listener)this.injector.getSingleton(AdminInfoListener.class), (Plugin)this.adapter.getPluginInstance());
    }

    @Override
    public void prePlatformInit() {
        this.plugin.getShutdownHooks().add(() -> this.adapter.getAdventure().get().close());
    }

    @Override
    public void checkPluginSupport() {
        this.checkViaVersion();
        this.checkMundoSK();
    }

    private void checkViaVersion() {
        Optional<PluginInfo> viaVersion = this.adapter.getPluginInfo("ViaVersion");
        Optional<PluginInfo> viaBackwards = this.adapter.getPluginInfo("ViaBackwards");
        if (J_U_Optional.isEmpty(viaVersion) || J_U_Optional.isEmpty(viaBackwards)) {
            return;
        }
        SemanticVersion viaVersionVersion = viaVersion.get().parsedVersion();
        SemanticVersion viaBackwardsVersion = viaBackwards.get().parsedVersion();
        SemanticVersion requiredVersion = new SemanticVersion(5, 0, 0);
        if (!viaVersionVersion.isOlderThan(requiredVersion) && !viaBackwardsVersion.isOlderThan(requiredVersion)) {
            return;
        }
        this.adapter.runRepeatAsync(() -> this.logger.severe("Outdated ViaVersion/ViaBackwards found! Please update to at least ViaVersion/ViaBackwards 5.0.0 for SkinsRestorer to work again!"), 2L, 60L, TimeUnit.SECONDS);
    }

    private void checkMundoSK() {
        if (J_U_Optional.isEmpty(this.adapter.getPluginInfo("MundoSK"))) {
            return;
        }
        Path pluginsFolder = this.plugin.getDataFolder().getParent();
        if (pluginsFolder == null) {
            return;
        }
        try {
            YamlConfiguration config = new YamlConfiguration();
            config.load(J_N_F_Files.readString(pluginsFolder.resolve("MundoSK").resolve("config.yml")));
            if (config.getBoolean("enable_custom_skin_and_tablist")) {
                this.logger.warning(SRBukkitInit.jvmdowngrader$concat$checkMundoSK$1(String.valueOf((Object)SRChatColor.DARK_RED)));
                this.logger.warning(SRBukkitInit.jvmdowngrader$concat$checkMundoSK$2(String.valueOf((Object)SRChatColor.DARK_RED)));
                this.logger.warning(SRBukkitInit.jvmdowngrader$concat$checkMundoSK$1(String.valueOf((Object)SRChatColor.RED), String.valueOf((Object)SRChatColor.YELLOW), String.valueOf((Object)SRChatColor.DARK_RED), String.valueOf((Object)SRChatColor.UNDERLINE), String.valueOf((Object)SRChatColor.YELLOW), String.valueOf((Object)SRChatColor.RED)));
                this.logger.warning(SRBukkitInit.jvmdowngrader$concat$checkMundoSK$3(String.valueOf((Object)SRChatColor.RED)));
                this.logger.warning(SRBukkitInit.jvmdowngrader$concat$checkMundoSK$4(String.valueOf((Object)SRChatColor.RED)));
                this.logger.warning(SRBukkitInit.jvmdowngrader$concat$checkMundoSK$1(String.valueOf((Object)SRChatColor.DARK_RED)));
            }
        }
        catch (IOException | InvalidConfigurationException e) {
            this.logger.warning("Could not read MundoSK config.yml to check for 'enable_custom_skin_and_tablist'!", e);
        }
    }

    @Override
    public void initPermissions() {
        for (PermissionRegistry permissionRegistry : PermissionRegistry.values()) {
            String permissionString = permissionRegistry.getPermission().getPermissionString();
            String description = ComponentHelper.convertJsonToLegacy(this.locale.getMessageRequired(this.locale.getDefaultForeign(), permissionRegistry.getDescription()));
            this.addPermission(new Permission(permissionString, description));
        }
        for (Enum enum_ : PermissionGroup.values()) {
            String description = ComponentHelper.convertJsonToLegacy(this.locale.getMessageRequired(this.locale.getDefaultForeign(), ((PermissionGroup)enum_).getDescription()));
            HashMap<String, Boolean> children = new HashMap<String, Boolean>();
            this.mergePermissions((PermissionGroup)enum_, children);
            PermissionDefault permissionDefault = enum_ == PermissionGroup.PLAYER ? PermissionDefault.TRUE : PermissionDefault.OP;
            this.addPermission(new Permission(((PermissionGroup)enum_).getBasePermission().getPermissionString(), description, permissionDefault, children));
            this.addPermission(new Permission(((PermissionGroup)enum_).getWildcard().getPermissionString(), description, permissionDefault, children));
        }
    }

    private void addPermission(Permission permission) {
        SimplePluginManager pluginManager = (SimplePluginManager)this.server.getPluginManager();
        if (pluginManager.getPermission(permission.getName()) != null) {
            return;
        }
        pluginManager.addPermission(permission);
    }

    private void mergePermissions(PermissionGroup group, Map<String, Boolean> data) {
        for (PermissionRegistry permissionRegistry : group.getPermissions()) {
            data.put(permissionRegistry.getPermission().getPermissionString(), true);
        }
        for (Enum enum_ : group.getParents()) {
            this.mergePermissions((PermissionGroup)enum_, data);
        }
    }

    @Override
    public void initGUIListener() {
        this.server.getPluginManager().registerEvents((Listener)this.injector.getSingleton(InventoryListener.class), (Plugin)this.adapter.getPluginInstance());
    }

    @Override
    public void initMessageChannel() {
        this.server.getMessenger().registerOutgoingPluginChannel((Plugin)this.adapter.getPluginInstance(), "sr:messagechannel");
        this.server.getMessenger().registerIncomingPluginChannel((Plugin)this.adapter.getPluginInstance(), "sr:messagechannel", (PluginMessageListener)this.injector.getSingleton(ServerMessageListener.class));
    }

    @Override
    public void placeholderSetupHook() {
        if (this.adapter.getPluginInfo("PlaceholderAPI").isPresent()) {
            try {
                new SRPlaceholderAPIExpansion(this.logger, this.adapter.getPluginInstance().getDescription(), this.injector).register();
                this.logger.info("PlaceholderAPI expansion registered!");
            }
            catch (Throwable t) {
                this.logger.severe("Failed to load PlaceholderAPI expansion! Please check if both SkinsRestorer and PlaceholderAPI are up-to-date.", t);
            }
        }
        if (this.adapter.getPluginInfo("MiniPlaceholders").isPresent()) {
            try {
                new SRMiniPlaceholdersAPIExpansion<Player>(this.adapter, Player.class, this.wrapper::player).register();
                this.logger.info("MiniPlaceholders expansion registered!");
            }
            catch (Throwable t) {
                this.logger.severe("Failed to load MiniPlaceholders expansion! Please check if both SkinsRestorer and MiniPlaceholders are up-to-date.", t);
            }
        }
    }

    @Inject
    @Generated
    public SRBukkitInit(SRPlugin plugin, SRBukkitAdapter adapter, Injector injector, SRLogger logger, Server server, WrapperBukkit wrapper, SkinsRestorerLocale locale, SettingsManager settingsManager) {
        this.plugin = plugin;
        this.adapter = adapter;
        this.injector = injector;
        this.logger = logger;
        this.server = server;
        this.wrapper = wrapper;
        this.locale = locale;
        this.settingsManager = settingsManager;
    }

    private static /* synthetic */ String jvmdowngrader$concat$initSkinApplier$1(String string, String string2, String string3, String string4) {
        return string + "Running on Minecraft " + string2 + string3 + string4 + ".";
    }

    private static /* synthetic */ String jvmdowngrader$concat$initSkinApplier$1(String string) {
        return string + "Although SkinsRestorer allows using this ancient version, we will not provide full support for it. This version of Minecraft does not allow using all of SkinsRestorers features due to client side restrictions. Please be aware things WILL BREAK and not work!";
    }

    private static /* synthetic */ String jvmdowngrader$concat$checkMundoSK$1(String string) {
        return string + "----------------------------------------------";
    }

    private static /* synthetic */ String jvmdowngrader$concat$checkMundoSK$2(String string) {
        return string + "             [CRITICAL WARNING]";
    }

    private static /* synthetic */ String jvmdowngrader$concat$checkMundoSK$1(String string, String string2, String string3, String string4, String string5, String string6) {
        return string + "We have detected MundoSK on your server with " + string2 + "'enable_custom_skin_and_tablist: " + string3 + string4 + "true" + string5 + "' " + string6 + ".";
    }

    private static /* synthetic */ String jvmdowngrader$concat$checkMundoSK$3(String string) {
        return string + "That setting is located in \u00a7e/plugins/MundoSK/config.yml";
    }

    private static /* synthetic */ String jvmdowngrader$concat$checkMundoSK$4(String string) {
        return string + "You have to disable ('false') it to get SkinsRestorer to work!";
    }
}

