/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.scissors;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import net.skinsrestorer.scissors.ARGBPixelProcessor;

public class Scissors {
    private Scissors() {
    }

    public static BufferedImage applyOnEachPixel(BufferedImage image, ARGBPixelProcessor processor) {
        BufferedImage processedImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int rgb = image.getRGB(x, y);
                int processedRgb = processor.applyAsInt(rgb);
                processedImage.setRGB(x, y, processedRgb);
            }
        }
        return processedImage;
    }

    public static BufferedImage flipImage(BufferedImage image, boolean horizontal) {
        BufferedImage flippedImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int newX = horizontal ? image.getWidth() - 1 - x : x;
                int newY = horizontal ? y : image.getHeight() - 1 - y;
                flippedImage.setRGB(newX, newY, image.getRGB(x, y));
            }
        }
        return flippedImage;
    }

    public static BufferedImage rotateImage(BufferedImage image, double angle) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage rotatedImage = new BufferedImage(width, height, 2);
        Graphics2D g2d = rotatedImage.createGraphics();
        g2d.rotate(Math.toRadians(angle), (double)width / 2.0, (double)height / 2.0);
        g2d.drawImage((Image)image, 0, 0, null);
        g2d.dispose();
        return rotatedImage;
    }

    public static BufferedImage zoomImage(BufferedImage image, double scaleX, double scaleY) {
        BufferedImage zoomedImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g2d = zoomedImage.createGraphics();
        g2d.scale(scaleX, scaleY);
        g2d.drawImage((Image)image, 0, 0, null);
        g2d.dispose();
        return zoomedImage;
    }
}

