/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.cloud.annotations.processing;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import net.skinsrestorer.shadow.cloud.annotations.processing.CommandContainer;
import net.skinsrestorer.shadow.cloud.annotations.processing.CommandContainerVisitor;
import net.skinsrestorer.shadow.javax.annotation.processing.AbstractProcessor;
import net.skinsrestorer.shadow.javax.annotation.processing.RoundEnvironment;
import net.skinsrestorer.shadow.javax.annotation.processing.SupportedAnnotationTypes;
import org.checkerframework.checker.nullness.qual.NonNull;

@SupportedAnnotationTypes(value={"net.skinsrestorer.shadow.cloud.annotations.processing.CommandContainer"})
public final class CommandContainerProcessor
extends AbstractProcessor {
    public static final String PATH = "META-INF/commands/org.incendo.cloud.annotations.processing.CommandContainer";

    public boolean process(@NonNull Set<? extends TypeElement> annotations, @NonNull RoundEnvironment roundEnv) {
        ArrayList<String> validTypes = new ArrayList<String>();
        Set elements = roundEnv.getElementsAnnotatedWith(CommandContainer.class);
        if (elements.isEmpty()) {
            return false;
        }
        for (Element element : elements) {
            if (element.getKind() != ElementKind.CLASS) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, (CharSequence)String.format("@Command found on unsupported element type '%s' (%s)", element.getKind().name(), element.getSimpleName().toString()), element);
                return false;
            }
            element.accept(new CommandContainerVisitor(this.processingEnv, validTypes), null);
        }
        for (String type : validTypes) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, (CharSequence)String.format("Found valid @CommandContainer-annotated class: %s", type));
        }
        this.writeCommandFile(validTypes);
        return false;
    }

    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private void writeCommandFile(@NonNull List<String> types) {
        try (BufferedWriter writer = new BufferedWriter(this.processingEnv.getFiler().createResource((JavaFileManager.Location)StandardLocation.CLASS_OUTPUT, (CharSequence)"", (CharSequence)PATH, new Element[0]).openWriter());){
            for (String t : types) {
                writer.write(t);
                writer.newLine();
            }
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

