/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.cloud.bungee.parser;

import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.skinsrestorer.shadow.cloud.bungee.BungeeCaptionKeys;
import net.skinsrestorer.shadow.cloud.caption.CaptionVariable;
import net.skinsrestorer.shadow.cloud.component.CommandComponent;
import net.skinsrestorer.shadow.cloud.context.CommandContext;
import net.skinsrestorer.shadow.cloud.context.CommandInput;
import net.skinsrestorer.shadow.cloud.exception.parsing.ParserException;
import net.skinsrestorer.shadow.cloud.parser.ArgumentParseResult;
import net.skinsrestorer.shadow.cloud.parser.ArgumentParser;
import net.skinsrestorer.shadow.cloud.parser.ParserDescriptor;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ServerParser<C>
implements ArgumentParser<C, ServerInfo> {
    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull ParserDescriptor<C, ServerInfo> serverParser() {
        return ParserDescriptor.of(new ServerParser<C>(), ServerInfo.class);
    }

    @API(status=API.Status.STABLE, since="2.0.0")
    public static <C> @NonNull CommandComponent.Builder<C, ServerInfo> serverComponent() {
        return CommandComponent.builder().parser(ServerParser.serverParser());
    }

    @Override
    public @NonNull ArgumentParseResult<@NonNull ServerInfo> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        String input = commandInput.readString();
        ServerInfo server = ((ProxyServer)commandContext.get("ProxyServer")).getServerInfo(input);
        if (server == null) {
            return ArgumentParseResult.failure(new ServerParseException(input, commandContext));
        }
        return ArgumentParseResult.success(server);
    }

    public static final class ServerParseException
    extends ParserException {
        private ServerParseException(@NonNull String input, @NonNull CommandContext<?> context) {
            super(ServerParser.class, context, BungeeCaptionKeys.ARGUMENT_PARSE_FAILURE_SERVER, CaptionVariable.of("input", input));
        }
    }
}

