/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.cloud.paper;

import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.configuration.PluginMeta;
import java.util.List;
import java.util.logging.Level;
import net.skinsrestorer.shadow.cloud.CloudCapability;
import net.skinsrestorer.shadow.cloud.CommandManager;
import net.skinsrestorer.shadow.cloud.SenderMapper;
import net.skinsrestorer.shadow.cloud.SenderMapperHolder;
import net.skinsrestorer.shadow.cloud.brigadier.BrigadierManagerHolder;
import net.skinsrestorer.shadow.cloud.brigadier.CloudBrigadierManager;
import net.skinsrestorer.shadow.cloud.bukkit.BukkitCommandContextKeys;
import net.skinsrestorer.shadow.cloud.bukkit.BukkitDefaultCaptionsProvider;
import net.skinsrestorer.shadow.cloud.bukkit.BukkitParsers;
import net.skinsrestorer.shadow.cloud.bukkit.CloudBukkitCapabilities;
import net.skinsrestorer.shadow.cloud.bukkit.PluginHolder;
import net.skinsrestorer.shadow.cloud.bukkit.internal.BukkitHelper;
import net.skinsrestorer.shadow.cloud.caption.Caption;
import net.skinsrestorer.shadow.cloud.context.CommandContext;
import net.skinsrestorer.shadow.cloud.execution.ExecutionCoordinator;
import net.skinsrestorer.shadow.cloud.internal.CommandRegistrationHandler;
import net.skinsrestorer.shadow.cloud.paper.ModernPaperBrigadier;
import net.skinsrestorer.shadow.cloud.paper.PaperCommandPreprocessor;
import net.skinsrestorer.shadow.cloud.paper.PluginMetaHolder;
import net.skinsrestorer.shadow.cloud.paper.parser.KeyedWorldParser;
import net.skinsrestorer.shadow.kyori.adventure.text.Component;
import net.skinsrestorer.shadow.kyori.adventure.text.format.NamedTextColor;
import net.skinsrestorer.shadow.kyori.adventure.text.format.TextColor;
import org.apiguardian.api.API;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@API(status=API.Status.EXPERIMENTAL)
public class PaperCommandManager<C>
extends CommandManager<C>
implements SenderMapperHolder<CommandSourceStack, C>,
PluginMetaHolder,
PluginHolder,
BrigadierManagerHolder<C, CommandSourceStack> {
    private final PluginMeta pluginMeta;
    private final SenderMapper<CommandSourceStack, C> senderMapper;

    public static <C> Builder<C> builder(SenderMapper<CommandSourceStack, C> senderMapper) {
        return new Builder(senderMapper);
    }

    public static Builder<CommandSourceStack> builder() {
        return new Builder<CommandSourceStack>(SenderMapper.identity());
    }

    private PaperCommandManager(@NonNull PluginMeta pluginMeta, @NonNull ExecutionCoordinator<C> executionCoordinator, @NonNull SenderMapper<CommandSourceStack, C> senderMapper) {
        super(executionCoordinator, CommandRegistrationHandler.nullCommandRegistrationHandler());
        this.pluginMeta = pluginMeta;
        this.senderMapper = senderMapper;
        this.commandRegistrationHandler(new ModernPaperBrigadier<C, CommandSourceStack>(CommandSourceStack.class, this, senderMapper, () -> this.lockRegistration()));
        CloudBukkitCapabilities.CAPABLE.forEach(x$0 -> this.registerCapability((CloudCapability)x$0));
        this.registerCapability(CloudCapability.StandardCapabilities.ROOT_COMMAND_DELETION);
        BukkitParsers.register(this);
        this.registerDefaultExceptionHandlers();
        this.captionRegistry().registerProvider(new BukkitDefaultCaptionsProvider());
        this.registerCommandPreProcessor(ctx -> ctx.commandContext().store(BukkitCommandContextKeys.BUKKIT_COMMAND_SENDER, this.senderMapper().reverse(ctx.commandContext().sender()).getSender()));
        this.registerCommandPreProcessor(new PaperCommandPreprocessor<CommandSourceStack, C>(this, this.senderMapper(), commandSourceStack -> {
            @Nullable Entity executor = commandSourceStack.getExecutor();
            if (executor != null) {
                return executor;
            }
            return commandSourceStack.getSender();
        }));
        this.parserRegistry().registerParser(KeyedWorldParser.keyedWorldParser());
    }

    @Override
    public final boolean hasPermission(@NonNull C sender, @NonNull String permission) {
        return this.senderMapper().reverse(sender).getSender().hasPermission(permission);
    }

    @Override
    public final @NonNull SenderMapper<CommandSourceStack, C> senderMapper() {
        return this.senderMapper;
    }

    private void registerDefaultExceptionHandlers() {
        this.registerDefaultExceptionHandlers(triplet -> this.senderMapper().reverse(((CommandContext)triplet.first()).sender()).getSender().sendMessage((Component)Component.text(((CommandContext)triplet.first()).formatCaption((Caption)triplet.second(), (List)triplet.third()), (TextColor)NamedTextColor.RED)), pair -> this.owningPlugin().getLogger().log(Level.SEVERE, (String)pair.first(), (Throwable)pair.second()));
    }

    @Override
    public final PluginMeta owningPluginMeta() {
        return this.pluginMeta;
    }

    @Override
    public final boolean hasBrigadierManager() {
        return true;
    }

    @Override
    public final @NonNull CloudBrigadierManager<C, ? extends CommandSourceStack> brigadierManager() {
        return ((BrigadierManagerHolder)((Object)this.commandRegistrationHandler())).brigadierManager();
    }

    public static final class Builder<C> {
        private final SenderMapper<CommandSourceStack, C> senderMapper;

        private Builder(SenderMapper<CommandSourceStack, C> senderMapper) {
            this.senderMapper = senderMapper;
        }

        public CoordinatedBuilder<C> executionCoordinator(ExecutionCoordinator<C> executionCoordinator) {
            return new CoordinatedBuilder(this.senderMapper, executionCoordinator);
        }
    }

    public static final class CoordinatedBuilder<C> {
        private final SenderMapper<CommandSourceStack, C> senderMapper;
        private final ExecutionCoordinator<C> executionCoordinator;

        private CoordinatedBuilder(SenderMapper<CommandSourceStack, C> senderMapper, ExecutionCoordinator<C> executionCoordinator) {
            this.senderMapper = senderMapper;
            this.executionCoordinator = executionCoordinator;
        }

        public @NonNull PaperCommandManager<C> buildOnEnable(@NonNull Plugin plugin) {
            PaperCommandManager mgr = new PaperCommandManager(plugin.getPluginMeta(), this.executionCoordinator, this.senderMapper);
            ((ModernPaperBrigadier)mgr.commandRegistrationHandler()).registerPlugin(plugin);
            BukkitHelper.ensurePluginEnabledOrEnabling(plugin);
            return mgr;
        }

        public @NonNull Bootstrapped<C> buildBootstrapped(@NonNull BootstrapContext context) {
            Bootstrapped mgr = new Bootstrapped(context.getPluginMeta(), this.executionCoordinator, this.senderMapper);
            ((ModernPaperBrigadier)mgr.commandRegistrationHandler()).registerBootstrap(context);
            return mgr;
        }
    }

    public static final class Bootstrapped<C>
    extends PaperCommandManager<C> {
        private Bootstrapped(@NonNull PluginMeta pluginMeta, @NonNull ExecutionCoordinator<C> executionCoordinator, @NonNull SenderMapper<CommandSourceStack, C> senderMapper) {
            super(pluginMeta, executionCoordinator, senderMapper);
        }

        public void onEnable() {
            BukkitHelper.ensurePluginEnabledOrEnabling(this.owningPlugin());
        }
    }
}

