/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.cloud.processors.cooldown.profile;

import java.time.Clock;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import net.skinsrestorer.shadow.cloud.processors.cooldown.CooldownGroup;
import net.skinsrestorer.shadow.cloud.processors.cooldown.CooldownInstance;
import net.skinsrestorer.shadow.cloud.processors.cooldown.profile.CooldownProfile;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class CooldownProfileImpl
implements CooldownProfile {
    private final Map<CooldownGroup, CooldownInstance> cooldowns = new HashMap<CooldownGroup, CooldownInstance>();
    private final Clock clock;

    CooldownProfileImpl(@NonNull Clock clock) {
        this.clock = clock;
    }

    @Override
    public synchronized @Nullable CooldownInstance getCooldown(@NonNull CooldownGroup group) {
        Instant currentTime;
        CooldownInstance cooldown = this.cooldowns.get(group);
        if (cooldown == null) {
            return null;
        }
        Instant expiration = cooldown.creationTime().plus(cooldown.duration());
        if (expiration.isAfter(currentTime = Instant.now(this.clock))) {
            return cooldown;
        }
        this.cooldowns.remove(group);
        return null;
    }

    @Override
    public synchronized void setCooldown(@NonNull CooldownGroup group, @NonNull CooldownInstance cooldown) {
        this.cooldowns.put(group, cooldown);
    }

    @Override
    public synchronized void deleteCooldown(@NonNull CooldownGroup group) {
        this.cooldowns.remove(group);
    }

    @Override
    public boolean isEmpty() {
        return this.cooldowns.isEmpty();
    }
}

