/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.cloud.processors.requirements;

import java.util.List;
import java.util.Objects;
import net.skinsrestorer.shadow.cloud.Command;
import net.skinsrestorer.shadow.cloud.key.CloudKey;
import net.skinsrestorer.shadow.cloud.processors.requirements.Requirement;
import net.skinsrestorer.shadow.cloud.processors.requirements.Requirements;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@API(status=API.Status.STABLE, since="1.0.0")
@NestMembers(value={RequirementApplicableFactory.class})
public final class RequirementApplicable<C, R extends Requirement<C, R>>
implements Command.Builder.Applicable<C> {
    private final CloudKey<Requirements<C, R>> requirementKey;
    private final Requirements<C, R> requirements;

    public static <C, R extends Requirement<C, R>> @NonNull RequirementApplicableFactory<C, R> factory(@NonNull CloudKey<Requirements<C, R>> requirementKey) {
        return new RequirementApplicableFactory<C, R>(requirementKey);
    }

    RequirementApplicable(@NonNull CloudKey<Requirements<C, R>> requirementKey, @NonNull Requirements<C, R> requirements) {
        this.requirementKey = Objects.requireNonNull(requirementKey, "requirementKey");
        this.requirements = Objects.requireNonNull(requirements, "requirements");
    }

    @Override
    public @NonNull Command.Builder<C> applyToCommandBuilder(@NonNull Command.Builder<C> builder) {
        return builder.meta(this.requirementKey, this.requirements);
    }

    @API(status=API.Status.STABLE, since="1.0.0")
    @NestHost(value=RequirementApplicable.class)
    public static final class RequirementApplicableFactory<C, R extends Requirement<C, R>> {
        private final CloudKey<Requirements<C, R>> requirementKey;

        RequirementApplicableFactory(@NonNull CloudKey<Requirements<C, R>> requirementKey) {
            this.requirementKey = Objects.requireNonNull(requirementKey, "requirementKey");
        }

        public @NonNull RequirementApplicable<C, R> create(@NonNull Requirements<C, R> requirements) {
            Objects.requireNonNull(requirements, "requirements");
            return new RequirementApplicable<C, R>(this.requirementKey, requirements);
        }

        public @NonNull RequirementApplicable<C, R> create(@NonNull List<@NonNull R> requirements) {
            Objects.requireNonNull(requirements, "requirements");
            return new RequirementApplicable<C, R>(this.requirementKey, Requirements.of(requirements));
        }

        @SafeVarargs
        public final @NonNull RequirementApplicable<C, R> create(R ... requirements) {
            Objects.requireNonNull(requirements, "requirements");
            return new RequirementApplicable<C, R>(this.requirementKey, Requirements.of(requirements));
        }
    }
}

