/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.client.impl;

import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransientConnectionException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import net.skinsrestorer.shadow.mariadb.Configuration;
import net.skinsrestorer.shadow.mariadb.HostAddress;
import net.skinsrestorer.shadow.mariadb.Statement;
import net.skinsrestorer.shadow.mariadb.client.Client;
import net.skinsrestorer.shadow.mariadb.client.Completion;
import net.skinsrestorer.shadow.mariadb.client.Context;
import net.skinsrestorer.shadow.mariadb.client.context.RedoContext;
import net.skinsrestorer.shadow.mariadb.client.impl.ReplayClient;
import net.skinsrestorer.shadow.mariadb.client.impl.StandardClient;
import net.skinsrestorer.shadow.mariadb.client.util.ClosableLock;
import net.skinsrestorer.shadow.mariadb.export.ExceptionFactory;
import net.skinsrestorer.shadow.mariadb.export.Prepare;
import net.skinsrestorer.shadow.mariadb.message.ClientMessage;
import net.skinsrestorer.shadow.mariadb.message.client.ChangeDbPacket;
import net.skinsrestorer.shadow.mariadb.message.client.QueryPacket;
import net.skinsrestorer.shadow.mariadb.message.client.RedoableWithPrepareClientMessage;
import net.skinsrestorer.shadow.mariadb.util.log.Logger;
import net.skinsrestorer.shadow.mariadb.util.log.Loggers;

public class MultiPrimaryClient
implements Client {
    protected static final ConcurrentMap<HostAddress, Long> denyList = new ConcurrentHashMap<HostAddress, Long>();
    private static final Logger logger = Loggers.getLogger(MultiPrimaryClient.class);
    protected final long deniedListTimeout;
    protected final Configuration conf;
    protected final ClosableLock lock;
    protected boolean closed = false;
    protected Client currentClient;

    public MultiPrimaryClient(Configuration conf, ClosableLock lock) throws SQLException {
        this.conf = conf;
        this.lock = lock;
        this.deniedListTimeout = Long.parseLong(conf.nonMappedOptions().getProperty("deniedListTimeout", "60000"));
        this.currentClient = this.connectHost(false, false);
    }

    protected Client connectHost(boolean readOnly, boolean failFast) throws SQLException {
        int maxRetries;
        block4: {
            maxRetries = this.conf.retriesAllDown();
            try {
                Client client = this.tryConnectToAvailableHost(readOnly, maxRetries);
                if (client != null) {
                    return client;
                }
            }
            catch (SQLNonTransientConnectionException | SQLTimeoutException lastException) {
                if (!failFast) break block4;
                throw lastException;
            }
        }
        if (failFast) {
            throw new SQLNonTransientConnectionException("all hosts are blacklisted");
        }
        this.validateHostConfiguration(readOnly);
        return this.tryConnectToDeniedHost(readOnly, maxRetries);
    }

    private Client tryConnectToAvailableHost(boolean readOnly, int retriesLeft) throws SQLException {
        Optional<HostAddress> host;
        SQLException lastException = null;
        while (retriesLeft > 0 && (host = this.conf.haMode().getAvailableHost(this.conf.addresses(), denyList, !readOnly)).isPresent()) {
            try {
                return this.createClient(host.get());
            }
            catch (SQLNonTransientConnectionException | SQLTimeoutException e) {
                lastException = e;
                this.addToDenyList(host.get());
                --retriesLeft;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        return null;
    }

    private Client tryConnectToDeniedHost(boolean readOnly, int retriesLeft) throws SQLException {
        SQLException lastException = null;
        while (retriesLeft > 0) {
            Optional<HostAddress> host = this.findHostWithLowestDenyTimeout(readOnly);
            if (!host.isPresent()) {
                --retriesLeft;
                continue;
            }
            try {
                Client client = this.createClient(host.get());
                denyList.remove(host.get());
                return client;
            }
            catch (SQLNonTransientConnectionException | SQLTimeoutException e) {
                lastException = e;
                host.ifPresent(this::addToDenyList);
                if (--retriesLeft <= 0) continue;
                this.sleepBeforeRetry();
            }
        }
        throw lastException != null ? lastException : new SQLNonTransientConnectionException("No host");
    }

    private Optional<HostAddress> findHostWithLowestDenyTimeout(boolean readOnly) {
        return denyList.entrySet().stream().sorted(Map.Entry.comparingByValue()).filter(e -> this.conf.addresses().contains(e.getKey()) && ((HostAddress)e.getKey()).primary != readOnly).findFirst().map(Map.Entry::getKey);
    }

    private void validateHostConfiguration(boolean readOnly) throws SQLNonTransientConnectionException {
        boolean hasValidHost = denyList.entrySet().stream().anyMatch(e -> this.conf.addresses().contains(e.getKey()) && ((HostAddress)e.getKey()).primary != readOnly);
        if (!hasValidHost) {
            throw new SQLNonTransientConnectionException(String.format("No %s host defined", readOnly ? "replica" : "primary"));
        }
    }

    private Client createClient(HostAddress host) throws SQLException {
        return this.conf.transactionReplay() ? new ReplayClient(this.conf, host, this.lock, false) : new StandardClient(this.conf, host, this.lock, false);
    }

    private void addToDenyList(HostAddress host) {
        denyList.putIfAbsent(host, System.currentTimeMillis() + this.deniedListTimeout);
    }

    private void sleepBeforeRetry() {
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    protected Client reConnect() throws SQLException {
        denyList.putIfAbsent(this.currentClient.getHostAddress(), System.currentTimeMillis() + this.deniedListTimeout);
        logger.info("Connection error on {}", this.currentClient.getHostAddress());
        try {
            Client oldClient = this.currentClient;
            oldClient.getContext().resetPrepareCache();
            this.currentClient = this.connectHost(false, false);
            this.syncNewState(oldClient);
            return oldClient;
        }
        catch (SQLNonTransientConnectionException sqle) {
            this.closed = true;
            throw sqle;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void replayIfPossible(Client oldClient, boolean canRedo) throws SQLException {
        if (oldClient == null) return;
        if ((oldClient.getContext().getServerStatus() & 1) <= 0) {
            if (canRedo) return;
            throw new SQLTransientConnectionException(String.format("Driver has reconnect connection after a communications link failure with %s", oldClient.getHostAddress()), "25S03");
        }
        if (this.conf.transactionReplay()) {
            this.executeTransactionReplay(oldClient);
            return;
        }
        oldClient.getContext().setServerStatus(oldClient.getContext().getServerStatus() & 0xFFFFFFFE);
        throw new SQLTransientConnectionException(String.format("Driver has reconnect connection after a communications link failure with %s. In progress transaction was lost", oldClient.getHostAddress()), "25S03");
    }

    protected void executeTransactionReplay(Client oldCli) throws SQLException {
        RedoContext ctx = (RedoContext)oldCli.getContext();
        if (ctx.getTransactionSaver().isDirty()) {
            ctx.getTransactionSaver().clear();
            throw new SQLTransientConnectionException(String.format("Driver has reconnect connection after a communications link failure with %s. In progress transaction was too big to be replayed, and was lost", oldCli.getHostAddress()), "25S03");
        }
        ((ReplayClient)this.currentClient).transactionReplay(ctx.getTransactionSaver());
    }

    public void syncNewState(Client oldCli) throws SQLException {
        Context oldCtx = oldCli.getContext();
        this.syncExceptionFactory(oldCli);
        this.syncAutoCommit(oldCtx);
        this.syncDatabase(oldCtx);
        this.syncNetworkTimeout(oldCtx, oldCli);
        this.syncReadOnlyState(oldCtx);
        this.syncTransactionIsolation(oldCtx);
    }

    private void syncExceptionFactory(Client oldCli) {
        this.currentClient.getExceptionFactory().setConnection(oldCli.getExceptionFactory());
    }

    private void syncAutoCommit(Context oldCtx) throws SQLException {
        if (!this.isAutoCommitSyncRequired(oldCtx)) {
            return;
        }
        this.currentClient.getContext().addStateFlag(8);
        String autoCommitValue = (oldCtx.getServerStatus() & 2) > 0 ? "1" : "0";
        this.currentClient.execute(new QueryPacket("set autocommit=" + autoCommitValue), true);
    }

    private boolean isAutoCommitSyncRequired(Context oldCtx) {
        return (oldCtx.getStateFlag() & 8) > 0 && (oldCtx.getServerStatus() & 2) != (this.currentClient.getContext().getServerStatus() & 2);
    }

    private void syncDatabase(Context oldCtx) throws SQLException {
        if (!this.isDatabaseSyncRequired(oldCtx)) {
            return;
        }
        this.currentClient.getContext().addStateFlag(2);
        if (oldCtx.getDatabase() != null) {
            this.currentClient.execute(new ChangeDbPacket(oldCtx.getDatabase()), true);
        }
        this.currentClient.getContext().setDatabase(oldCtx.getDatabase());
    }

    private boolean isDatabaseSyncRequired(Context oldCtx) {
        return (oldCtx.getStateFlag() & 2) > 0 && !Objects.equals(this.currentClient.getContext().getDatabase(), oldCtx.getDatabase());
    }

    private void syncNetworkTimeout(Context oldCtx, Client oldCli) throws SQLException {
        if ((oldCtx.getStateFlag() & 1) > 0) {
            this.currentClient.setSocketTimeout(oldCli.getSocketTimeout());
        }
    }

    private void syncReadOnlyState(Context oldCtx) throws SQLException {
        if (!this.isReadOnlySyncRequired(oldCtx)) {
            return;
        }
        this.currentClient.execute(new QueryPacket("SET SESSION TRANSACTION READ ONLY"), true);
    }

    private boolean isReadOnlySyncRequired(Context oldCtx) {
        return (oldCtx.getStateFlag() & 4) > 0 && this.currentClient.getHostAddress().primary == false && this.currentClient.getContext().getVersion().versionGreaterOrEqual(5, 6, 5);
    }

    private void syncTransactionIsolation(Context oldCtx) throws SQLException {
        if (!this.isTransactionIsolationSyncRequired(oldCtx)) {
            return;
        }
        String query = this.buildTransactionIsolationQuery(oldCtx.getTransactionIsolationLevel());
        this.currentClient.getContext().setTransactionIsolationLevel(oldCtx.getTransactionIsolationLevel());
        this.currentClient.execute(new QueryPacket(query), true);
    }

    private boolean isTransactionIsolationSyncRequired(Context oldCtx) {
        return (oldCtx.getStateFlag() & 0x10) > 0 && !oldCtx.getTransactionIsolationLevel().equals(this.currentClient.getContext().getTransactionIsolationLevel());
    }

    private String buildTransactionIsolationQuery(int isolationLevel) {
        String baseQuery = "SET SESSION TRANSACTION ISOLATION LEVEL";
        switch (isolationLevel) {
            case 1: {
                return baseQuery + " READ UNCOMMITTED";
            }
            case 2: {
                return baseQuery + " READ COMMITTED";
            }
            case 4: {
                return baseQuery + " REPEATABLE READ";
            }
            case 8: {
                return baseQuery + " SERIALIZABLE";
            }
        }
        throw new IllegalArgumentException("Unsupported isolation level: " + isolationLevel);
    }

    @Override
    public List<Completion> execute(ClientMessage message, boolean canRedo) throws SQLException {
        return this.execute(message, null, 0, 0L, 1007, 1003, false, canRedo);
    }

    @Override
    public List<Completion> execute(ClientMessage message, Statement stmt, boolean canRedo) throws SQLException {
        return this.execute(message, stmt, 0, 0L, 1007, 1003, false, canRedo);
    }

    @Override
    public List<Completion> execute(ClientMessage message, Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion, boolean canRedo) throws SQLException {
        if (this.closed) {
            throw new SQLNonTransientConnectionException("Connection is closed", "08000", 1220);
        }
        try {
            return this.currentClient.execute(message, stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, canRedo);
        }
        catch (SQLNonTransientConnectionException e) {
            HostAddress hostAddress = this.currentClient.getHostAddress();
            Client oldClient = this.reConnect();
            if (message instanceof QueryPacket && ((QueryPacket)message).isCommit()) {
                throw new SQLTransientConnectionException(String.format("Driver has reconnect connection after a communications failure with %s during a COMMIT statement", hostAddress), "25S03");
            }
            this.replayIfPossible(oldClient, canRedo);
            if (message instanceof RedoableWithPrepareClientMessage) {
                ((RedoableWithPrepareClientMessage)message).rePrepare(this.currentClient);
            }
            return this.currentClient.execute(message, stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, canRedo);
        }
    }

    @Override
    public List<Completion> executePipeline(ClientMessage[] messages, Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion, boolean canRedo) throws SQLException {
        if (this.closed) {
            throw new SQLNonTransientConnectionException("Connection is closed", "08000", 1220);
        }
        try {
            return this.currentClient.executePipeline(messages, stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, canRedo);
        }
        catch (SQLException e) {
            if (e instanceof SQLNonTransientConnectionException || e.getCause() != null && e.getCause() instanceof SQLNonTransientConnectionException) {
                Client oldClient = this.reConnect();
                this.replayIfPossible(oldClient, canRedo);
                Arrays.stream(messages).filter(RedoableWithPrepareClientMessage.class::isInstance).map(RedoableWithPrepareClientMessage.class::cast).forEach(rd -> {
                    try {
                        rd.rePrepare(this.currentClient);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                });
                return this.currentClient.executePipeline(messages, stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, canRedo);
            }
            throw e;
        }
    }

    @Override
    public void readStreamingResults(List<Completion> completions, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion) throws SQLException {
        if (this.closed) {
            throw new SQLNonTransientConnectionException("Connection is closed", "08000", 1220);
        }
        try {
            this.currentClient.readStreamingResults(completions, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion);
        }
        catch (SQLNonTransientConnectionException e) {
            try {
                this.reConnect();
            }
            catch (SQLException e2) {
                throw this.getExceptionFactory().create("Socket error during result streaming", e2.getSQLState(), e2);
            }
            throw this.getExceptionFactory().create("Socket error during result streaming", "HY000", e);
        }
    }

    @Override
    public void closePrepare(Prepare prepare) throws SQLException {
        if (this.closed) {
            throw new SQLNonTransientConnectionException("Connection is closed", "08000", 1220);
        }
        try {
            this.currentClient.closePrepare(prepare);
        }
        catch (SQLNonTransientConnectionException e) {
            this.reConnect();
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (this.closed) {
            throw new SQLNonTransientConnectionException("Connection is closed", "08000", 1220);
        }
        this.currentClient.abort(executor);
    }

    @Override
    public void close() throws SQLException {
        if (!this.closed) {
            this.closed = true;
            this.currentClient.close();
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.closed) {
            throw new SQLNonTransientConnectionException("Connection is closed", "08000", 1220);
        }
    }

    @Override
    public int getSocketTimeout() {
        return this.currentClient.getSocketTimeout();
    }

    @Override
    public void setSocketTimeout(int milliseconds) throws SQLException {
        if (this.closed) {
            throw new SQLNonTransientConnectionException("Connection is closed", "08000", 1220);
        }
        try {
            this.currentClient.setSocketTimeout(milliseconds);
        }
        catch (SQLNonTransientConnectionException e) {
            this.reConnect();
            this.currentClient.setSocketTimeout(milliseconds);
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public Context getContext() {
        return this.currentClient.getContext();
    }

    @Override
    public ExceptionFactory getExceptionFactory() {
        return this.currentClient.getExceptionFactory();
    }

    @Override
    public HostAddress getHostAddress() {
        return this.currentClient.getHostAddress();
    }

    @Override
    public String getSocketIp() {
        return this.currentClient.getSocketIp();
    }

    @Override
    public boolean isPrimary() {
        return true;
    }

    @Override
    public void reset() {
        this.currentClient.getContext().resetStateFlag();
        this.currentClient.getContext().resetPrepareCache();
    }
}

