/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.client.impl;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import net.skinsrestorer.shadow.mariadb.Configuration;
import net.skinsrestorer.shadow.mariadb.HostAddress;
import net.skinsrestorer.shadow.mariadb.Statement;
import net.skinsrestorer.shadow.mariadb.client.Completion;
import net.skinsrestorer.shadow.mariadb.client.context.RedoContext;
import net.skinsrestorer.shadow.mariadb.client.impl.StandardClient;
import net.skinsrestorer.shadow.mariadb.client.impl.TransactionSaver;
import net.skinsrestorer.shadow.mariadb.client.util.ClosableLock;
import net.skinsrestorer.shadow.mariadb.export.MaxAllowedPacketException;
import net.skinsrestorer.shadow.mariadb.export.Prepare;
import net.skinsrestorer.shadow.mariadb.message.ClientMessage;
import net.skinsrestorer.shadow.mariadb.message.client.PreparePacket;
import net.skinsrestorer.shadow.mariadb.message.client.RedoableClientMessage;
import net.skinsrestorer.shadow.mariadb.message.client.RedoableWithPrepareClientMessage;
import net.skinsrestorer.shadow.mariadb.message.server.PrepareResultPacket;
import net.skinsrestorer.shadow.mariadb.util.log.Logger;
import net.skinsrestorer.shadow.mariadb.util.log.Loggers;

public class ReplayClient
extends StandardClient {
    private static final Logger logger = Loggers.getLogger(ReplayClient.class);

    public ReplayClient(Configuration conf, HostAddress hostAddress, ClosableLock lock, boolean skipPostCommands) throws SQLException {
        super(conf, hostAddress, lock, skipPostCommands);
    }

    @Override
    public int sendQuery(ClientMessage message) throws SQLException {
        this.checkNotClosed();
        try {
            if (message instanceof RedoableClientMessage) {
                ((RedoableClientMessage)message).ensureReplayable(this.context);
            }
            return message.encode(this.writer, this.context);
        }
        catch (MaxAllowedPacketException maxE) {
            if (maxE.isMustReconnect()) {
                this.destroySocket();
                throw this.exceptionFactory.withSql(message.description()).create("Packet too big for current server max_allowed_packet value", "08000", maxE);
            }
            throw this.exceptionFactory.withSql(message.description()).create("Packet too big for current server max_allowed_packet value", "HZ000", maxE);
        }
        catch (IOException ioException) {
            this.destroySocket();
            throw this.exceptionFactory.withSql(message.description()).create("Socket error", "08000", ioException);
        }
    }

    @Override
    public List<Completion> executePipeline(ClientMessage[] messages, Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion, boolean canRedo) throws SQLException {
        List<Completion> res = super.executePipeline(messages, stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, canRedo);
        ((RedoContext)this.context).saveRedo(messages);
        return res;
    }

    @Override
    public List<Completion> execute(ClientMessage message, Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion, boolean canRedo) throws SQLException {
        List<Completion> completions = super.execute(message, stmt, fetchSize, maxRows, resultSetConcurrency, resultSetType, closeOnCompletion, canRedo);
        ((RedoContext)this.context).saveRedo(message);
        return completions;
    }

    public void transactionReplay(TransactionSaver transactionSaver) throws SQLException {
        RedoableClientMessage[] buffers = transactionSaver.getBuffers();
        try {
            for (int i = 0; i < transactionSaver.getIdx(); ++i) {
                int responseNo;
                RedoableClientMessage querySaver = buffers[i];
                if (querySaver instanceof RedoableWithPrepareClientMessage) {
                    RedoableWithPrepareClientMessage redoable = (RedoableWithPrepareClientMessage)querySaver;
                    String cmd = redoable.getCommand();
                    Prepare prepare = this.context.getPrepareCacheCmd(cmd, redoable.prep());
                    if (prepare == null) {
                        PreparePacket preparePacket = new PreparePacket(cmd);
                        this.sendQuery(preparePacket);
                        prepare = (PrepareResultPacket)this.readPacket(preparePacket);
                        logger.info("replayed command after failover: " + preparePacket.description());
                    }
                    responseNo = querySaver.reEncode(this.writer, this.context, prepare);
                } else {
                    responseNo = querySaver.reEncode(this.writer, this.context, null);
                }
                logger.info("replayed command after failover: " + querySaver.description());
                for (int j = 0; j < responseNo; ++j) {
                    this.readResponse(querySaver);
                }
            }
        }
        catch (IOException e) {
            throw this.context.getExceptionFactory().create("Socket error during transaction replay", "08000", e);
        }
    }
}

