/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.mariadb.plugin.codec;

import java.io.IOException;
import java.sql.SQLDataException;
import java.util.Calendar;
import net.skinsrestorer.shadow.mariadb.client.ColumnDecoder;
import net.skinsrestorer.shadow.mariadb.client.Context;
import net.skinsrestorer.shadow.mariadb.client.DataType;
import net.skinsrestorer.shadow.mariadb.client.ReadableByteBuf;
import net.skinsrestorer.shadow.mariadb.client.socket.Writer;
import net.skinsrestorer.shadow.mariadb.client.util.MutableInt;
import net.skinsrestorer.shadow.mariadb.plugin.Codec;
import net.skinsrestorer.shadow.mariadb.type.Geometry;
import net.skinsrestorer.shadow.mariadb.type.Point;

public class PointCodec
implements Codec<Point> {
    public static final PointCodec INSTANCE = new PointCodec();

    @Override
    public String className() {
        return Point.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return column.getType() == DataType.GEOMETRY && type.isAssignableFrom(Point.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Point;
    }

    @Override
    public Point decodeText(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal, Context context) throws SQLDataException {
        return this.decodeBinary(buf, length, column, cal, context);
    }

    @Override
    public Point decodeBinary(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal, Context context) throws SQLDataException {
        if (column.getType() == DataType.GEOMETRY) {
            buf.skip(4);
            Geometry geo = Geometry.getGeometry(buf, length.get() - 4, column);
            if (geo instanceof Point) {
                return (Point)geo;
            }
            throw new SQLDataException(String.format("Geometric type %s cannot be decoded as Point", geo.getClass().getName()));
        }
        buf.skip(length.get());
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Point", new Object[]{column.getType()}));
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeBytes(("ST_PointFromText('" + value.toString() + "')").getBytes());
    }

    @Override
    public int getApproximateTextProtocolLength(Object value, Long length) {
        return -1;
    }

    @Override
    public void encodeBinary(Writer encoder, Context context, Object value, Calendar cal, Long maxLength) throws IOException {
        Point pt = (Point)value;
        encoder.writeLength(25L);
        encoder.writeInt(0);
        encoder.writeByte(1);
        encoder.writeInt(1);
        encoder.writeDouble(pt.getX());
        encoder.writeDouble(pt.getY());
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.BLOB.get();
    }
}

