/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.reflect;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import net.skinsrestorer.shadow.javax.annotation.Nullable;
import net.skinsrestorer.shadow.reflect.JVMConstants;
import net.skinsrestorer.shadow.reflect.JavaBypass;
import net.skinsrestorer.shadow.reflect.Methods;
import net.skinsrestorer.shadow.reflect.exceptions.ConstructorInvocationException;
import net.skinsrestorer.shadow.reflect.exceptions.MethodNotFoundException;
import net.skinsrestorer.shadow.reflect.utils.FieldInitializer;

public class Constructors {
    private static final MethodHandle getDeclaredConstructors0 = FieldInitializer.reqInit(() -> {
        if (JVMConstants.OPENJ9_RUNTIME) {
            return Methods.getDeclaredMethod(Class.class, JVMConstants.METHOD_Class_getDeclaredConstructors0, new Class[0]);
        }
        return Methods.getDeclaredMethod(Class.class, JVMConstants.METHOD_Class_getDeclaredConstructors0, Boolean.TYPE);
    }, JavaBypass.TRUSTED_LOOKUP::unreflect, () -> new MethodNotFoundException(Class.class.getName(), JVMConstants.METHOD_Class_getDeclaredConstructors0, JVMConstants.OPENJ9_RUNTIME ? "" : "boolean"));

    public static <T> Constructor<T>[] getDeclaredConstructors(Class<T> clazz) {
        if (JVMConstants.OPENJ9_RUNTIME) {
            return getDeclaredConstructors0.invokeExact(clazz);
        }
        return getDeclaredConstructors0.invokeExact(clazz, false);
    }

    @Nullable
    public static <T> Constructor<T> getDeclaredConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        for (Constructor<T> constructor : Constructors.getDeclaredConstructors(clazz)) {
            if (!Arrays.equals(constructor.getParameterTypes(), parameterTypes)) continue;
            return constructor;
        }
        return null;
    }

    public static <T> T invoke(Constructor<T> constructor, Object ... args) {
        try {
            return (T)JavaBypass.TRUSTED_LOOKUP.unreflectConstructor(constructor).asSpreader(Object[].class, args.length).invoke(args);
        }
        catch (Throwable t) {
            throw new ConstructorInvocationException(constructor).cause(t);
        }
    }
}

