/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.reflect.bytecode;

import java.lang.reflect.Method;
import net.skinsrestorer.shadow.jbannotations.ApiStatus;

@ApiStatus.Experimental
public class BytecodeUtils {
    public static String slash(String className) {
        return className.replace('.', '/');
    }

    public static String slash(Class<?> clazz) {
        return BytecodeUtils.slash(clazz.getName());
    }

    public static String dot(String className) {
        return className.replace('/', '.');
    }

    public static String desc(String className) {
        return "L" + BytecodeUtils.slash(className) + ";";
    }

    public static String desc(Class<?> clazz) {
        if (Void.TYPE.equals(clazz)) {
            return "V";
        }
        if (Boolean.TYPE.equals(clazz)) {
            return "Z";
        }
        if (Byte.TYPE.equals(clazz)) {
            return "B";
        }
        if (Short.TYPE.equals(clazz)) {
            return "S";
        }
        if (Character.TYPE.equals(clazz)) {
            return "C";
        }
        if (Integer.TYPE.equals(clazz)) {
            return "I";
        }
        if (Long.TYPE.equals(clazz)) {
            return "J";
        }
        if (Float.TYPE.equals(clazz)) {
            return "F";
        }
        if (Double.TYPE.equals(clazz)) {
            return "D";
        }
        if (clazz.isArray()) {
            return "[" + BytecodeUtils.desc(clazz.getComponentType());
        }
        return BytecodeUtils.desc(clazz.getName());
    }

    public static String desc(Method method) {
        return BytecodeUtils.mdesc(method.getReturnType(), method.getParameterTypes());
    }

    public static String mdesc(Class<?> returnType, Class<?> ... parameterTypes) {
        StringBuilder builder = new StringBuilder("(");
        for (Class<?> parameterType : parameterTypes) {
            builder.append(BytecodeUtils.desc(parameterType));
        }
        builder.append(")").append(BytecodeUtils.desc(returnType));
        return builder.toString();
    }

    public static String getLoadOpcode(Class<?> clazz) {
        if (Boolean.TYPE.equals(clazz) || Byte.TYPE.equals(clazz) || Character.TYPE.equals(clazz) || Short.TYPE.equals(clazz) || Integer.TYPE.equals(clazz)) {
            return "ILOAD";
        }
        if (Long.TYPE.equals(clazz)) {
            return "LLOAD";
        }
        if (Float.TYPE.equals(clazz)) {
            return "FLOAD";
        }
        if (Double.TYPE.equals(clazz)) {
            return "DLOAD";
        }
        return "ALOAD";
    }

    public static String getReturnOpcode(Class<?> clazz) {
        if (Void.TYPE.equals(clazz)) {
            return "RETURN";
        }
        if (Boolean.TYPE.equals(clazz) || Byte.TYPE.equals(clazz) || Character.TYPE.equals(clazz) || Short.TYPE.equals(clazz) || Integer.TYPE.equals(clazz)) {
            return "IRETURN";
        }
        if (Long.TYPE.equals(clazz)) {
            return "LRETURN";
        }
        if (Float.TYPE.equals(clazz)) {
            return "FRETURN";
        }
        if (Double.TYPE.equals(clazz)) {
            return "DRETURN";
        }
        return "ARETURN";
    }

    public static int getStackSize(Class<?> clazz) {
        if (Long.TYPE.equals(clazz) || Double.TYPE.equals(clazz)) {
            return 2;
        }
        return 1;
    }

    public static Class<?> boxed(Class<?> clazz) {
        if (clazz == Void.TYPE) {
            return Void.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        return clazz;
    }

    public static Class<?> unboxed(Class<?> clazz) {
        if (clazz == Void.class) {
            return Void.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        return clazz;
    }
}

