/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.reflect.proxy.internal;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import net.skinsrestorer.shadow.jbannotations.ApiStatus;
import net.skinsrestorer.shadow.jbannotations.Nullable;
import net.skinsrestorer.shadow.reflect.bytecode.BytecodeUtils;
import net.skinsrestorer.shadow.reflect.bytecode.builder.BytecodeBuilder;
import net.skinsrestorer.shadow.reflect.bytecode.builder.ClassBuilder;
import net.skinsrestorer.shadow.reflect.bytecode.wrapper.BuiltClass;
import net.skinsrestorer.shadow.reflect.bytecode.wrapper.BytecodeLabel;
import net.skinsrestorer.shadow.reflect.proxy.impl.ProxyMethod;
import net.skinsrestorer.shadow.reflect.proxy.impl.ProxyRuntime;

@ApiStatus.Internal
public class ProxyMethodBuilder {
    private static final BytecodeBuilder BUILDER = BytecodeBuilder.get();

    public static Class<ProxyMethod> buildProxyMethodClass(Class<?> proxyClass, Method method, @Nullable Method originalMethod) {
        BuiltClass builtClass = BUILDER.class_(BUILDER.opcode("ACC_PUBLIC"), BytecodeUtils.slash(proxyClass) + "$ProxyMethodImpl", null, BytecodeUtils.slash(Object.class), new String[]{BytecodeUtils.slash(ProxyMethod.class)}, cb -> {
            ProxyMethodBuilder.addFields(proxyClass, cb);
            ProxyMethodBuilder.addStaticBlock(method, originalMethod, cb);
            ProxyMethodBuilder.addConstructor(proxyClass, cb);
            ProxyMethodBuilder.addMethodGetter(cb);
            ProxyMethodBuilder.addInvokeWith(method, cb);
            ProxyMethodBuilder.addInvokeSuper(proxyClass, originalMethod == null ? method : originalMethod, cb);
            ProxyMethodBuilder.addCancel(method, cb);
        });
        return builtClass.defineAnonymous(proxyClass);
    }

    private static void addFields(Class<?> proxyClass, ClassBuilder cb) {
        cb.field(BUILDER.opcode("ACC_PRIVATE", "ACC_STATIC", "ACC_FINAL"), "INVOKE_OTHER", BytecodeUtils.desc(MethodHandle.class), null, null);
        cb.field(BUILDER.opcode("ACC_PRIVATE", "ACC_STATIC", "ACC_FINAL"), "INVOKE_SUPER", BytecodeUtils.desc(MethodHandle.class), null, null);
        cb.field(BUILDER.opcode("ACC_PRIVATE", "ACC_FINAL"), "instance", BytecodeUtils.desc(proxyClass), null, null);
        cb.field(BUILDER.opcode("ACC_PRIVATE", "ACC_FINAL"), "method", BytecodeUtils.desc(Method.class), null, null);
    }

    private static void addStaticBlock(Method method, @Nullable Method originalMethod, ClassBuilder cb) {
        cb.method(BUILDER.opcode("ACC_PUBLIC", "ACC_STATIC"), "<clinit>", BytecodeUtils.mdesc(Void.TYPE, new Class[0]), null, null, mb -> {
            mb.typeLdc(BUILDER, method.getDeclaringClass());
            if (originalMethod != null) {
                mb.typeLdc(BUILDER, originalMethod.getDeclaringClass());
            } else {
                mb.insn(BUILDER.opcode("DUP"));
            }
            mb.ldc(method.getName()).intPush(BUILDER, method.getParameterCount()).type(BUILDER.opcode("ANEWARRAY"), BytecodeUtils.slash(Class.class));
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                Class<?> parameter = method.getParameterTypes()[i];
                mb.insn(BUILDER.opcode("DUP")).intPush(BUILDER, i).typeLdc(BUILDER, parameter).insn(BUILDER.opcode("AASTORE"));
            }
            mb.typeLdc(BUILDER, method.getReturnType()).method(BUILDER.opcode("INVOKESTATIC"), BytecodeUtils.slash(ProxyRuntime.class), "getMethodHandles", BytecodeUtils.mdesc(MethodHandle[].class, Class.class, Class.class, String.class, Class[].class, Class.class), false);
            mb.insn(BUILDER.opcode("DUP")).intPush(BUILDER, 0).insn(BUILDER.opcode("AALOAD")).field(BUILDER.opcode("PUTSTATIC"), cb.getName(), "INVOKE_OTHER", BytecodeUtils.desc(MethodHandle.class)).intPush(BUILDER, 1).insn(BUILDER.opcode("AALOAD")).field(BUILDER.opcode("PUTSTATIC"), cb.getName(), "INVOKE_SUPER", BytecodeUtils.desc(MethodHandle.class));
            mb.insn(BUILDER.opcode("RETURN")).maxs(6, 0);
        });
    }

    private static void addConstructor(Class<?> proxyClass, ClassBuilder cb) {
        cb.method(BUILDER.opcode("ACC_PUBLIC"), "<init>", BytecodeUtils.mdesc(Void.TYPE, proxyClass, Method.class), null, null, mb -> mb.var(BUILDER.opcode("ALOAD"), 0).method(BUILDER.opcode("INVOKESPECIAL"), BytecodeUtils.slash(Object.class), "<init>", BytecodeUtils.mdesc(Void.TYPE, new Class[0]), false).var(BUILDER.opcode("ALOAD"), 0).var(BUILDER.opcode("ALOAD"), 1).field(BUILDER.opcode("PUTFIELD"), cb.getName(), "instance", BytecodeUtils.desc(proxyClass)).var(BUILDER.opcode("ALOAD"), 0).var(BUILDER.opcode("ALOAD"), 2).field(BUILDER.opcode("PUTFIELD"), cb.getName(), "method", BytecodeUtils.desc(Method.class)).insn(BUILDER.opcode("RETURN")).maxs(3, 3));
    }

    private static void addMethodGetter(ClassBuilder cb) {
        cb.method(BUILDER.opcode("ACC_PUBLIC"), "getInvokedMethod", BytecodeUtils.mdesc(Method.class, new Class[0]), null, null, mb -> mb.var(BUILDER.opcode("ALOAD"), 0).field(BUILDER.opcode("GETFIELD"), cb.getName(), "method", BytecodeUtils.desc(Method.class)).insn(BUILDER.opcode("ARETURN")).maxs(2, 1));
    }

    private static void addInvokeWith(Method method, ClassBuilder cb) {
        cb.method(BUILDER.opcode("ACC_PUBLIC"), "invokeWith", BytecodeUtils.mdesc(Object.class, Object.class, Object[].class), null, null, mb -> {
            String polymorphicSignature = "(" + BytecodeUtils.desc(method.getDeclaringClass());
            for (Class<?> parameter : method.getParameterTypes()) {
                polymorphicSignature = polymorphicSignature + BytecodeUtils.desc(parameter);
            }
            polymorphicSignature = polymorphicSignature + ")" + BytecodeUtils.desc(method.getReturnType());
            mb.field(BUILDER.opcode("GETSTATIC"), cb.getName(), "INVOKE_OTHER", BytecodeUtils.desc(MethodHandle.class));
            mb.var(BUILDER.opcode("ALOAD"), 1).type(BUILDER.opcode("CHECKCAST"), BytecodeUtils.slash(method.getDeclaringClass()));
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                Class<?> parameter = method.getParameterTypes()[i];
                mb.var(BUILDER.opcode("ALOAD"), 2).intPush(BUILDER, i).insn(BUILDER.opcode("AALOAD")).type(BUILDER.opcode("CHECKCAST"), BytecodeUtils.slash(BytecodeUtils.boxed(parameter))).unbox(BUILDER, parameter);
            }
            mb.method(BUILDER.opcode("INVOKEVIRTUAL"), BytecodeUtils.slash(MethodHandle.class), "invokeExact", polymorphicSignature, false);
            if (method.getReturnType().equals(Void.TYPE)) {
                mb.insn(BUILDER.opcode("ACONST_NULL"));
            } else {
                mb.box(BUILDER, method.getReturnType());
            }
            mb.insn(BUILDER.opcode("ARETURN")).maxs(method.getParameterCount() + 2, method.getParameterCount() + 1);
        });
    }

    private static void addInvokeSuper(Class<?> proxyClass, Method method, ClassBuilder cb) {
        cb.method(BUILDER.opcode("ACC_PUBLIC"), "invokeSuper", BytecodeUtils.mdesc(Object.class, Object[].class), null, null, mb -> {
            String polymorphicSignature = "(" + BytecodeUtils.desc(method.getDeclaringClass());
            for (Class<?> parameter : method.getParameterTypes()) {
                polymorphicSignature = polymorphicSignature + BytecodeUtils.desc(parameter);
            }
            polymorphicSignature = polymorphicSignature + ")" + BytecodeUtils.desc(method.getReturnType());
            BytecodeLabel elseLabel = BUILDER.label();
            mb.var(BUILDER.opcode("ALOAD"), 0).field(BUILDER.opcode("GETSTATIC"), cb.getName(), "INVOKE_SUPER", BytecodeUtils.desc(MethodHandle.class)).jump(BUILDER.opcode("IFNONNULL"), elseLabel).type(BUILDER.opcode("NEW"), BytecodeUtils.slash(AbstractMethodError.class)).insn(BUILDER.opcode("DUP")).ldc(BytecodeUtils.slash(method.getDeclaringClass()) + "." + method.getName() + BytecodeUtils.desc(method)).method(BUILDER.opcode("INVOKESPECIAL"), BytecodeUtils.slash(AbstractMethodError.class), "<init>", BytecodeUtils.mdesc(Void.TYPE, String.class), false).insn(BUILDER.opcode("ATHROW")).label(elseLabel);
            mb.field(BUILDER.opcode("GETSTATIC"), cb.getName(), "INVOKE_SUPER", BytecodeUtils.desc(MethodHandle.class));
            mb.var(BUILDER.opcode("ALOAD"), 0).field(BUILDER.opcode("GETFIELD"), cb.getName(), "instance", BytecodeUtils.desc(proxyClass)).type(BUILDER.opcode("CHECKCAST"), BytecodeUtils.slash(method.getDeclaringClass()));
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                Class<?> parameter = method.getParameterTypes()[i];
                mb.var(BUILDER.opcode("ALOAD"), 1).intPush(BUILDER, i).insn(BUILDER.opcode("AALOAD")).type(BUILDER.opcode("CHECKCAST"), BytecodeUtils.slash(BytecodeUtils.boxed(parameter))).unbox(BUILDER, parameter);
            }
            mb.method(BUILDER.opcode("INVOKEVIRTUAL"), BytecodeUtils.slash(MethodHandle.class), "invokeExact", polymorphicSignature, false);
            if (method.getReturnType().equals(Void.TYPE)) {
                mb.insn(BUILDER.opcode("ACONST_NULL"));
            } else {
                mb.box(BUILDER, method.getReturnType());
            }
            mb.insn(BUILDER.opcode("ARETURN")).maxs(method.getParameterCount() + 2, method.getParameterCount() + 1);
        });
    }

    private static void addCancel(Method method, ClassBuilder cb) {
        cb.method(BUILDER.opcode("ACC_PUBLIC"), "cancel", BytecodeUtils.mdesc(Object.class, new Class[0]), null, null, mb -> {
            if (method.getReturnType() == Void.TYPE) {
                mb.insn(BUILDER.opcode("ACONST_NULL"));
            } else if (method.getReturnType() == Boolean.TYPE) {
                mb.field(BUILDER.opcode("GETSTATIC"), BytecodeUtils.slash(Boolean.class), "FALSE", BytecodeUtils.desc(Boolean.class));
            } else if (method.getReturnType() == Byte.TYPE || method.getReturnType() == Short.TYPE || method.getReturnType() == Character.TYPE || method.getReturnType() == Integer.TYPE) {
                mb.intPush(BUILDER, 0).box(BUILDER, method.getReturnType());
            } else if (method.getReturnType() == Long.TYPE) {
                mb.ldc(0L).box(BUILDER, method.getReturnType());
            } else if (method.getReturnType() == Float.TYPE) {
                mb.ldc(Float.valueOf(0.0f)).box(BUILDER, method.getReturnType());
            } else if (method.getReturnType() == Double.TYPE) {
                mb.ldc(0.0).box(BUILDER, method.getReturnType());
            } else {
                mb.insn(BUILDER.opcode("ACONST_NULL"));
            }
            mb.insn(BUILDER.opcode("ARETURN")).maxs(1, 1);
        });
    }
}

