/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.api;

import java.util.Optional;
import lombok.Generated;
import net.skinsrestorer.api.PropertyUtils;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.api.property.SkinApplier;
import net.skinsrestorer.api.property.SkinIdentifier;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.api.storage.PlayerStorage;
import net.skinsrestorer.api.storage.SkinStorage;
import net.skinsrestorer.shared.api.SkinApplierAccess;
import net.skinsrestorer.shared.commands.SoundProvider;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.subjects.SRSubjectWrapper;

public class SharedSkinApplier<P>
implements SkinApplier<P> {
    private final Class<P> playerClass;
    private final SkinApplierAccess<P> access;
    private final SRSubjectWrapper<?, P, ?> wrapper;
    private final PlayerStorage playerStorage;
    private final SkinStorage skinStorage;
    private final SoundProvider soundProvider;

    public boolean accepts(Class<?> playerClass) {
        return this.playerClass.isAssignableFrom(playerClass);
    }

    @Override
    public void applySkin(P player) throws DataRequestException {
        Object srPlayer = this.wrapper.player(player);
        Optional<SkinProperty> playerSkin = this.playerStorage.getSkinForPlayer(srPlayer.getUniqueId(), srPlayer.getName());
        this.applySkin(player, playerSkin.orElse(PropertyUtils.EMPTY_SKIN));
    }

    @Override
    public void applySkin(P player, SkinIdentifier identifier) {
        this.skinStorage.getSkinDataByIdentifier(identifier).ifPresent(property -> this.applySkin(player, (SkinProperty)property));
    }

    @Override
    public void applySkin(P player, SkinProperty property) {
        this.access.applySkin(player, property);
        Object srPlayer = this.wrapper.player(player);
        this.soundProvider.playSound((SRPlayer)srPlayer);
    }

    @Generated
    public SharedSkinApplier(Class<P> playerClass, SkinApplierAccess<P> access, SRSubjectWrapper<?, P, ?> wrapper, PlayerStorage playerStorage, SkinStorage skinStorage, SoundProvider soundProvider) {
        this.playerClass = playerClass;
        this.access = access;
        this.wrapper = wrapper;
        this.playerStorage = playerStorage;
        this.skinStorage = skinStorage;
        this.soundProvider = soundProvider;
    }
}

