/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.codec;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import net.skinsrestorer.shared.codec.BuiltInCodecs;
import net.skinsrestorer.shared.codec.NetworkId;
import net.skinsrestorer.shared.codec.SRInputReader;
import net.skinsrestorer.shared.codec.SROutputWriter;
import net.skinsrestorer.shared.utils.SRFunction;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@RecordComponents(value={@RecordComponents.Value(name="writer", type=Writer.class), @RecordComponents.Value(name="reader", type=Reader.class)})
@NestMembers(value={Reader.class, Writer.class})
public final class NetworkCodec<T>
extends J_L_Record {
    private final Writer<T> writer;
    private final Reader<T> reader;

    public NetworkCodec(Writer<T> writer, Reader<T> reader) {
        this.writer = writer;
        this.reader = reader;
    }

    public static <T> NetworkCodec<T> of(Writer<T> writer, Reader<T> reader) {
        return new NetworkCodec<T>(writer, reader);
    }

    public static <T, F1> NetworkCodec<T> list(NetworkCodec<F1> f1Codec, Function<T, F1> f1Getter, SRFunction.Function1<F1, T> constructor) {
        return NetworkCodec.of((out, t) -> f1Codec.write(out, f1Getter.apply(t)), in -> constructor.apply(f1Codec.read(in)));
    }

    public static <T, F1, F2> NetworkCodec<T> list(NetworkCodec<F1> f1Codec, Function<T, F1> f1Getter, NetworkCodec<F2> f2Codec, Function<T, F2> f2Getter, SRFunction.Function2<F1, F2, T> constructor) {
        return NetworkCodec.of((out, t) -> {
            f1Codec.write(out, f1Getter.apply(t));
            f2Codec.write(out, f2Getter.apply(t));
        }, in -> constructor.apply(f1Codec.read(in), f2Codec.read(in)));
    }

    public static <T, F1, F2, F3> NetworkCodec<T> list(NetworkCodec<F1> f1Codec, Function<T, F1> f1Getter, NetworkCodec<F2> f2Codec, Function<T, F2> f2Getter, NetworkCodec<F3> f3Codec, Function<T, F3> f3Getter, SRFunction.Function3<F1, F2, F3, T> constructor) {
        return NetworkCodec.of((out, t) -> {
            f1Codec.write(out, f1Getter.apply(t));
            f2Codec.write(out, f2Getter.apply(t));
            f3Codec.write(out, f3Getter.apply(t));
        }, in -> constructor.apply(f1Codec.read(in), f2Codec.read(in), f3Codec.read(in)));
    }

    public static <T, F1, F2, F3, F4> NetworkCodec<T> list(NetworkCodec<F1> f1Codec, Function<T, F1> f1Getter, NetworkCodec<F2> f2Codec, Function<T, F2> f2Getter, NetworkCodec<F3> f3Codec, Function<T, F3> f3Getter, NetworkCodec<F4> f4Codec, Function<T, F4> f4Getter, SRFunction.Function4<F1, F2, F3, F4, T> constructor) {
        return NetworkCodec.of((out, t) -> {
            f1Codec.write(out, f1Getter.apply(t));
            f2Codec.write(out, f2Getter.apply(t));
            f3Codec.write(out, f3Getter.apply(t));
            f4Codec.write(out, f4Getter.apply(t));
        }, in -> constructor.apply(f1Codec.read(in), f2Codec.read(in), f3Codec.read(in), f4Codec.read(in)));
    }

    public static <T, F1, F2, F3, F4, F5> NetworkCodec<T> list(NetworkCodec<F1> f1Codec, Function<T, F1> f1Getter, NetworkCodec<F2> f2Codec, Function<T, F2> f2Getter, NetworkCodec<F3> f3Codec, Function<T, F3> f3Getter, NetworkCodec<F4> f4Codec, Function<T, F4> f4Getter, NetworkCodec<F5> f5Codec, Function<T, F5> f5Getter, SRFunction.Function5<F1, F2, F3, F4, F5, T> constructor) {
        return NetworkCodec.of((out, t) -> {
            f1Codec.write(out, f1Getter.apply(t));
            f2Codec.write(out, f2Getter.apply(t));
            f3Codec.write(out, f3Getter.apply(t));
            f4Codec.write(out, f4Getter.apply(t));
            f5Codec.write(out, f5Getter.apply(t));
        }, in -> constructor.apply(f1Codec.read(in), f2Codec.read(in), f3Codec.read(in), f4Codec.read(in), f5Codec.read(in)));
    }

    public static <T, F1, F2, F3, F4, F5, F6> NetworkCodec<T> list(NetworkCodec<F1> f1Codec, Function<T, F1> f1Getter, NetworkCodec<F2> f2Codec, Function<T, F2> f2Getter, NetworkCodec<F3> f3Codec, Function<T, F3> f3Getter, NetworkCodec<F4> f4Codec, Function<T, F4> f4Getter, NetworkCodec<F5> f5Codec, Function<T, F5> f5Getter, NetworkCodec<F6> f6Codec, Function<T, F6> f6Getter, SRFunction.Function6<F1, F2, F3, F4, F5, F6, T> constructor) {
        return NetworkCodec.of((out, t) -> {
            f1Codec.write(out, f1Getter.apply(t));
            f2Codec.write(out, f2Getter.apply(t));
            f3Codec.write(out, f3Getter.apply(t));
            f4Codec.write(out, f4Getter.apply(t));
            f5Codec.write(out, f5Getter.apply(t));
            f6Codec.write(out, f6Getter.apply(t));
        }, in -> constructor.apply(f1Codec.read(in), f2Codec.read(in), f3Codec.read(in), f4Codec.read(in), f5Codec.read(in), f6Codec.read(in)));
    }

    public static <T> NetworkCodec<T> unit(T instance) {
        return new NetworkCodec<Object>((out, t) -> {}, in -> instance);
    }

    private static <T, D extends T> NetworkCodec<T> ofMapBackedDynamic(Map<String, T> idToValue, Function<T, String> dynamicMapper, D defaultValue) {
        return BuiltInCodecs.STRING_CODEC.map(dynamicMapper, id -> idToValue.getOrDefault(id, defaultValue));
    }

    public static <T extends NetworkId, D extends T> NetworkCodec<T> ofNetworkIdDynamic(Map<String, T> idToValue, D defaultValue) {
        return NetworkCodec.ofMapBackedDynamic(idToValue, NetworkId::getId, defaultValue);
    }

    public static <T extends Enum<T>> NetworkCodec<T> ofEnumDynamic(Class<T> clazz, Function<T, String> dynamicMapper, T defaultValue) {
        return NetworkCodec.ofMapBackedDynamic(Arrays.stream((Enum[])clazz.getEnumConstants()).collect(Collectors.toMap(dynamicMapper, Function.identity())), dynamicMapper, defaultValue);
    }

    public static <T extends Enum<T>> NetworkCodec<T> ofEnum(Class<T> clazz, T defaultValue) {
        return NetworkCodec.ofEnumDynamic(clazz, rec$ -> ((NetworkId)rec$).getId(), defaultValue);
    }

    public void write(SROutputWriter buf, T t) {
        this.writer.write(buf, t);
    }

    public T read(SRInputReader buf) {
        return this.reader.read(buf);
    }

    public <O> NetworkCodec<O> map(Function<O, T> to, Function<T, O> from) {
        return NetworkCodec.of((stream, o) -> this.writer.write(stream, to.apply(o)), stream -> from.apply(this.reader.read(stream)));
    }

    public NetworkCodec<Optional<T>> optional() {
        return NetworkCodec.of((os, optional) -> {
            BuiltInCodecs.BOOLEAN_CODEC.write(os, optional.isPresent());
            optional.ifPresent(t -> this.write(os, t));
        }, is -> BuiltInCodecs.BOOLEAN_CODEC.read(is) != false ? Optional.of(this.read(is)) : Optional.empty());
    }

    public NetworkCodec<List<T>> list() {
        return NetworkCodec.of((os, list) -> {
            BuiltInCodecs.INT_CODEC.write(os, list.size());
            for (Object entry : list) {
                this.write(os, entry);
            }
        }, is -> {
            int size = BuiltInCodecs.INT_CODEC.read(is);
            ArrayList<T> list = new ArrayList<T>(size);
            for (int i = 0; i < size; ++i) {
                list.add(this.read(is));
            }
            return list;
        });
    }

    public <V> NetworkCodec<Map<T, V>> mappedTo(NetworkCodec<V> valueCodec) {
        return NetworkCodec.of((os, map) -> {
            BuiltInCodecs.INT_CODEC.write(os, map.size());
            for (Map.Entry entry : map.entrySet()) {
                this.write(os, entry.getKey());
                valueCodec.write(os, entry.getValue());
            }
        }, is -> {
            int size = BuiltInCodecs.INT_CODEC.read(is);
            LinkedHashMap<T, T> map = new LinkedHashMap<T, T>(size);
            for (int i = 0; i < size; ++i) {
                T key = this.read(is);
                T value = valueCodec.read(is);
                map.put(key, value);
            }
            return map;
        });
    }

    public NetworkCodec<T> compressed() {
        return NetworkCodec.of((stream, t) -> {
            try (GZIPOutputStream gzip = new GZIPOutputStream(stream.wrapper());
                 DataOutputStream outputStream = new DataOutputStream(gzip);){
                this.writer.write(new SROutputWriter(outputStream), t);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, stream -> {
            try (GZIPInputStream gzip = new GZIPInputStream(stream.wrapper());){
                T t;
                try (DataInputStream inputStream = new DataInputStream(gzip);){
                    t = this.reader.read(new SRInputReader(inputStream));
                }
                return t;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public final String toString() {
        return NetworkCodec.jvmdowngrader$toString$toString(this);
    }

    @Override
    public final int hashCode() {
        return NetworkCodec.jvmdowngrader$hashCode$hashCode(this);
    }

    @Override
    public final boolean equals(Object o) {
        return NetworkCodec.jvmdowngrader$equals$equals(this, o);
    }

    public Writer<T> writer() {
        return this.writer;
    }

    public Reader<T> reader() {
        return this.reader;
    }

    private static /* synthetic */ String jvmdowngrader$toString$toString(NetworkCodec networkCodec) {
        NetworkCodec networkCodec2 = networkCodec;
        return "NetworkCodec[" + "writer=" + networkCodec.writer + ", " + "reader=" + networkCodec.reader + "]";
    }

    private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(NetworkCodec networkCodec) {
        Object[] objectArray = new Object[]{networkCodec.writer, networkCodec.reader};
        return Arrays.hashCode(objectArray);
    }

    private static /* synthetic */ boolean jvmdowngrader$equals$equals(NetworkCodec networkCodec, Object object) {
        if (networkCodec == object) {
            return true;
        }
        if (object != null && object instanceof NetworkCodec) {
            NetworkCodec networkCodec2 = (NetworkCodec)object;
            if (Objects.equals(networkCodec.writer, networkCodec2.writer) && Objects.equals(networkCodec.reader, networkCodec2.reader)) {
                return true;
            }
        }
        return false;
    }

    @NestHost(value=NetworkCodec.class)
    public static interface Writer<T> {
        public void write(SROutputWriter var1, T var2);
    }

    @NestHost(value=NetworkCodec.class)
    public static interface Reader<T> {
        public T read(SRInputReader var1);
    }
}

