/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.commands.library;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.Instant;
import lombok.Generated;
import net.skinsrestorer.shadow.cloud.execution.postprocessor.CommandPostprocessingContext;
import net.skinsrestorer.shadow.cloud.execution.postprocessor.CommandPostprocessor;
import net.skinsrestorer.shadow.cloud.key.CloudKey;
import net.skinsrestorer.shadow.cloud.processors.cooldown.CooldownGroup;
import net.skinsrestorer.shadow.cloud.processors.cooldown.CooldownInstance;
import net.skinsrestorer.shadow.cloud.processors.cooldown.CooldownManager;
import net.skinsrestorer.shadow.cloud.processors.cooldown.profile.CooldownProfile;
import net.skinsrestorer.shadow.cloud.services.type.ConsumerService;
import net.skinsrestorer.shadow.geantyref.TypeToken;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={1.class})
public class CustomCooldownProcessor<C>
implements CommandPostprocessor<C> {
    public static final CloudKey<CooldownGroup> META_COOLDOWN_GROUP = CloudKey.of("cloud:cooldown_duration", new TypeToken<CooldownGroup>(){});
    private final CooldownManager<C> cooldownManager;

    @Override
    public void accept(@NonNull CommandPostprocessingContext<C> context) {
        CooldownGroup cooldownGroup = context.command().commandMeta().getOrDefault(META_COOLDOWN_GROUP, null);
        if (cooldownGroup == null) {
            return;
        }
        if (this.cooldownManager.configuration().bypassCooldown().test(context.commandContext())) {
            return;
        }
        CooldownProfile profile = this.cooldownManager.repository().getProfile(context.commandContext().sender(), this.cooldownManager.configuration().profileFactory());
        CooldownInstance cooldownInstance = profile.getCooldown(cooldownGroup);
        if (cooldownInstance != null) {
            Instant endTime = cooldownInstance.creationTime().plus(cooldownInstance.duration());
            Duration remainingTime = Duration.between(Instant.now(this.cooldownManager.configuration().clock()), endTime);
            this.cooldownManager.configuration().activeCooldownListeners().forEach(listener -> listener.cooldownActive(context.commandContext().sender(), context.command(), cooldownInstance, remainingTime));
            ConsumerService.interrupt();
        }
    }

    @Generated
    public CustomCooldownProcessor(CooldownManager<C> cooldownManager) {
        this.cooldownManager = cooldownManager;
    }
}

