/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.commands.library;

import java.lang.reflect.Field;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.skinsrestorer.api.property.SkinVariant;
import net.skinsrestorer.shadow.cloud.CommandManager;
import net.skinsrestorer.shadow.cloud.annotations.AnnotationParser;
import net.skinsrestorer.shadow.cloud.brigadier.BrigadierManagerHolder;
import net.skinsrestorer.shadow.cloud.brigadier.BrigadierSetting;
import net.skinsrestorer.shadow.cloud.brigadier.CloudBrigadierManager;
import net.skinsrestorer.shadow.cloud.description.Description;
import net.skinsrestorer.shadow.cloud.exception.InvalidCommandSenderException;
import net.skinsrestorer.shadow.cloud.key.CloudKey;
import net.skinsrestorer.shadow.cloud.minecraft.extras.MinecraftExceptionHandler;
import net.skinsrestorer.shadow.cloud.minecraft.extras.caption.ComponentCaptionFormatter;
import net.skinsrestorer.shadow.cloud.parser.ParserDescriptor;
import net.skinsrestorer.shadow.cloud.parser.standard.EnumParser;
import net.skinsrestorer.shadow.cloud.permission.PredicatePermission;
import net.skinsrestorer.shadow.cloud.processors.cooldown.CooldownConfiguration;
import net.skinsrestorer.shadow.cloud.processors.cooldown.CooldownGroup;
import net.skinsrestorer.shadow.cloud.processors.cooldown.CooldownInstance;
import net.skinsrestorer.shadow.cloud.processors.cooldown.CooldownManager;
import net.skinsrestorer.shadow.cloud.processors.cooldown.CooldownRepository;
import net.skinsrestorer.shadow.cloud.processors.cooldown.ImmutableCooldownInstance;
import net.skinsrestorer.shadow.cloud.processors.cooldown.profile.CooldownProfile;
import net.skinsrestorer.shadow.cloud.processors.cooldown.profile.CooldownProfileFactory;
import net.skinsrestorer.shadow.cloud.processors.requirements.RequirementPostprocessor;
import net.skinsrestorer.shadow.cloud.processors.requirements.annotation.RequirementBindings;
import net.skinsrestorer.shadow.cloud.services.type.ConsumerService;
import net.skinsrestorer.shadow.cloud.translations.TranslationBundle;
import net.skinsrestorer.shadow.cloud.translations.minecraft.extras.MinecraftExtrasTranslationBundle;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_Optional;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_List;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.skinsrestorer.shared.commands.library.ConsoleOnlyRequirement;
import net.skinsrestorer.shared.commands.library.CustomCooldownProcessor;
import net.skinsrestorer.shared.commands.library.PlayerSelector;
import net.skinsrestorer.shared.commands.library.SRMessageException;
import net.skinsrestorer.shared.commands.library.annotations.CommandDescription;
import net.skinsrestorer.shared.commands.library.annotations.CommandPermission;
import net.skinsrestorer.shared.commands.library.annotations.ConsoleOnly;
import net.skinsrestorer.shared.commands.library.annotations.RootDescription;
import net.skinsrestorer.shared.commands.library.annotations.SRCooldownGroup;
import net.skinsrestorer.shared.commands.library.types.PlayerSelectorArgumentParser;
import net.skinsrestorer.shared.config.ProxyConfig;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.storage.adapter.AdapterReference;
import net.skinsrestorer.shared.storage.adapter.StorageAdapter;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.SRForeign;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.subjects.SRProxyPlayer;
import net.skinsrestorer.shared.subjects.messages.ComponentHelper;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.subjects.messages.SkinsRestorerLocale;
import net.skinsrestorer.shared.subjects.permissions.PermissionRegistry;
import net.skinsrestorer.shared.utils.SRHelpers;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@NestMembers(value={CooldownDeletionTask.class, StorageBackedProfile.class, StorageBackendRepository.class})
public class SRCommandManager {
    public static final CloudKey<String> BUKKIT_DESCRIPTION = CloudKey.of("bukkit_description", String.class);
    private final CommandManager<SRCommandSender> commandManager;
    private final AnnotationParser<SRCommandSender> annotationParser;
    private final CooldownManager<SRCommandSender> cooldownManager;

    @Inject
    public SRCommandManager(SRPlatformAdapter platform, SRLogger logger, SkinsRestorerLocale locale, SettingsManager settingsManager, AdapterReference reference) {
        BrigadierManagerHolder holder;
        this.commandManager = platform.createCommandManager();
        this.annotationParser = new AnnotationParser<SRCommandSender>(this.commandManager, SRCommandSender.class);
        StorageBackendRepository storageRepository = new StorageBackendRepository(reference);
        CooldownRepository<SRCommandSender> cooldownRepository = CooldownRepository.mapping(sender -> {
            if (sender instanceof SRPlayer) {
                SRPlayer player = (SRPlayer)sender;
                return player.getUniqueId();
            }
            throw new IllegalArgumentException("Only SRPlayer is supported");
        }, storageRepository);
        ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "SRCooldownCleanupThread");
            t.setDaemon(true);
            return t;
        });
        this.cooldownManager = CooldownManager.cooldownManager(CooldownConfiguration.builder().repository(cooldownRepository).addCreationListener((sender, command, instance) -> service.schedule(new CooldownDeletionTask(instance.group(), instance.profile()), instance.duration().getSeconds(), TimeUnit.SECONDS)).addAllActiveCooldownListeners(J_U_List.of((sender, command, cooldown, remainingTime) -> sender.sendMessage(Message.SKIN_COOLDOWN, Placeholder.parsed("time", SRHelpers.durationFormat(locale, sender, remainingTime))))).bypassCooldown(context -> !(context.sender() instanceof SRPlayer) || ((SRCommandSender)context.sender()).hasPermission(PermissionRegistry.BYPASS_COOLDOWN)).build());
        try {
            for (UUID uUID : reference.get().getAllCooldownProfiles()) {
                StorageBackedProfile profile = storageRepository.getProfileIfExists(uUID);
                for (ImmutableCooldownInstance instance2 : profile.getAllCooldowns()) {
                    long secondsUntilDeletion = instance2.creationTime().plus(instance2.duration()).getEpochSecond() - SRHelpers.getEpochSecond();
                    if (secondsUntilDeletion > 0L) {
                        service.schedule(new CooldownDeletionTask(instance2.group(), profile), secondsUntilDeletion, TimeUnit.SECONDS);
                        continue;
                    }
                    profile.deleteCooldown(instance2.group());
                }
            }
        }
        catch (StorageAdapter.StorageException e) {
            throw new RuntimeException(e);
        }
        CommandManager<SRCommandSender> commandManager = this.commandManager;
        if (commandManager instanceof BrigadierManagerHolder && (holder = (BrigadierManagerHolder)((Object)commandManager)).hasBrigadierManager()) {
            CloudBrigadierManager cloudBrigadierManager = holder.brigadierManager();
            cloudBrigadierManager.setNativeNumberSuggestions(true);
            cloudBrigadierManager.settings().set(BrigadierSetting.FORCE_EXECUTABLE, true);
        }
        this.commandManager.captionRegistry().registerProvider(TranslationBundle.core(SRForeign::getLocale));
        this.commandManager.captionRegistry().registerProvider(MinecraftExtrasTranslationBundle.minecraftExtras(SRForeign::getLocale));
        MinecraftExceptionHandler.create(ComponentHelper::commandSenderToAudience).defaultHandlers().handler(InvalidCommandSenderException.class, (formatter, ctx) -> ComponentHelper.convertJsonToComponent(locale.getMessageRequired((SRForeign)ctx.context().sender(), Message.ONLY_ALLOWED_ON_PLAYER))).handler(SRMessageException.class, (formatter, ctx) -> ComponentHelper.convertJsonToComponent(((SRMessageException)ctx.exception()).getMessageSupplier().apply(locale))).captionFormatter(ComponentCaptionFormatter.miniMessage()).registerTo(this.commandManager);
        this.commandManager.registerCommandPostProcessor(s -> {
            boolean shouldBlock;
            Object patt0$temp = s.commandContext().sender();
            if (!(patt0$temp instanceof SRProxyPlayer)) {
                return;
            }
            SRProxyPlayer proxyPlayer = (SRProxyPlayer)patt0$temp;
            if (!settingsManager.getProperty(ProxyConfig.NOT_ALLOWED_COMMAND_SERVERS_ENABLED).booleanValue()) {
                return;
            }
            Optional<String> currentServer = proxyPlayer.getCurrentServer();
            if (J_U_Optional.isEmpty(currentServer)) {
                if (!settingsManager.getProperty(ProxyConfig.NOT_ALLOWED_COMMAND_SERVERS_IF_NONE_BLOCK_COMMAND).booleanValue()) {
                    logger.debug(J_L_String.formatted("Player %s is not connected to any server, so the command will be blocked.", proxyPlayer.getName()));
                    proxyPlayer.sendMessage(Message.NOT_CONNECTED_TO_SERVER);
                    ConsumerService.interrupt();
                }
                return;
            }
            boolean inList = settingsManager.getProperty(ProxyConfig.NOT_ALLOWED_COMMAND_SERVERS).contains(currentServer.get());
            boolean bl = shouldBlock = settingsManager.getProperty(ProxyConfig.NOT_ALLOWED_COMMAND_SERVERS_ALLOWLIST) != inList;
            if (shouldBlock) {
                proxyPlayer.sendMessage(Message.COMMAND_SERVER_NOT_ALLOWED_MESSAGE, Placeholder.unparsed("server", currentServer.get()));
                ConsumerService.interrupt();
            }
        });
        this.commandManager.registerCommandPostProcessor(new CustomCooldownProcessor<SRCommandSender>(this.cooldownManager));
        this.commandManager.parserRegistry().registerParser(EnumParser.enumParser(SkinVariant.class));
        this.commandManager.parserRegistry().registerParser(ParserDescriptor.of(new PlayerSelectorArgumentParser(platform), PlayerSelector.class));
        this.annotationParser.registerBuilderModifier(CommandPermission.class, (commandPermission, builder) -> builder.permission(PredicatePermission.of(CloudKey.of(commandPermission.value().getPermission().getPermissionString()), c -> c.hasPermission(commandPermission.value()))));
        this.annotationParser.registerBuilderModifier(CommandDescription.class, (commandDescription, builder) -> builder.commandDescription(Description.of(commandDescription.value().getKey())));
        this.annotationParser.registerBuilderModifier(SRCooldownGroup.class, (srCooldownGroup, builder) -> builder.meta(CustomCooldownProcessor.META_COOLDOWN_GROUP, CooldownGroup.named(srCooldownGroup.value())));
        this.annotationParser.registerBuilderModifier(RootDescription.class, (rootDescription, builder) -> builder.meta(BUKKIT_DESCRIPTION, ComponentHelper.convertJsonToLegacy(locale.getMessageRequired(locale.getEnglishForeign(), rootDescription.value()))));
        this.commandManager.registerCommandPostProcessor(RequirementPostprocessor.of(ConsoleOnlyRequirement.REQUIREMENT_KEY, (context, requirement) -> ((SRCommandSender)context.sender()).sendMessage(Message.ONLY_ALLOWED_ON_CONSOLE)));
        RequirementBindings.create(this.annotationParser, ConsoleOnlyRequirement.REQUIREMENT_KEY).register(ConsoleOnly.class, annotation -> new ConsoleOnlyRequirement());
    }

    public void registerCommand(Object command) {
        this.annotationParser.parse(command);
    }

    public void setCooldown(SRPlayer player, CooldownGroup cooldownGroup, Duration duration) {
        CooldownProfile profile = this.cooldownManager.repository().getProfile(player, this.cooldownManager.configuration().profileFactory());
        ImmutableCooldownInstance instance = CooldownInstance.builder().profile(profile).group(cooldownGroup).duration(duration).creationTime(Instant.now(this.cooldownManager.configuration().clock())).build();
        profile.setCooldown(cooldownGroup, instance);
        this.cooldownManager.configuration().creationListeners().forEach(listener -> listener.cooldownCreated(player, null, instance));
    }

    public void execute(SRCommandSender executor, String input) {
        this.commandManager.commandExecutor().executeCommand(executor, input);
    }

    @Generated
    public CommandManager<SRCommandSender> getCommandManager() {
        return this.commandManager;
    }

    @NestHost(value=SRCommandManager.class)
    private static class StorageBackendRepository
    extends CooldownRepository.AbstractCooldownRepository<UUID> {
        private final AdapterReference reference;

        public @NonNull StorageBackedProfile getProfile(@NonNull UUID key, @NonNull CooldownProfileFactory profileFactory) {
            return this.getProfileIfExists(key);
        }

        @NotNull
        public StorageBackedProfile getProfileIfExists(@NonNull UUID key) {
            return new StorageBackedProfile(key, this.reference);
        }

        @Override
        public void deleteProfile(@NonNull UUID key) {
        }

        @Generated
        public StorageBackendRepository(AdapterReference reference) {
            this.reference = reference;
        }
    }

    @RecordComponents(value={@RecordComponents.Value(name="key", type=UUID.class), @RecordComponents.Value(name="reference", type=AdapterReference.class)})
    @NestHost(value=SRCommandManager.class)
    private static final class StorageBackedProfile
    extends J_L_Record
    implements CooldownProfile {
        private final UUID key;
        private final AdapterReference reference;

        StorageBackedProfile(UUID key, AdapterReference reference) {
            this.key = key;
            this.reference = reference;
        }

        private static String getCooldownName(CooldownGroup.NamedCooldownGroup group) {
            try {
                Field field = CooldownGroup.NamedCooldownGroup.class.getDeclaredField("name");
                field.setAccessible(true);
                return (String)field.get(group);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public @Nullable CooldownInstance getCooldown(@NonNull CooldownGroup group) {
            String groupName = StorageBackedProfile.getCooldownName((CooldownGroup.NamedCooldownGroup)group);
            return this.getAllCooldowns().stream().filter(cooldown -> StorageBackedProfile.getCooldownName((CooldownGroup.NamedCooldownGroup)cooldown.group()).equals(groupName)).findFirst().orElse(null);
        }

        @Override
        public void setCooldown(@NonNull CooldownGroup group, @NonNull CooldownInstance cooldown) {
            String groupName = StorageBackedProfile.getCooldownName((CooldownGroup.NamedCooldownGroup)group);
            this.reference.get().setCooldown(this.key, groupName, cooldown.creationTime(), cooldown.duration());
        }

        @Override
        public void deleteCooldown(@NonNull CooldownGroup group) {
            String groupName = StorageBackedProfile.getCooldownName((CooldownGroup.NamedCooldownGroup)group);
            this.reference.get().removeCooldown(this.key, groupName);
        }

        @Override
        public boolean isEmpty() {
            return this.getAllCooldowns().isEmpty();
        }

        public List<ImmutableCooldownInstance> getAllCooldowns() {
            try {
                return J_U_S_Stream.toList(this.reference.get().getCooldowns(this.key).stream().map(storageCooldown -> CooldownInstance.builder().profile(this).group(CooldownGroup.named(storageCooldown.groupName())).duration(storageCooldown.duration()).creationTime(storageCooldown.creationTime()).build()));
            }
            catch (StorageAdapter.StorageException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public final String toString() {
            return StorageBackedProfile.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return StorageBackedProfile.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return StorageBackedProfile.jvmdowngrader$equals$equals(this, o);
        }

        public UUID key() {
            return this.key;
        }

        public AdapterReference reference() {
            return this.reference;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(StorageBackedProfile storageBackedProfile) {
            StorageBackedProfile storageBackedProfile2 = storageBackedProfile;
            return "SRCommandManager$StorageBackedProfile[" + "key=" + storageBackedProfile.key + ", " + "reference=" + storageBackedProfile.reference + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(StorageBackedProfile storageBackedProfile) {
            Object[] objectArray = new Object[]{storageBackedProfile.key, storageBackedProfile.reference};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(StorageBackedProfile storageBackedProfile, Object object) {
            if (storageBackedProfile == object) {
                return true;
            }
            if (object != null && object instanceof StorageBackedProfile) {
                StorageBackedProfile storageBackedProfile2 = (StorageBackedProfile)object;
                if (Objects.equals(storageBackedProfile.key, storageBackedProfile2.key) && Objects.equals(storageBackedProfile.reference, storageBackedProfile2.reference)) {
                    return true;
                }
            }
            return false;
        }
    }

    @RecordComponents(value={@RecordComponents.Value(name="group", type=CooldownGroup.class), @RecordComponents.Value(name="profile", type=CooldownProfile.class)})
    @NestHost(value=SRCommandManager.class)
    private static final class CooldownDeletionTask
    extends J_L_Record
    implements Runnable {
        private final CooldownGroup group;
        private final CooldownProfile profile;

        CooldownDeletionTask(CooldownGroup group, CooldownProfile profile) {
            this.group = group;
            this.profile = profile;
        }

        @Override
        public void run() {
            this.profile.deleteCooldown(this.group);
        }

        @Override
        public final String toString() {
            return CooldownDeletionTask.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return CooldownDeletionTask.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return CooldownDeletionTask.jvmdowngrader$equals$equals(this, o);
        }

        public CooldownGroup group() {
            return this.group;
        }

        public CooldownProfile profile() {
            return this.profile;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(CooldownDeletionTask cooldownDeletionTask) {
            CooldownDeletionTask cooldownDeletionTask2 = cooldownDeletionTask;
            return "SRCommandManager$CooldownDeletionTask[" + "group=" + cooldownDeletionTask.group + ", " + "profile=" + cooldownDeletionTask.profile + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(CooldownDeletionTask cooldownDeletionTask) {
            Object[] objectArray = new Object[]{cooldownDeletionTask.group, cooldownDeletionTask.profile};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(CooldownDeletionTask cooldownDeletionTask, Object object) {
            if (cooldownDeletionTask == object) {
                return true;
            }
            if (object != null && object instanceof CooldownDeletionTask) {
                CooldownDeletionTask cooldownDeletionTask2 = (CooldownDeletionTask)object;
                if (Objects.equals(cooldownDeletionTask.group, cooldownDeletionTask2.group) && Objects.equals(cooldownDeletionTask.profile, cooldownDeletionTask2.profile)) {
                    return true;
                }
            }
            return false;
        }
    }
}

