/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.connections;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.gson.Gson;
import net.skinsrestorer.shadow.gson.GsonBuilder;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j17.stub.java_base.J_U_Random;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_List;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_Map;
import net.skinsrestorer.shared.config.APIConfig;
import net.skinsrestorer.shared.config.GUIConfig;
import net.skinsrestorer.shared.connections.RecommendationsService;
import net.skinsrestorer.shared.connections.responses.RecommenationResponse;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.utils.SRHelpers;

public class RecommendationsState {
    private final SRPlugin plugin;
    private final SRPlatformAdapter adapter;
    private final SRLogger logger;
    private final RecommendationsService recommendationsService;
    private final SettingsManager settingsManager;
    private final Gson gson = new GsonBuilder().create();
    private Map<String, RecommenationResponse.SkinInfo> recommendationsMap = J_U_Map.of();
    private List<RecommenationResponse.SkinInfo> recommendationsList = J_U_List.of();

    public void scheduleRecommendations() {
        if (!this.settingsManager.getProperty(APIConfig.FETCH_RECOMMENDED_SKINS).booleanValue()) {
            this.logger.info("Fetching recommended skins is disabled.");
            return;
        }
        Path path = this.plugin.getDataFolder().resolve("recommendations.json");
        boolean fileExists = Files.exists(path, new LinkOption[0]);
        if (fileExists) {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                RecommenationResponse recommenationResponse = this.gson.fromJson((Reader)reader, RecommenationResponse.class);
                if (recommenationResponse == null || recommenationResponse.getSkins() == null) {
                    throw new IOException("Invalid data");
                }
                this.setDataFromResponse(recommenationResponse.getSkins());
            }
            catch (IOException e) {
                this.logger.warning(J_L_String.formatted("Failed to load recommendations from file: %s", e.getMessage()));
            }
        }
        int offsetSeconds = fileExists ? J_U_Random.nextInt(ThreadLocalRandom.current(), 0, 300) : 0;
        this.adapter.runRepeatAsync(() -> {
            try {
                this.recommendationsService.getRecommendations().ifPresent(recommenationResponse -> {
                    this.setDataFromResponse(recommenationResponse.getSkins());
                    try {
                        SRHelpers.writeIfNeeded(path, this.gson.toJson(recommenationResponse));
                    }
                    catch (IOException e) {
                        this.logger.warning(J_L_String.formatted("Failed to save recommendations to file: %s", e.getMessage()));
                    }
                });
            }
            catch (IOException | DataRequestException e) {
                this.logger.warning(J_L_String.formatted("Failed to get recommended skins: %s", e.getMessage()));
            }
        }, offsetSeconds, (int)(TimeUnit.HOURS.toSeconds(6L) + (long)offsetSeconds), TimeUnit.SECONDS);
    }

    private void setDataFromResponse(RecommenationResponse.SkinInfo[] recommendations) {
        this.recommendationsMap = Stream.of(recommendations).collect(Collectors.toMap(RecommenationResponse.SkinInfo::getSkinId, skinInfo -> skinInfo));
        this.recommendationsList = Arrays.asList(recommendations);
        Collections.shuffle(this.recommendationsList);
    }

    public int getRecommendationsCount() {
        return this.getRecommendationsOffset(0, Integer.MAX_VALUE).length;
    }

    public RecommenationResponse.SkinInfo[] getRecommendationsOffset(int offset, int limit) {
        return (RecommenationResponse.SkinInfo[])this.recommendationsList.stream().filter(skinInfo -> {
            if (!this.settingsManager.getProperty(GUIConfig.RECOMMENDATIONS_GUI_ONLY_LIST).booleanValue()) {
                return true;
            }
            return this.settingsManager.getProperty(GUIConfig.RECOMMENDATIONS_GUI_LIST).contains(skinInfo.getSkinId());
        }).skip(offset).limit(limit).toArray(RecommenationResponse.SkinInfo[]::new);
    }

    public Optional<RecommenationResponse.SkinInfo> getRandomRecommendation() {
        if (this.recommendationsList.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(SRHelpers.getRandomEntry(this.recommendationsList));
    }

    public RecommenationResponse.SkinInfo getRecommendation(String skinId) {
        return this.recommendationsMap.get(skinId);
    }

    @Inject
    @Generated
    public RecommendationsState(SRPlugin plugin, SRPlatformAdapter adapter, SRLogger logger, RecommendationsService recommendationsService, SettingsManager settingsManager) {
        this.plugin = plugin;
        this.adapter = adapter;
        this.logger = logger;
        this.recommendationsService = recommendationsService;
        this.settingsManager = settingsManager;
    }
}

