/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.listeners;

import java.util.Optional;
import lombok.Generated;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.api.storage.PlayerStorage;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shared.config.AdvancedConfig;
import net.skinsrestorer.shared.config.LoginConfig;
import net.skinsrestorer.shared.listeners.event.SRLoginProfileEvent;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.storage.adapter.AdapterReference;
import net.skinsrestorer.shared.storage.adapter.StorageAdapter;

public final class LoginProfileListenerAdapter<R> {
    private final SettingsManager settings;
    private final PlayerStorage playerStorage;
    private final SRLogger logger;
    private final AdapterReference adapterReference;

    public R handleLogin(SRLoginProfileEvent<R> event) {
        this.logger.debug(J_L_String.formatted("Handling login for %s (%s)", event.getPlayerName(), event.getPlayerUniqueId()));
        if (this.handleSync(event)) {
            return null;
        }
        return event.runAsync(() -> {
            try {
                this.handleAsync(event).ifPresent(event::setResultProperty);
            }
            catch (DataRequestException e) {
                this.logger.debug(e);
            }
        });
    }

    private boolean handleSync(SRLoginProfileEvent<R> event) {
        return this.settings.getProperty(AdvancedConfig.DISABLE_ON_JOIN_SKINS) != false || this.settings.getProperty(LoginConfig.NO_SKIN_IF_LOGIN_CANCELED) != false && event.isCancelled();
    }

    private Optional<SkinProperty> handleAsync(SRLoginProfileEvent<R> event) throws DataRequestException {
        try {
            this.adapterReference.get().migrateLegacyPlayer(event.getPlayerName(), event.getPlayerUniqueId());
        }
        catch (StorageAdapter.StorageException e) {
            this.logger.severe("There was a bug while migrating a legacy player to the new format, contact us on Discord and provide this error message:", e);
        }
        return this.playerStorage.getSkinForPlayer(event.getPlayerUniqueId(), event.getPlayerName(), event.hasOnlineProperties());
    }

    @Inject
    @Generated
    public LoginProfileListenerAdapter(SettingsManager settings, PlayerStorage playerStorage, SRLogger logger, AdapterReference adapterReference) {
        this.settings = settings;
        this.playerStorage = playerStorage;
        this.logger = logger;
        this.adapterReference = adapterReference;
    }
}

