/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.storage;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import net.skinsrestorer.api.PropertyUtils;
import net.skinsrestorer.api.property.SkinIdentifier;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_List;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_Optional;
import net.skinsrestorer.shadow.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.skinsrestorer.shared.config.GUIConfig;
import net.skinsrestorer.shared.connections.RecommendationsState;
import net.skinsrestorer.shared.gui.GUIUtils;
import net.skinsrestorer.shared.gui.PageInfo;
import net.skinsrestorer.shared.gui.PageType;
import net.skinsrestorer.shared.storage.PlayerStorageImpl;
import net.skinsrestorer.shared.storage.SkinStorageImpl;
import net.skinsrestorer.shared.storage.adapter.AdapterReference;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.subjects.messages.ComponentHelper;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.subjects.messages.SkinsRestorerLocale;
import net.skinsrestorer.shared.subjects.permissions.PermissionRegistry;
import net.skinsrestorer.shared.subjects.permissions.SkinPermissionManager;
import net.skinsrestorer.shared.utils.SRHelpers;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={5.class, 4.class, 3.class, 2.class, 1.class})
public class GUIStorage {
    public static final String RECOMMENDATION_PREFIX = "sr-recommendation-";
    private final SkinsRestorerLocale locale;
    private final PlayerStorageImpl playerStorage;
    private final SkinStorageImpl skinStorage;
    private final SettingsManager settings;
    private final AdapterReference adapterReference;
    private final RecommendationsState recommendationsState;
    private final SkinPermissionManager permissionManager;

    public PageInfo getGUIPage(final SRPlayer player, int page, PageType pageType) {
        return GUIUtils.getGUIPage(player, this.locale, this.settings, this.playerStorage, this.permissionManager, page, pageType, new GUIUtils.GUIDataSource(){

            @Override
            public boolean isEnabled() {
                return GUIStorage.this.jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$get$settings().getProperty(GUIConfig.CUSTOM_GUI_ENABLED);
            }

            @Override
            public PageType getPageType() {
                return PageType.MAIN;
            }

            @Override
            public int getIndex() {
                return GUIStorage.this.jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$get$settings().getProperty(GUIConfig.CUSTOM_GUI_INDEX);
            }

            @Override
            public int getTotalSkins() {
                return GUIStorage.this.jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$get$adapterReference().get().getTotalCustomSkins();
            }

            @Override
            public List<GUIUtils.GUIRawSkinEntry> getGUISkins(int offset, int limit) {
                return GUIStorage.this.jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$get$adapterReference().get().getCustomGUISkins(offset, limit);
            }
        }, new GUIUtils.GUIDataSource(){

            @Override
            public boolean isEnabled() {
                return GUIStorage.this.jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$get$settings().getProperty(GUIConfig.PLAYERS_GUI_ENABLED);
            }

            @Override
            public PageType getPageType() {
                return PageType.MAIN;
            }

            @Override
            public int getIndex() {
                return GUIStorage.this.jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$get$settings().getProperty(GUIConfig.PLAYERS_GUI_INDEX);
            }

            @Override
            public int getTotalSkins() {
                return GUIStorage.this.jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$get$adapterReference().get().getTotalPlayerSkins();
            }

            @Override
            public List<GUIUtils.GUIRawSkinEntry> getGUISkins(int offset, int limit) {
                return GUIStorage.this.jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$get$adapterReference().get().getPlayerGUISkins(offset, limit);
            }
        }, new GUIUtils.GUIDataSource(){

            @Override
            public boolean isEnabled() {
                return GUIStorage.this.jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$get$settings().getProperty(GUIConfig.RECOMMENDATIONS_GUI_ENABLED);
            }

            @Override
            public PageType getPageType() {
                return PageType.MAIN;
            }

            @Override
            public int getIndex() {
                return GUIStorage.this.jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$get$settings().getProperty(GUIConfig.RECOMMENDATIONS_GUI_INDEX);
            }

            @Override
            public int getTotalSkins() {
                return GUIStorage.this.jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$get$recommendationsState().getRecommendationsCount();
            }

            @Override
            public List<GUIUtils.GUIRawSkinEntry> getGUISkins(int offset, int limit) {
                return J_U_S_Stream.toList(Arrays.stream(GUIStorage.this.jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$get$recommendationsState().getRecommendationsOffset(offset, limit)).map(r -> new GUIUtils.GUIRawSkinEntry(SkinIdentifier.ofCustom(3.jvmdowngrader$concat$lambda$getGUISkins$0$1(r.getSkinId())), ComponentHelper.convertPlainToJson(r.getSkinName()), PropertyUtils.getSkinTextureHash(r.getValue()), J_U_List.of())));
            }

            private static /* synthetic */ String jvmdowngrader$concat$lambda$getGUISkins$0$1(String string) {
                return GUIStorage.RECOMMENDATION_PREFIX + string;
            }
        }, new GUIUtils.GUIDataSource(){

            @Override
            public boolean isEnabled() {
                return player.hasPermission(PermissionRegistry.SKIN_UNDO);
            }

            @Override
            public PageType getPageType() {
                return PageType.HISTORY;
            }

            @Override
            public int getIndex() {
                return 0;
            }

            @Override
            public int getTotalSkins() {
                return GUIStorage.this.jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$get$playerStorage().getHistoryCount(player.getUniqueId());
            }

            @Override
            public List<GUIUtils.GUIRawSkinEntry> getGUISkins(int offset, int limit) {
                return J_U_S_Stream.toList(GUIStorage.this.jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$get$playerStorage().getHistoryEntries(player.getUniqueId(), offset, limit).stream().flatMap(h -> J_U_Optional.stream(GUIStorage.this.jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$get$skinStorage().getSkinDataByIdentifier(h.getSkinIdentifier())).map(property -> new GUIUtils.GUIRawSkinEntry(h.getSkinIdentifier(), GUIStorage.this.jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$get$skinStorage().resolveSkinName(h.getSkinIdentifier()), PropertyUtils.getSkinTextureHash(property), J_U_List.of(GUIStorage.this.jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$get$locale().getMessageRequired(player, Message.SKINSMENU_HISTORY_LORE, Placeholder.parsed("time", SRHelpers.formatEpochSeconds(GUIStorage.this.jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$get$settings(), h.getTimestamp(), player.getLocale()))))))));
            }
        }, new GUIUtils.GUIDataSource(){

            @Override
            public boolean isEnabled() {
                return player.hasPermission(PermissionRegistry.SKIN_FAVOURITE);
            }

            @Override
            public PageType getPageType() {
                return PageType.FAVOURITES;
            }

            @Override
            public int getIndex() {
                return 0;
            }

            @Override
            public int getTotalSkins() {
                return GUIStorage.this.jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$get$playerStorage().getFavouriteCount(player.getUniqueId());
            }

            @Override
            public List<GUIUtils.GUIRawSkinEntry> getGUISkins(int offset, int limit) {
                return J_U_S_Stream.toList(GUIStorage.this.jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$get$playerStorage().getFavouriteEntries(player.getUniqueId(), offset, limit).stream().flatMap(h -> J_U_Optional.stream(GUIStorage.this.jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$get$skinStorage().getSkinDataByIdentifier(h.getSkinIdentifier())).map(property -> new GUIUtils.GUIRawSkinEntry(h.getSkinIdentifier(), GUIStorage.this.jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$get$skinStorage().resolveSkinName(h.getSkinIdentifier()), PropertyUtils.getSkinTextureHash(property), J_U_List.of()))));
            }
        });
    }

    @Inject
    @Generated
    public GUIStorage(SkinsRestorerLocale locale, PlayerStorageImpl playerStorage, SkinStorageImpl skinStorage, SettingsManager settings, AdapterReference adapterReference, RecommendationsState recommendationsState, SkinPermissionManager permissionManager) {
        this.locale = locale;
        this.playerStorage = playerStorage;
        this.skinStorage = skinStorage;
        this.settings = settings;
        this.adapterReference = adapterReference;
        this.recommendationsState = recommendationsState;
        this.permissionManager = permissionManager;
    }

    public /* synthetic */ SettingsManager jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$get$settings() {
        return this.settings;
    }

    public /* synthetic */ void jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$set$settings(SettingsManager settingsManager) {
        this.settings = settingsManager;
    }

    public /* synthetic */ PlayerStorageImpl jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$get$playerStorage() {
        return this.playerStorage;
    }

    public /* synthetic */ void jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$set$playerStorage(PlayerStorageImpl playerStorageImpl) {
        this.playerStorage = playerStorageImpl;
    }

    public /* synthetic */ SkinStorageImpl jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$get$skinStorage() {
        return this.skinStorage;
    }

    public /* synthetic */ void jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$set$skinStorage(SkinStorageImpl skinStorageImpl) {
        this.skinStorage = skinStorageImpl;
    }

    public /* synthetic */ SkinsRestorerLocale jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$get$locale() {
        return this.locale;
    }

    public /* synthetic */ void jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$set$locale(SkinsRestorerLocale skinsRestorerLocale) {
        this.locale = skinsRestorerLocale;
    }

    public /* synthetic */ RecommendationsState jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$get$recommendationsState() {
        return this.recommendationsState;
    }

    public /* synthetic */ void jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$set$recommendationsState(RecommendationsState recommendationsState) {
        this.recommendationsState = recommendationsState;
    }

    public /* synthetic */ AdapterReference jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$get$adapterReference() {
        return this.adapterReference;
    }

    public /* synthetic */ void jvmdowngrader$nest$net_skinsrestorer_shared_storage_GUIStorage$set$adapterReference(AdapterReference adapterReference) {
        this.adapterReference = adapterReference;
    }
}

