/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.storage;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.skinsrestorer.api.PropertyUtils;
import net.skinsrestorer.api.connections.model.MineSkinResponse;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.api.exception.MineSkinException;
import net.skinsrestorer.api.model.MojangProfileResponse;
import net.skinsrestorer.api.property.InputDataResult;
import net.skinsrestorer.api.property.MojangSkinDataResult;
import net.skinsrestorer.api.property.SkinIdentifier;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.api.property.SkinVariant;
import net.skinsrestorer.api.storage.SkinStorage;
import net.skinsrestorer.shadow.configme.SettingsManager;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_Optional;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_L_MatchException;
import net.skinsrestorer.shared.config.StorageConfig;
import net.skinsrestorer.shared.connections.MineSkinAPIImpl;
import net.skinsrestorer.shared.connections.MojangAPIImpl;
import net.skinsrestorer.shared.connections.RecommendationsState;
import net.skinsrestorer.shared.connections.responses.RecommenationResponse;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.storage.CacheStorageImpl;
import net.skinsrestorer.shared.storage.HardcodedSkins;
import net.skinsrestorer.shared.storage.adapter.AdapterReference;
import net.skinsrestorer.shared.storage.adapter.StorageAdapter;
import net.skinsrestorer.shared.storage.model.cache.MojangCacheData;
import net.skinsrestorer.shared.storage.model.skin.CustomSkinData;
import net.skinsrestorer.shared.storage.model.skin.LegacySkinData;
import net.skinsrestorer.shared.storage.model.skin.PlayerSkinData;
import net.skinsrestorer.shared.storage.model.skin.URLIndexData;
import net.skinsrestorer.shared.storage.model.skin.URLSkinData;
import net.skinsrestorer.shared.subjects.messages.ComponentHelper;
import net.skinsrestorer.shared.subjects.messages.ComponentString;
import net.skinsrestorer.shared.utils.SRHelpers;
import net.skinsrestorer.shared.utils.UUIDUtils;
import net.skinsrestorer.shared.utils.ValidationUtil;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={1.class, ProfileGetter.class})
public class SkinStorageImpl
implements SkinStorage {
    public static final String RECOMMENDATION_PREFIX = "sr-recommendation-";
    private final SRLogger logger;
    private final CacheStorageImpl cacheStorage;
    private final MojangAPIImpl mojangAPI;
    private final MineSkinAPIImpl mineSkinAPI;
    private final SettingsManager settings;
    private final AdapterReference adapterReference;
    private final RecommendationsState recommendationsState;

    public void preloadDefaultSkins() {
        if (!this.settings.getProperty(StorageConfig.DEFAULT_SKINS_ENABLED).booleanValue()) {
            return;
        }
        ArrayList toRemove = new ArrayList();
        ArrayList defaultSkins = new ArrayList(this.settings.getProperty(StorageConfig.DEFAULT_SKINS));
        defaultSkins.forEach(skin -> {
            if (skin.equalsIgnoreCase("<random>")) {
                return;
            }
            try {
                this.findOrCreateSkinData((String)skin);
            }
            catch (DataRequestException | MineSkinException e) {
                this.logger.debug(J_L_String.formatted("DefaultSkin '%s' could not be found or requested! Removing from list..", skin), e);
                toRemove.add(skin);
            }
        });
        if (!toRemove.isEmpty()) {
            defaultSkins.removeAll(toRemove);
            this.settings.setProperty(StorageConfig.DEFAULT_SKINS, defaultSkins);
        }
        if (defaultSkins.isEmpty()) {
            this.logger.warning("[WARNING] No more working DefaultSkin left... disabling feature");
            this.settings.setProperty(StorageConfig.DEFAULT_SKINS_ENABLED, false);
        }
    }

    @Override
    public Optional<SkinProperty> updatePlayerSkinData(UUID uuid) throws DataRequestException {
        return this.updatePlayerSkinData(uuid, this.mojangAPI::getProfileMojang, false, true);
    }

    private Optional<SkinProperty> updatePlayerSkinData(UUID uuid, ProfileGetter profileGetter, boolean skipDbLookup, boolean ignoreExpiry) throws DataRequestException {
        try {
            Optional<SkinProperty> skinProperty;
            Optional<PlayerSkinData> optionalData = skipDbLookup ? Optional.empty() : this.adapterReference.get().getPlayerSkinData(uuid);
            Optional<SkinProperty> currentSkin = optionalData.map(PlayerSkinData::getProperty);
            long timestamp = -1L;
            if (optionalData.isPresent()) {
                PlayerSkinData currentSkinData = (PlayerSkinData)optionalData.get();
                if (!ignoreExpiry && !this.isPlayerSkinExpired(currentSkinData.getTimestamp())) {
                    return currentSkin;
                }
                timestamp = PropertyUtils.getSkinProfileData(currentSkinData.getProperty()).getTimestamp();
            }
            if (J_U_Optional.isEmpty(skinProperty = profileGetter.getProfile(uuid))) {
                return currentSkin;
            }
            MojangProfileResponse response = PropertyUtils.getSkinProfileData(skinProperty.get());
            if (response.getTimestamp() <= timestamp) {
                return currentSkin;
            }
            this.setPlayerSkinData(uuid, response.getProfileName(), skinProperty.get(), SRHelpers.getEpochSecond());
            return skinProperty;
        }
        catch (StorageAdapter.StorageException e) {
            this.logger.warning(J_L_String.formatted("Failed to update skin data for %s", uuid), e);
            return Optional.empty();
        }
    }

    @Override
    public Optional<MojangSkinDataResult> getPlayerSkin(String nameOrUniqueId, boolean allowExpired) throws DataRequestException {
        return this.getPlayerSkin(nameOrUniqueId, allowExpired, false);
    }

    private Optional<MojangSkinDataResult> getPlayerSkin(String nameOrUniqueId, boolean allowExpired, boolean skipDbLookup) throws DataRequestException {
        Optional<UUID> uuidParseResult = UUIDUtils.tryParseUniqueId(nameOrUniqueId);
        if (ValidationUtil.invalidMinecraftUsername(nameOrUniqueId) && J_U_Optional.isEmpty(uuidParseResult)) {
            return Optional.empty();
        }
        try {
            Optional<MojangCacheData> cached;
            if (J_U_Optional.isEmpty(uuidParseResult) && (cached = this.cacheStorage.getCachedData(nameOrUniqueId, allowExpired)).isPresent()) {
                Optional<UUID> optionalUUID = cached.get().getUniqueId();
                if (J_U_Optional.isEmpty(optionalUUID)) {
                    return Optional.empty();
                }
                UUID uuid2 = optionalUUID.get();
                return this.updatePlayerSkinData(uuid2, this.mojangAPI::getProfile, skipDbLookup, false).map(skinProperty -> MojangSkinDataResult.of(uuid2, skinProperty));
            }
            Optional<MojangSkinDataResult> optional = this.mojangAPI.getSkin(nameOrUniqueId);
            if (J_U_Optional.isEmpty(uuidParseResult)) {
                this.adapterReference.get().setCachedUUID(nameOrUniqueId, MojangCacheData.of(optional.map(MojangSkinDataResult::getUniqueId).orElse(null), SRHelpers.getEpochSecond()));
            }
            if (optional.isPresent()) {
                MojangSkinDataResult result = optional.get();
                return this.updatePlayerSkinData(result.getUniqueId(), uuid -> Optional.of(result.getSkinProperty()), skipDbLookup, false).map(skinProperty -> MojangSkinDataResult.of(result.getUniqueId(), skinProperty));
            }
            return optional;
        }
        catch (StorageAdapter.StorageException e) {
            this.logger.warning(J_L_String.formatted("Failed to get skin from cache for %s", nameOrUniqueId), e);
            return Optional.empty();
        }
    }

    @Override
    public void setPlayerSkinData(UUID uuid, String lastKnownName, SkinProperty property, long timestamp) {
        this.adapterReference.get().setPlayerSkinData(uuid, PlayerSkinData.of(uuid, lastKnownName, property, timestamp));
    }

    @Override
    public void setURLSkinData(String url, String mineSkinId, SkinProperty property, SkinVariant skinVariant) {
        this.adapterReference.get().setURLSkinData(url, URLSkinData.of(url, mineSkinId, property, skinVariant));
    }

    @Override
    public void setURLSkinIndex(String url, SkinVariant skinVariant) {
        this.adapterReference.get().setURLSkinIndex(url, URLIndexData.of(url, skinVariant));
    }

    @Override
    public void setCustomSkinData(String skinName, SkinProperty property) {
        skinName = CustomSkinData.sanitizeCustomSkinName(skinName);
        this.adapterReference.get().setCustomSkinData(skinName, CustomSkinData.of(skinName, null, property));
    }

    public void setCustomSkinDisplayName(String skinName, ComponentString displayName) throws StorageAdapter.StorageException {
        skinName = CustomSkinData.sanitizeCustomSkinName(skinName);
        CustomSkinData customSkinData = this.adapterReference.get().getCustomSkinData(skinName).orElseThrow(() -> new IllegalArgumentException("Skin not found"));
        this.adapterReference.get().setCustomSkinData(skinName, CustomSkinData.of(skinName, displayName, customSkinData.getProperty()));
    }

    @Override
    public Optional<InputDataResult> findSkinData(String input, SkinVariant skinVariantHint) {
        input = SRHelpers.sanitizeSkinInput(input);
        try {
            if (ValidationUtil.validSkinUrl(input)) {
                SkinVariant skinVariant;
                if (skinVariantHint != null) {
                    skinVariant = skinVariantHint;
                } else {
                    Optional<URLIndexData> variant = this.adapterReference.get().getURLSkinIndex(input);
                    if (J_U_Optional.isEmpty(variant)) {
                        return Optional.empty();
                    }
                    skinVariant = variant.get().getSkinVariant();
                }
                return this.adapterReference.get().getURLSkinData(input, skinVariant).map(data -> InputDataResult.of(SkinIdentifier.ofURL(data.getUrl(), skinVariant), data.getProperty()));
            }
            Optional<InputDataResult> result = HardcodedSkins.getHardcodedSkin(input);
            if (result.isPresent()) {
                return result;
            }
            Optional<CustomSkinData> customSkinData = this.adapterReference.get().getCustomSkinData(input);
            if (customSkinData.isPresent()) {
                return customSkinData.map(data -> InputDataResult.of(SkinIdentifier.ofCustom(data.getSkinName()), data.getProperty()));
            }
            Optional<UUID> uuid = this.cacheStorage.getUUID(input, false);
            if (J_U_Optional.isEmpty(uuid)) {
                return Optional.empty();
            }
            Optional<PlayerSkinData> playerSkinData = this.adapterReference.get().getPlayerSkinData(uuid.get());
            if (playerSkinData.isPresent()) {
                return playerSkinData.map(data -> InputDataResult.of(SkinIdentifier.ofPlayer((UUID)uuid.get()), data.getProperty()));
            }
        }
        catch (DataRequestException | StorageAdapter.StorageException e) {
            this.logger.warning(J_L_String.formatted("Failed to find skin data for %s", input), e);
        }
        return Optional.empty();
    }

    public ComponentString resolveSkinName(SkinIdentifier identifier) {
        ComponentString componentString;
        switch (identifier.getSkinType()) {
            default: {
                throw new J_L_MatchException(null, null);
            }
            case PLAYER: {
                try {
                    ComponentString componentString2;
                    componentString = componentString2 = ComponentHelper.convertPlainToJson(this.adapterReference.get().getPlayerSkinData(identifier.getPlayerUniqueId()).map(PlayerSkinData::getLastKnownName).orElse(identifier.getIdentifier()));
                }
                catch (StorageAdapter.StorageException e) {
                    ComponentString componentString3;
                    this.logger.warning(J_L_String.formatted("Failed to get skin data for %s", identifier), e);
                    componentString = componentString3 = ComponentHelper.convertPlainToJson(identifier.getIdentifier());
                }
                break;
            }
            case URL: 
            case LEGACY: {
                ComponentString componentString4;
                componentString = componentString4 = ComponentHelper.convertPlainToJson(identifier.getIdentifier());
                break;
            }
            case CUSTOM: {
                RecommenationResponse.SkinInfo skinInfo;
                if (identifier.getIdentifier().startsWith(RECOMMENDATION_PREFIX) && (skinInfo = this.recommendationsState.getRecommendation(identifier.getIdentifier().substring(RECOMMENDATION_PREFIX.length()))) != null) {
                    ComponentString componentString5;
                    componentString = componentString5 = ComponentHelper.convertPlainToJson(skinInfo.getSkinName());
                    break;
                }
                try {
                    ComponentString componentString6;
                    componentString = componentString6 = this.adapterReference.get().getCustomSkinData(identifier.getIdentifier()).flatMap(c -> Optional.ofNullable(c.getDisplayName())).orElse(ComponentHelper.convertPlainToJson(identifier.getIdentifier()));
                }
                catch (StorageAdapter.StorageException e) {
                    ComponentString componentString7;
                    this.logger.warning(J_L_String.formatted("Failed to get skin data for %s", identifier), e);
                    componentString = componentString7 = ComponentHelper.convertPlainToJson(identifier.getIdentifier());
                }
                break;
            }
        }
        return componentString;
    }

    @Override
    public Optional<InputDataResult> findOrCreateSkinData(String input, SkinVariant skinVariantHint) throws DataRequestException, MineSkinException {
        Optional<InputDataResult> skinData = this.findSkinData(input = SRHelpers.sanitizeSkinInput(input), skinVariantHint);
        if (skinData.isPresent()) {
            return skinData;
        }
        if (input.startsWith(RECOMMENDATION_PREFIX)) {
            String skinId = input.substring(RECOMMENDATION_PREFIX.length());
            RecommenationResponse.SkinInfo skinInfo = this.recommendationsState.getRecommendation(skinId);
            if (skinInfo == null) {
                return Optional.empty();
            }
            SkinProperty skinProperty = skinInfo.getSkinProperty();
            this.setCustomSkinData(input, skinProperty);
            return Optional.of(InputDataResult.of(SkinIdentifier.ofCustom(input), skinProperty));
        }
        if (ValidationUtil.validSkinUrl(input)) {
            MineSkinResponse response = this.mineSkinAPI.genSkin(input, skinVariantHint);
            this.setURLSkinByResponse(input, response);
            return Optional.of(InputDataResult.of(SkinIdentifier.ofURL(input, response.getGeneratedVariant()), response.getProperty()));
        }
        return this.getPlayerSkin(input, false, true).map(result -> InputDataResult.of(SkinIdentifier.ofPlayer(result.getUniqueId()), result.getSkinProperty()));
    }

    @Override
    public Optional<SkinProperty> getSkinDataByIdentifier(SkinIdentifier identifier) {
        try {
            Optional<SkinProperty> optional;
            switch (identifier.getSkinType()) {
                default: {
                    throw new J_L_MatchException(null, null);
                }
                case PLAYER: {
                    optional = this.adapterReference.get().getPlayerSkinData(identifier.getPlayerUniqueId()).map(PlayerSkinData::getProperty);
                    break;
                }
                case URL: {
                    optional = this.adapterReference.get().getURLSkinData(identifier.getIdentifier(), identifier.getSkinVariant()).map(URLSkinData::getProperty);
                    break;
                }
                case CUSTOM: {
                    if (identifier.getIdentifier().startsWith(RECOMMENDATION_PREFIX)) {
                        String skinId = identifier.getIdentifier().substring(RECOMMENDATION_PREFIX.length());
                        RecommenationResponse.SkinInfo skinInfo = this.recommendationsState.getRecommendation(skinId);
                        if (skinInfo == null) {
                            optional = Optional.empty();
                            break;
                        }
                        optional = Optional.of(skinInfo.getSkinProperty());
                        break;
                    }
                    Optional<SkinProperty> skinProperty = this.adapterReference.get().getCustomSkinData(identifier.getIdentifier()).map(CustomSkinData::getProperty);
                    if (skinProperty.isPresent()) {
                        optional = skinProperty;
                        break;
                    }
                    optional = HardcodedSkins.getHardcodedSkin(identifier.getIdentifier()).map(InputDataResult::getProperty);
                    break;
                }
                case LEGACY: {
                    optional = this.adapterReference.get().getLegacySkinData(identifier.getIdentifier()).map(LegacySkinData::getProperty);
                }
            }
            return optional;
        }
        catch (StorageAdapter.StorageException e) {
            this.logger.warning(J_L_String.formatted("Failed to get skin data for %s", identifier), e);
            return Optional.empty();
        }
    }

    @Override
    public void removeSkinData(SkinIdentifier identifier) {
        switch (identifier.getSkinType()) {
            case PLAYER: {
                this.adapterReference.get().removePlayerSkinData(identifier.getPlayerUniqueId());
                break;
            }
            case URL: {
                this.adapterReference.get().removeURLSkinData(identifier.getIdentifier(), identifier.getSkinVariant());
                break;
            }
            case CUSTOM: {
                this.adapterReference.get().removeCustomSkinData(identifier.getIdentifier());
                break;
            }
            case LEGACY: {
                this.adapterReference.get().removeLegacySkinData(identifier.getIdentifier());
            }
        }
    }

    private boolean isPlayerSkinExpired(long timestamp) {
        if (timestamp == -1L || this.settings.getProperty(StorageConfig.DISALLOW_AUTO_UPDATE_SKIN).booleanValue()) {
            return false;
        }
        long now = SRHelpers.getEpochSecond();
        long expiryDate = timestamp + TimeUnit.MINUTES.toSeconds(this.settings.getProperty(StorageConfig.SKIN_EXPIRES_AFTER).intValue());
        return expiryDate <= now;
    }

    public boolean purgeOldSkins(int days) {
        long targetPurgeTimestamp = Instant.now().minus(days, ChronoUnit.DAYS).getEpochSecond();
        try {
            this.adapterReference.get().purgeStoredOldSkins(targetPurgeTimestamp);
            return true;
        }
        catch (StorageAdapter.StorageException e) {
            this.logger.severe("Failed to purge old skins", e);
            return false;
        }
    }

    @Inject
    @Generated
    public SkinStorageImpl(SRLogger logger, CacheStorageImpl cacheStorage, MojangAPIImpl mojangAPI, MineSkinAPIImpl mineSkinAPI, SettingsManager settings, AdapterReference adapterReference, RecommendationsState recommendationsState) {
        this.logger = logger;
        this.cacheStorage = cacheStorage;
        this.mojangAPI = mojangAPI;
        this.mineSkinAPI = mineSkinAPI;
        this.settings = settings;
        this.adapterReference = adapterReference;
        this.recommendationsState = recommendationsState;
    }

    @NestHost(value=SkinStorageImpl.class)
    private static interface ProfileGetter {
        public Optional<SkinProperty> getProfile(UUID var1) throws DataRequestException;
    }
}

