/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.storage.adapter;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.skinsrestorer.api.property.SkinIdentifier;
import net.skinsrestorer.api.property.SkinType;
import net.skinsrestorer.api.property.SkinVariant;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_Optional;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_List;
import net.skinsrestorer.shared.gui.GUIUtils;
import net.skinsrestorer.shared.storage.model.cache.MojangCacheData;
import net.skinsrestorer.shared.storage.model.player.LegacyPlayerData;
import net.skinsrestorer.shared.storage.model.player.PlayerData;
import net.skinsrestorer.shared.storage.model.skin.CustomSkinData;
import net.skinsrestorer.shared.storage.model.skin.LegacySkinData;
import net.skinsrestorer.shared.storage.model.skin.PlayerSkinData;
import net.skinsrestorer.shared.storage.model.skin.URLIndexData;
import net.skinsrestorer.shared.storage.model.skin.URLSkinData;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@NestMembers(value={StorageCooldown.class, StorageException.class})
public interface StorageAdapter {
    public void init();

    public Optional<PlayerData> getPlayerData(UUID var1) throws StorageException;

    public void setPlayerData(UUID var1, PlayerData var2);

    public Optional<PlayerSkinData> getPlayerSkinData(UUID var1) throws StorageException;

    public void removePlayerSkinData(UUID var1);

    public void setPlayerSkinData(UUID var1, PlayerSkinData var2);

    public Optional<URLSkinData> getURLSkinData(String var1, SkinVariant var2) throws StorageException;

    public void removeURLSkinData(String var1, SkinVariant var2);

    public void setURLSkinData(String var1, URLSkinData var2);

    public Optional<URLIndexData> getURLSkinIndex(String var1) throws StorageException;

    public void removeURLSkinIndex(String var1);

    public void setURLSkinIndex(String var1, URLIndexData var2);

    public Optional<CustomSkinData> getCustomSkinData(String var1) throws StorageException;

    public void removeCustomSkinData(String var1);

    public void setCustomSkinData(String var1, CustomSkinData var2);

    public Optional<LegacySkinData> getLegacySkinData(String var1) throws StorageException;

    public void removeLegacySkinData(String var1);

    public Optional<LegacyPlayerData> getLegacyPlayerData(String var1) throws StorageException;

    public void removeLegacyPlayerData(String var1);

    public int getTotalCustomSkins();

    public List<GUIUtils.GUIRawSkinEntry> getCustomGUISkins(int var1, int var2);

    public int getTotalPlayerSkins();

    public List<GUIUtils.GUIRawSkinEntry> getPlayerGUISkins(int var1, int var2);

    public void purgeStoredOldSkins(long var1) throws StorageException;

    public Optional<MojangCacheData> getCachedUUID(String var1) throws StorageException;

    public void setCachedUUID(String var1, MojangCacheData var2);

    public List<UUID> getAllCooldownProfiles() throws StorageException;

    public List<StorageCooldown> getCooldowns(UUID var1) throws StorageException;

    public void setCooldown(UUID var1, String var2, Instant var3, Duration var4);

    public void removeCooldown(UUID var1, String var2);

    default public void migrateLegacyPlayer(String playerName, UUID uuid) throws StorageException {
        Optional<LegacyPlayerData> legacyPlayerData = this.getLegacyPlayerData(playerName);
        if (J_U_Optional.isEmpty(legacyPlayerData)) {
            return;
        }
        Optional<CustomSkinData> customSkinData = this.getCustomSkinData(legacyPlayerData.get().getSkinName());
        this.setPlayerData(uuid, customSkinData.map(skinData -> PlayerData.of(uuid, SkinIdentifier.ofCustom(skinData.getSkinName()), J_U_List.of(), J_U_List.of())).orElseGet(() -> PlayerData.of(uuid, SkinIdentifier.of(((LegacyPlayerData)legacyPlayerData.get()).getSkinName(), null, SkinType.LEGACY), J_U_List.of(), J_U_List.of())));
        this.removeLegacyPlayerData(playerName);
    }

    default public boolean isLegacyCustomSkinTimestamp(long timestamp) {
        if (timestamp == 0L || timestamp == -1L) {
            return true;
        }
        return timestamp >= 4102444800000L;
    }

    @RecordComponents(value={@RecordComponents.Value(name="owner", type=UUID.class), @RecordComponents.Value(name="groupName", type=String.class), @RecordComponents.Value(name="creationTime", type=Instant.class), @RecordComponents.Value(name="duration", type=Duration.class)})
    @NestHost(value=StorageAdapter.class)
    public static final class StorageCooldown
    extends J_L_Record {
        private final UUID owner;
        private final String groupName;
        private final Instant creationTime;
        private final Duration duration;

        public StorageCooldown(UUID owner, String groupName, Instant creationTime, Duration duration) {
            this.owner = owner;
            this.groupName = groupName;
            this.creationTime = creationTime;
            this.duration = duration;
        }

        @Override
        public final String toString() {
            return StorageCooldown.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return StorageCooldown.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return StorageCooldown.jvmdowngrader$equals$equals(this, o);
        }

        public UUID owner() {
            return this.owner;
        }

        public String groupName() {
            return this.groupName;
        }

        public Instant creationTime() {
            return this.creationTime;
        }

        public Duration duration() {
            return this.duration;
        }

        private static /* synthetic */ String jvmdowngrader$toString$toString(StorageCooldown storageCooldown) {
            StorageCooldown storageCooldown2 = storageCooldown;
            return "StorageAdapter$StorageCooldown[" + "owner=" + storageCooldown.owner + ", " + "groupName=" + storageCooldown.groupName + ", " + "creationTime=" + storageCooldown.creationTime + ", " + "duration=" + storageCooldown.duration + "]";
        }

        private static /* synthetic */ int jvmdowngrader$hashCode$hashCode(StorageCooldown storageCooldown) {
            Object[] objectArray = new Object[]{storageCooldown.owner, storageCooldown.groupName, storageCooldown.creationTime, storageCooldown.duration};
            return Arrays.hashCode(objectArray);
        }

        private static /* synthetic */ boolean jvmdowngrader$equals$equals(StorageCooldown storageCooldown, Object object) {
            if (storageCooldown == object) {
                return true;
            }
            if (object != null && object instanceof StorageCooldown) {
                StorageCooldown storageCooldown2 = (StorageCooldown)object;
                if (Objects.equals(storageCooldown.owner, storageCooldown2.owner) && Objects.equals(storageCooldown.groupName, storageCooldown2.groupName) && Objects.equals(storageCooldown.creationTime, storageCooldown2.creationTime) && Objects.equals(storageCooldown.duration, storageCooldown2.duration)) {
                    return true;
                }
            }
            return false;
        }
    }

    @NestHost(value=StorageAdapter.class)
    public static class StorageException
    extends Exception {
        public StorageException(Throwable cause) {
            super(cause);
        }
    }
}

