/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.storage.adapter.file.model.player;

import java.util.List;
import java.util.UUID;
import lombok.Generated;
import net.skinsrestorer.api.property.SkinIdentifier;
import net.skinsrestorer.api.property.SkinType;
import net.skinsrestorer.api.property.SkinVariant;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_List;
import net.skinsrestorer.shared.storage.model.player.FavouriteData;
import net.skinsrestorer.shared.storage.model.player.HistoryData;
import net.skinsrestorer.shared.storage.model.player.PlayerData;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={FavouritesFile.class, HistoryFile.class, IdentifierFile.class})
public class PlayerFile {
    private static final int CURRENT_DATA_VERSION = 1;
    private UUID uniqueId;
    private IdentifierFile skinIdentifier;
    private List<HistoryFile> history;
    private List<FavouritesFile> favourites;
    private int dataVersion;

    public static PlayerFile fromPlayerData(PlayerData playerData) {
        PlayerFile playerFile = new PlayerFile();
        playerFile.uniqueId = playerData.getUniqueId();
        playerFile.skinIdentifier = IdentifierFile.of(playerData.getSkinIdentifier());
        playerFile.dataVersion = 1;
        playerFile.history = J_U_S_Stream.toList(playerData.getHistory().stream().map(HistoryFile::of));
        playerFile.favourites = J_U_S_Stream.toList(playerData.getFavourites().stream().map(FavouritesFile::of));
        return playerFile;
    }

    public PlayerData toPlayerData() {
        return PlayerData.of(this.uniqueId, this.skinIdentifier == null ? null : this.skinIdentifier.toIdentifier(), this.history == null ? J_U_List.of() : J_U_S_Stream.toList(this.history.stream().map(HistoryFile::toHistoryData)), this.favourites == null ? J_U_List.of() : J_U_S_Stream.toList(this.favourites.stream().map(FavouritesFile::toFavouritesData)));
    }

    @Generated
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Generated
    public IdentifierFile getSkinIdentifier() {
        return this.skinIdentifier;
    }

    @Generated
    public List<HistoryFile> getHistory() {
        return this.history;
    }

    @Generated
    public List<FavouritesFile> getFavourites() {
        return this.favourites;
    }

    @Generated
    public int getDataVersion() {
        return this.dataVersion;
    }

    @Generated
    public PlayerFile() {
    }

    @NestHost(value=PlayerFile.class)
    public static class IdentifierFile {
        private String identifier;
        private SkinVariant skinVariant;
        private SkinType type;

        public static IdentifierFile of(SkinIdentifier identifier) {
            if (identifier == null) {
                return null;
            }
            return new IdentifierFile(identifier.getIdentifier(), identifier.getSkinVariant(), identifier.getSkinType());
        }

        public SkinIdentifier toIdentifier() {
            return SkinIdentifier.of(this.identifier, this.skinVariant, this.type);
        }

        @Generated
        public String getIdentifier() {
            return this.identifier;
        }

        @Generated
        public SkinVariant getSkinVariant() {
            return this.skinVariant;
        }

        @Generated
        public SkinType getType() {
            return this.type;
        }

        @Generated
        public IdentifierFile() {
        }

        @Generated
        private IdentifierFile(String identifier, SkinVariant skinVariant, SkinType type) {
            this.identifier = identifier;
            this.skinVariant = skinVariant;
            this.type = type;
        }

        @NotNull
        @Generated
        public static IdentifierFile of(String identifier, SkinVariant skinVariant, SkinType type) {
            return new IdentifierFile(identifier, skinVariant, type);
        }
    }

    @NestHost(value=PlayerFile.class)
    public static class FavouritesFile {
        private long timestamp;
        private IdentifierFile skinIdentifier;

        public static FavouritesFile of(FavouriteData favouriteData) {
            if (favouriteData == null) {
                return null;
            }
            return new FavouritesFile(favouriteData.getTimestamp(), IdentifierFile.of(favouriteData.getSkinIdentifier()));
        }

        public FavouriteData toFavouritesData() {
            return FavouriteData.of(this.timestamp, this.skinIdentifier.toIdentifier());
        }

        @Generated
        public long getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public IdentifierFile getSkinIdentifier() {
            return this.skinIdentifier;
        }

        @Generated
        public FavouritesFile() {
        }

        @Generated
        private FavouritesFile(long timestamp, IdentifierFile skinIdentifier) {
            this.timestamp = timestamp;
            this.skinIdentifier = skinIdentifier;
        }

        @NotNull
        @Generated
        public static FavouritesFile of(long timestamp, IdentifierFile skinIdentifier) {
            return new FavouritesFile(timestamp, skinIdentifier);
        }
    }

    @NestHost(value=PlayerFile.class)
    public static class HistoryFile {
        private long timestamp;
        private IdentifierFile skinIdentifier;

        public static HistoryFile of(HistoryData historyData) {
            if (historyData == null) {
                return null;
            }
            return new HistoryFile(historyData.getTimestamp(), IdentifierFile.of(historyData.getSkinIdentifier()));
        }

        public HistoryData toHistoryData() {
            return HistoryData.of(this.timestamp, this.skinIdentifier.toIdentifier());
        }

        @Generated
        public long getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public IdentifierFile getSkinIdentifier() {
            return this.skinIdentifier;
        }

        @Generated
        public HistoryFile() {
        }

        @Generated
        private HistoryFile(long timestamp, IdentifierFile skinIdentifier) {
            this.timestamp = timestamp;
            this.skinIdentifier = skinIdentifier;
        }

        @NotNull
        @Generated
        public static HistoryFile of(long timestamp, IdentifierFile skinIdentifier) {
            return new HistoryFile(timestamp, skinIdentifier);
        }
    }
}

